/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;

public class CleanMetadataHelper {
    File jam = null;

    public void setUpWithSomeProperties(List<String> properties) throws IOException {
        this.jam = File.createTempFile("CleanMetadataHelper", "jam");
        this.jam.delete();
        this.jam.mkdirs();
        new File(this.jam.getAbsolutePath() + "/metadata").mkdir();
        File tempKylinProperties = new File(this.jam, "kylin.properties");
        this.jam.deleteOnExit();
        tempKylinProperties.createNewFile();
        if (properties != null) {
            FileUtils.writeLines((File)tempKylinProperties, properties);
        }
        KylinConfig.setKylinConfigForLocalTest(this.jam.getCanonicalPath());
    }

    public void setUp() throws IOException {
        this.setUpWithSomeProperties(null);
    }

    public void tearDown() {
        this.jam.delete();
        Unsafe.clearProperty("KYLIN_CONF");
        KylinConfig.destroyInstance();
    }
}

