/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtils {
    private static final Logger logger = LoggerFactory.getLogger(CompressionUtils.class);
    private static final byte[] GZIP = "GZIP".getBytes(Charset.defaultCharset());

    /*
     * Loose catch block
     */
    public static byte[] compress(byte[] data) throws IOException {
        if (!KylinConfig.getInstanceFromEnv().isMetadataCompressEnabled() || data == null || data.length == 0 || CompressionUtils.isCompressed(data)) {
            return data;
        }
        Deflater deflater = new Deflater(1);
        try {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
                long startTime = System.currentTimeMillis();
                deflater.setInput(data);
                deflater.finish();
                byte[] buffer = new byte[1024];
                while (!deflater.finished()) {
                    int count = deflater.deflate(buffer);
                    outputStream.write(buffer, 0, count);
                }
                outputStream.flush();
                byte[] output = outputStream.toByteArray();
                logger.trace("Original: {} bytes. Compressed: {} bytes. Time: {}", new Object[]{data.length, output.length, System.currentTimeMillis() - startTime});
                byte[] byArray = BytesUtil.mergeBytes(GZIP, output);
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            deflater.end();
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        if (data == null || data.length == 0 || !CompressionUtils.isCompressed(data)) {
            return data;
        }
        data = BytesUtil.subarray(data, GZIP.length, data.length);
        Inflater inflater = new Inflater();
        try {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
                long startTime = System.currentTimeMillis();
                inflater.setInput(data);
                byte[] buffer = new byte[1024];
                while (!inflater.finished()) {
                    int count = inflater.inflate(buffer);
                    outputStream.write(buffer, 0, count);
                }
                outputStream.flush();
                byte[] output = outputStream.toByteArray();
                logger.trace("Original: {} bytes. Decompressed: {} bytes. Time: {}", new Object[]{data.length, output.length, System.currentTimeMillis() - startTime});
                byte[] byArray = output;
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inflater.end();
        }
    }

    public static boolean isCompressed(byte[] bytes) {
        boolean isWrapped = false;
        if (bytes.length > GZIP.length) {
            isWrapped = true;
            for (int i = 0; i < GZIP.length; ++i) {
                if (bytes[i] == GZIP[i]) continue;
                isWrapped = false;
                break;
            }
        }
        return isWrapped;
    }

    @Generated
    private CompressionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

