/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm.genetic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStats;

public class BitsChromosomeHelper {
    public final double spaceLimit;
    private final CuboidStats cuboidStats;
    private final CuboidEncoder cuboidEncoder;

    public BitsChromosomeHelper(double spaceLimit, CuboidStats cuboidStats) {
        this.spaceLimit = spaceLimit;
        this.cuboidStats = cuboidStats;
        this.cuboidEncoder = new CuboidEncoder((Set<BigInteger>)cuboidStats.getAllCuboidsForSelection());
    }

    public ImmutableSet<BigInteger> getMandatoryCuboids() {
        return this.cuboidStats.getAllCuboidsForMandatory();
    }

    public List<BigInteger> toCuboidList(BitSet bits) {
        return this.cuboidEncoder.toCuboidList(bits);
    }

    public double getCuboidSize(Set<BigInteger> cuboids) {
        double ret = 0.0;
        for (BigInteger cuboid : cuboids) {
            ret += this.cuboidStats.getCuboidSize(cuboid).doubleValue();
        }
        return ret;
    }

    public double getCuboidSizeByBitIndex(int index) {
        return this.cuboidStats.getCuboidSize((BigInteger)this.cuboidEncoder.cuboidDomain.get(index));
    }

    public int getLength() {
        return this.cuboidEncoder.cuboidDomain.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitsChromosomeHelper that = (BitsChromosomeHelper)o;
        return this.cuboidEncoder != null ? this.cuboidEncoder.equals(that.cuboidEncoder) : that.cuboidEncoder == null;
    }

    public int hashCode() {
        return this.cuboidEncoder != null ? this.cuboidEncoder.hashCode() : 0;
    }

    private static class CuboidEncoder {
        public final ImmutableList<BigInteger> cuboidDomain;

        public CuboidEncoder(Set<BigInteger> cuboidSet) {
            ArrayList cuboidList = Lists.newArrayList(cuboidSet);
            Collections.sort(cuboidList, Collections.reverseOrder());
            this.cuboidDomain = ImmutableList.copyOf((Collection)cuboidList);
        }

        public List<BigInteger> toCuboidList(BitSet bits) {
            ArrayList cuboids = Lists.newArrayListWithExpectedSize((int)bits.cardinality());
            int i = bits.nextSetBit(0);
            while (i >= 0) {
                cuboids.add(this.cuboidDomain.get(i));
                i = bits.nextSetBit(i + 1);
            }
            return cuboids;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CuboidEncoder that = (CuboidEncoder)o;
            return this.cuboidDomain != null ? this.cuboidDomain.equals(that.cuboidDomain) : that.cuboidDomain == null;
        }

        public int hashCode() {
            return this.cuboidDomain != null ? this.cuboidDomain.hashCode() : 0;
        }
    }
}

