/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryAutoConfiguration;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnBlockingDiscoveryEnabled
@ConditionalOnZookeeperDiscoveryEnabled
@AutoConfigureBefore(value={ZookeeperDiscoveryAutoConfiguration.class})
public class ZookeeperDiscoveryClientConfiguration {
    @Autowired(required=false)
    private ZookeeperDependencies zookeeperDependencies;

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperDiscoveryClient zookeeperDiscoveryClient(ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        return new ZookeeperDiscoveryClient(serviceDiscovery, this.zookeeperDependencies, zookeeperDiscoveryProperties);
    }

    @Bean
    public Marker zookeeperDiscoveryClientMarker() {
        return new Marker();
    }

    class Marker {
        Marker() {
        }
    }
}

