/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory;

import org.apache.spark.TaskContext;
import org.apache.spark.task.TaskResource;
import org.apache.spark.task.TaskResources;

public class CHThreadGroup
implements TaskResource {
    private long thread_group_id = 0L;
    private long peak_memory = -1L;

    public static void registerNewThreadGroup() {
        if (TaskResources.isResourceRegistered((String)CHThreadGroup.class.getName())) {
            return;
        }
        String taskId = "";
        if (TaskResources.getLocalTaskContext() != null) {
            taskId = String.valueOf(TaskResources.getLocalTaskContext().taskAttemptId());
        }
        CHThreadGroup group = new CHThreadGroup(taskId);
        TaskResources.addResource((String)CHThreadGroup.class.getName(), (TaskResource)group);
        TaskContext.get().addTaskCompletionListener(context -> context.taskMetrics().incPeakExecutionMemory(group.getPeakMemory()));
    }

    private CHThreadGroup(String taskId) {
        this.thread_group_id = CHThreadGroup.createThreadGroup(taskId);
    }

    public long getPeakMemory() {
        if (this.peak_memory < 0L) {
            this.peak_memory = CHThreadGroup.threadGroupPeakMemory(this.thread_group_id);
        }
        return this.peak_memory;
    }

    public void release() throws Exception {
        if (this.peak_memory < 0L) {
            this.peak_memory = CHThreadGroup.threadGroupPeakMemory(this.thread_group_id);
        }
        CHThreadGroup.releaseThreadGroup(this.thread_group_id);
    }

    public int priority() {
        return super.priority();
    }

    public String resourceName() {
        return "CHThreadGroup";
    }

    private static native long createThreadGroup(String var0);

    private static native long threadGroupPeakMemory(long var0);

    private static native void releaseThreadGroup(long var0);
}

