/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaUDF$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeleteCommand$;
import org.apache.spark.sql.delta.commands.DeleteCommandMetrics;
import org.apache.spark.sql.delta.commands.DeleteMetric;
import org.apache.spark.sql.delta.commands.DeleteWithDeletionVectorsHelper$;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.MergeIntoCommand$;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u0014(\u0001RB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00053\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005a\u0001\tE\t\u0015!\u00036\u0011!\t\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B2\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011\t;\t\u0013\u0005\r\u0002A1A\u0005B\u0005\u0015\u0002\u0002CA\u0018\u0001\u0001\u0006I!a\n\t\u0015\u0005E\u0002\u0001#b\u0001\n\u0003\n\u0019\u0004C\u0004\u0002X\u0001!)%!\u0017\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\n\u00033\u0004\u0011\u0011!C\u0001\u00037D\u0011\"a9\u0001#\u0003%\t!!:\t\u0013\u0005m\b!%A\u0005\u0002\u0005u\b\"\u0003B\u0001\u0001E\u0005I\u0011\u0001B\u0002\u0011%\u00119\u0001AA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\u001a\u0001\t\t\u0011\"\u0001\u0003\u001c!I!1\u0005\u0001\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005W\u0001\u0011\u0011!C!\u0005[A\u0011Ba\u000f\u0001\u0003\u0003%\tA!\u0010\t\u0013\t\u0005\u0003!!A\u0005B\t\rsa\u0002B$O!\u0005!\u0011\n\u0004\u0007M\u001dB\tAa\u0013\t\r5\\B\u0011\u0001B*\u0011\u001d\u0011)f\u0007C\u0001\u0005/B\u0011Ba\u0019\u001c\u0005\u0004%\tA!\u001a\t\u0011\t\u001d4\u0004)A\u0005\u0003\u000bB\u0011B!\u001b\u001c\u0005\u0004%\tA!\u001a\t\u0011\t-4\u0004)A\u0005\u0003\u000bBqA!\u001c\u001c\t\u0003\u0011y\u0007C\u0005\u0003Vm\t\t\u0011\"!\u0003t!I!1P\u000e\u0002\u0002\u0013\u0005%Q\u0010\u0005\n\u0005\u0017[\u0012\u0011!C\u0005\u0005\u001b\u0013Q\u0002R3mKR,7i\\7nC:$'B\u0001\u0015*\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u0016,\u0003\u0015!W\r\u001c;b\u0015\taS&A\u0002tc2T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001'\u001d\u0001QgP$L\u001dR\u0003\"AN\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u000f1|w-[2bY*\u0011!hO\u0001\u0006a2\fgn\u001d\u0006\u0003y-\n\u0001bY1uC2L8\u000f^\u0005\u0003}]\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\bG>lW.\u00198e\u0015\t!5&A\u0005fq\u0016\u001cW\u000f^5p]&\u0011a)\u0011\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003\u0011&k\u0011aJ\u0005\u0003\u0015\u001e\u0012A\u0002R3mi\u0006\u001cu.\\7b]\u0012\u0004\"\u0001\u0013'\n\u00055;#\u0001\u0006#fY\u0016$XmQ8n[\u0006tG-T3ue&\u001c7\u000f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006KA\u0004Qe>$Wo\u0019;\u0011\u0005=+\u0016B\u0001,Q\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!!W\r\u001c;b\u0019><W#A-\u0011\u0005i[V\"A\u0015\n\u0005qK#\u0001\u0003#fYR\fGj\\4\u0002\u0013\u0011,G\u000e^1M_\u001e\u0004\u0013A\u0002;be\u001e,G/F\u00016\u0003\u001d!\u0018M]4fi\u0002\n\u0011bY8oI&$\u0018n\u001c8\u0016\u0003\r\u00042a\u00143g\u0013\t)\u0007K\u0001\u0004PaRLwN\u001c\t\u0003O*l\u0011\u0001\u001b\u0006\u0003Sn\n1\"\u001a=qe\u0016\u001c8/[8og&\u00111\u000e\u001b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AC2p]\u0012LG/[8oA\u00051A(\u001b8jiz\"Ba\u001c9reB\u0011\u0001\n\u0001\u0005\u0006/\u001e\u0001\r!\u0017\u0005\u0006=\u001e\u0001\r!\u000e\u0005\u0006C\u001e\u0001\raY\u0001\u000eS:tWM]\"iS2$'/\u001a8\u0016\u0003U\u0004BA\u001e@\u0002\u00049\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003uN\na\u0001\u0010:p_Rt\u0014\"A)\n\u0005u\u0004\u0016a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!aA*fc*\u0011Q\u0010\u0015\u0019\u0005\u0003\u000b\t\t\u0002\u0005\u0004\u0002\b\u0005%\u0011QB\u0007\u0002s%\u0019\u00111B\u001d\u0003\u0013E+XM]=QY\u0006t\u0007\u0003BA\b\u0003#a\u0001\u0001B\u0006\u0002\u0014!\t\t\u0011!A\u0003\u0002\u0005U!aA0%cE!\u0011qCA\u000f!\ry\u0015\u0011D\u0005\u0004\u00037\u0001&a\u0002(pi\"Lgn\u001a\t\u0004\u001f\u0006}\u0011bAA\u0011!\n\u0019\u0011I\\=\u0002\r=,H\u000f];u+\t\t9\u0003\u0005\u0003w}\u0006%\u0002cA4\u0002,%\u0019\u0011Q\u00065\u0003\u0013\u0005#HO]5ckR,\u0017aB8viB,H\u000fI\u0001\b[\u0016$(/[2t+\t\t)\u0004\u0005\u0005\u00028\u0005}\u0012QIA&\u001d\u0011\tI$a\u000f\u0011\u0005a\u0004\u0016bAA\u001f!\u00061\u0001K]3eK\u001aLA!!\u0011\u0002D\t\u0019Q*\u00199\u000b\u0007\u0005u\u0002\u000b\u0005\u0003\u00028\u0005\u001d\u0013\u0002BA%\u0003\u0007\u0012aa\u0015;sS:<\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E3)\u0001\u0004nKR\u0014\u0018nY\u0005\u0005\u0003+\nyEA\u0005T#2kU\r\u001e:jG\u0006\u0019!/\u001e8\u0015\t\u0005m\u0013Q\r\t\u0005mz\fi\u0006\u0005\u0003\u0002`\u0005\u0005T\"A\u0016\n\u0007\u0005\r4FA\u0002S_^Dq!a\u001a\r\u0001\u0004\tI'\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0003\u0002`\u0005-\u0014bAA7W\ta1\u000b]1sWN+7o]5p]\u0006i\u0001/\u001a:g_JlG)\u001a7fi\u0016$\u0002\"a\u001d\u0002\u0002\u0006\r\u0015Q\u0011\t\u0005mz\f)\b\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY(K\u0001\bC\u000e$\u0018n\u001c8t\u0013\u0011\ty(!\u001f\u0003\r\u0005\u001bG/[8o\u0011\u001d\t9'\u0004a\u0001\u0003SBQaV\u0007A\u0002eCq!a\"\u000e\u0001\u0004\tI)A\u0002uq:\u00042AWAF\u0013\r\ti)\u000b\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u00031\u0011Xm\u001e:ji\u00164\u0015\u000e\\3t))\t\u0019*a'\u0002\u001e\u0006u\u0016\u0011\u0019\t\u0005mz\f)\n\u0005\u0003\u0002x\u0005]\u0015\u0002BAM\u0003s\u0012!BR5mK\u0006\u001bG/[8o\u0011\u001d\t9I\u0004a\u0001\u0003\u0013Cq!a(\u000f\u0001\u0004\t\t+\u0001\u0005cCN,G)\u0019;b!\u0011\t\u0019+a.\u000f\t\u0005\u0015\u0016Q\u0017\b\u0005\u0003O\u000b\u0019L\u0004\u0003\u0002*\u0006Ef\u0002BAV\u0003_s1\u0001_AW\u0013\u0005\u0011\u0014B\u0001\u00192\u0013\tqs&\u0003\u0002-[%\u0011QpK\u0005\u0005\u0003s\u000bYLA\u0005ECR\fgI]1nK*\u0011Qp\u000b\u0005\u0007\u0003\u007fs\u0001\u0019\u00014\u0002\u001f\u0019LG\u000e^3s\u0007>tG-\u001b;j_:Dq!a1\u000f\u0001\u0004\t)-A\tok64\u0015\u000e\\3t)>\u0014Vm\u001e:ji\u0016\u00042aTAd\u0013\r\tI\r\u0015\u0002\u0005\u0019>tw-\u0001\u0013tQ>,H\u000eZ,sSR,\u0007+\u001a:tSN$XM\u001c;EK2,G/[8o-\u0016\u001cGo\u001c:t)\u0019\ty-!6\u0002XB\u0019q*!5\n\u0007\u0005M\u0007KA\u0004C_>dW-\u00198\t\r9z\u0001\u0019AA5\u0011\u001d\t9i\u0004a\u0001\u0003\u0013\u000bAaY8qsR9q.!8\u0002`\u0006\u0005\bbB,\u0011!\u0003\u0005\r!\u0017\u0005\b=B\u0001\n\u00111\u00016\u0011\u001d\t\u0007\u0003%AA\u0002\r\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002h*\u001a\u0011,!;,\u0005\u0005-\b\u0003BAw\u0003ol!!a<\u000b\t\u0005E\u00181_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!>Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\fyOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0000*\u001aQ'!;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0001\u0016\u0004G\u0006%\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\fA!!Q\u0002B\f\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011\u0001\u00027b]\u001eT!A!\u0006\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\u0012y!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\u001eA\u0019qJa\b\n\u0007\t\u0005\u0002KA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001e\t\u001d\u0002\"\u0003B\u0015-\u0005\u0005\t\u0019\u0001B\u000f\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0006\t\u0007\u0005c\u00119$!\b\u000e\u0005\tM\"b\u0001B\u001b!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te\"1\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002P\n}\u0002\"\u0003B\u00151\u0005\u0005\t\u0019AA\u000f\u0003\u0019)\u0017/^1mgR!\u0011q\u001aB#\u0011%\u0011I#GA\u0001\u0002\u0004\ti\"A\u0007EK2,G/Z\"p[6\fg\u000e\u001a\t\u0003\u0011n\u0019Ba\u0007B')B\u0019qJa\u0014\n\u0007\tE\u0003K\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u0013\nQ!\u00199qYf$2a\u001cB-\u0011\u001d\u0011Y&\ba\u0001\u0005;\na\u0001Z3mKR,\u0007c\u0001\u001c\u0003`%\u0019!\u0011M\u001c\u0003\u0017\u0011+G\u000e^1EK2,G/Z\u0001\u0011\r&cUi\u0018(B\u001b\u0016{6i\u0014'V\u001b:+\"!!\u0012\u0002#\u0019KE*R0O\u00036+ulQ(M+6s\u0005%A\rG\u0013:#\u0015JT$`)>+6\tS#E?\u001aKE*R*`\u001bN;\u0015A\u0007$J\u001d\u0012KejR0U\u001fV\u001b\u0005*\u0012#`\r&cUiU0N'\u001e\u0003\u0013!\u0005:foJLG/\u001b8h\r&dWm]'tOR!\u0011Q\tB9\u0011\u001d\t\u0019M\ta\u0001\u0003\u000b$ra\u001cB;\u0005o\u0012I\bC\u0003XG\u0001\u0007\u0011\fC\u0003_G\u0001\u0007Q\u0007C\u0003bG\u0001\u00071-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t}$q\u0011\t\u0005\u001f\u0012\u0014\t\t\u0005\u0004P\u0005\u0007KVgY\u0005\u0004\u0005\u000b\u0003&A\u0002+va2,7\u0007\u0003\u0005\u0003\n\u0012\n\t\u00111\u0001p\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0010B!!Q\u0002BI\u0013\u0011\u0011\u0019Ja\u0004\u0003\r=\u0013'.Z2u\u0001")
public class DeleteCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
DeleteCommandMetrics,
scala.Serializable {
    private Map<String, SQLMetric> metrics;
    private final DeltaLog deltaLog;
    private final LogicalPlan target;
    private final Option<Expression> condition;
    private final Seq<Attribute> output;
    private transient SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<DeltaLog, LogicalPlan, Option<Expression>>> unapply(DeleteCommand deleteCommand) {
        return DeleteCommand$.MODULE$.unapply(deleteCommand);
    }

    public static String rewritingFilesMsg(long l) {
        return DeleteCommand$.MODULE$.rewritingFilesMsg(l);
    }

    public static String FINDING_TOUCHED_FILES_MSG() {
        return DeleteCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG();
    }

    public static String FILE_NAME_COLUMN() {
        return DeleteCommand$.MODULE$.FILE_NAME_COLUMN();
    }

    @Override
    public Map<String, SQLMetric> createMetrics() {
        return DeleteCommandMetrics.createMetrics$(this);
    }

    @Override
    public Option<Object> getDeletedRowsFromAddFilesAndUpdateMetrics(Seq<AddFile> files) {
        return DeleteCommandMetrics.getDeletedRowsFromAddFilesAndUpdateMetrics$(this, files);
    }

    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$((DeltaCommand)this, (SparkSession)spark, (String)predicate);
    }

    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$((DeltaCommand)this, (SparkSession)spark, partitionColumns, predicates);
    }

    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$((DeltaCommand)this, (Path)basePath, candidateFiles);
    }

    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$((DeltaCommand)this, (DeltaLog)deltaLog, nameToAddFileMap, filesToRewrite, (long)operationTimestamp);
    }

    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$((DeltaCommand)this, (SparkSession)spark, (OptimisticTransaction)txn, (String)actionType, (Path)rootPath, inputLeafFiles, nameToAddFileMap);
    }

    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$((DeltaCommand)this, (Path)basePath, (String)filePath, nameToAddFileMap);
    }

    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)identifier);
    }

    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)tableIdent);
    }

    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$((DeltaCommand)this, (TableIdentifier)tableIdent);
    }

    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$((DeltaCommand)this, (SparkSession)spark, path, tableIdentifier, (String)operationName, hadoopConf);
    }

    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$((DeltaCommand)this);
    }

    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$((DeltaCommand)this, (SparkSession)spark, metrics);
    }

    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$((DeltaCommand)this, (OptimisticTransaction)txn, (SparkSession)sparkSession, options);
    }

    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$((DeltaCommand)this);
    }

    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$((DeltaCommand)this, (SparkSession)sparkSession, (DeltaLog)deltaLog, options);
    }

    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$((DeltaCommand)this);
    }

    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, (Object)data, path);
    }

    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$((DeltaLogging)this);
    }

    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$((DeltaLogging)this);
    }

    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$((DeltaLogging)this, (String)tablePath, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$((DeltaLogging)this);
    }

    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$((DeltaLogging)this, (String)group, (String)name, thunk);
    }

    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$((DeltaLogging)this, (DeltaLog)deltaLog, (String)tahoeId);
    }

    public void logConsole(String line) {
        DatabricksLogging.logConsole$((DatabricksLogging)this, (String)line);
    }

    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$((DatabricksLogging)this);
    }

    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$((DatabricksLogging)this);
    }

    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$((DatabricksLogging)this);
    }

    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$((DatabricksLogging)this);
    }

    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$((DatabricksLogging)this, (OpType)opType, (String)opTarget, extraTags, (boolean)isSynchronous, (boolean)alwaysRecordStats, (boolean)allowAuthTags, (boolean)killJvmIfStuck, (MetricDefinition)outputMetric, (boolean)silent, thunk);
    }

    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$((DatabricksLogging)this);
    }

    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$((DatabricksLogging)this);
    }

    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$((DatabricksLogging)this);
    }

    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$((DatabricksLogging)this);
    }

    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$((DatabricksLogging)this);
    }

    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$((DatabricksLogging)this);
    }

    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$((DeltaProgressReporter)this, (String)statusCode, (String)defaultMessage, data, body);
    }

    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$((DeltaProgressReporter)this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc = DeleteCommandMetrics.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    }

    @Override
    public SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc() {
        return !this.bitmap$trans$0 ? this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$lzycompute() : this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public LogicalPlan target() {
        return this.target;
    }

    public Option<Expression> condition() {
        return this.condition;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return (Seq)new .colon.colon((Object)this.target(), (List)Nil$.MODULE$);
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$0) {
                this.metrics = this.createMetrics();
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        Object object = new Object();
        try {
            this.recordDeltaOperation(this.deltaLog(), "delta.dml.delete", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.deltaLog().withNewTransaction((Function1 & Serializable & scala.Serializable)txn -> {
                    DeleteCommand.$anonfun$run$2(this, sparkSession, object, txn);
                    return BoxedUnit.UNIT;
                });
                sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, this.target());
            });
            seq = ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).value() > 0L && ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value() == 0L ? (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value())})), (List)Nil$.MODULE$);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public Seq<Action> performDelete(SparkSession sparkSession, DeltaLog deltaLog, OptimisticTransaction txn) {
        Seq seq;
        long numRemovedFiles = 0L;
        long numAddedFiles = 0L;
        long numAddedChangeFiles = 0L;
        long scanTimeMs = 0L;
        long rewriteTimeMs = 0L;
        long numAddedBytes = 0L;
        long changeFileBytes = 0L;
        long numRemovedBytes = 0L;
        long numFilesBeforeSkipping = 0L;
        long numBytesBeforeSkipping = 0L;
        long numFilesAfterSkipping = 0L;
        long numBytesAfterSkipping = 0L;
        None$ numPartitionsAfterSkipping = None$.MODULE$;
        None$ numPartitionsRemovedFrom = None$.MODULE$;
        None$ numPartitionsAddedTo = None$.MODULE$;
        Some numDeletedRows = None$.MODULE$;
        None$ numCopiedRows = None$.MODULE$;
        long startTime = System.nanoTime();
        long numFilesTotal = txn.snapshot().numOfFiles();
        Option<Expression> option = this.condition();
        if (None$.MODULE$.equals(option)) {
            boolean reportRowLevelMetrics = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.DELTA_DML_METRICS_FROM_METADATA()));
            Seq allFiles = txn.filterFiles((Seq)Nil$.MODULE$, reportRowLevelMetrics);
            numRemovedFiles = allFiles.size();
            scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
            Tuple2<Object, Object> tuple2 = MergeIntoCommand$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)allFiles);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long numBytes = tuple2._1$mcJ$sp();
            int numPartitions = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(numBytes, numPartitions);
            Tuple2.mcJI.sp sp3 = sp2;
            long numBytes2 = sp3._1$mcJ$sp();
            int numPartitions2 = sp3._2$mcI$sp();
            numRemovedBytes = numBytes2;
            numFilesBeforeSkipping = numRemovedFiles;
            numBytesBeforeSkipping = numBytes2;
            numFilesAfterSkipping = numRemovedFiles;
            numBytesAfterSkipping = numBytes2;
            numDeletedRows = this.getDeletedRowsFromAddFilesAndUpdateMetrics((Seq<AddFile>)allFiles);
            if (txn.metadata().partitionColumns().nonEmpty()) {
                numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numPartitions2));
                numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)numPartitions2));
                numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
            }
            long operationTimestamp = System.currentTimeMillis();
            seq = (Seq)allFiles.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.removeWithTimestamp(operationTimestamp, x$3.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
        } else if (option instanceof Some) {
            Object object;
            Some some = (Some)option;
            Expression cond = (Expression)some.value();
            Tuple2 tuple2 = DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates(cond, txn.metadata().partitionColumns(), sparkSession);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq metadataPredicates = (Seq)tuple2._1();
            Seq otherPredicates = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)otherPredicates);
            Tuple2 tuple23 = tuple22;
            Seq metadataPredicates2 = (Seq)tuple23._1();
            Seq otherPredicates2 = (Seq)tuple23._2();
            numFilesBeforeSkipping = txn.snapshot().numOfFiles();
            numBytesBeforeSkipping = txn.snapshot().sizeInBytes();
            if (otherPredicates2.isEmpty()) {
                long operationTimestamp = System.currentTimeMillis();
                boolean reportRowLevelMetrics = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.DELTA_DML_METRICS_FROM_METADATA()));
                Seq candidateFiles = txn.filterFiles(metadataPredicates2, reportRowLevelMetrics);
                scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                numRemovedFiles = candidateFiles.size();
                numRemovedBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                numFilesAfterSkipping = candidateFiles.size();
                Tuple2<Object, Object> tuple24 = MergeIntoCommand$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)candidateFiles);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                long numCandidateBytes = tuple24._1$mcJ$sp();
                int numCandidatePartitions = tuple24._2$mcI$sp();
                Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(numCandidateBytes, numCandidatePartitions);
                Tuple2.mcJI.sp sp5 = sp4;
                long numCandidateBytes2 = sp5._1$mcJ$sp();
                int numCandidatePartitions2 = sp5._2$mcI$sp();
                numBytesAfterSkipping = numCandidateBytes2;
                numDeletedRows = this.getDeletedRowsFromAddFilesAndUpdateMetrics((Seq<AddFile>)candidateFiles);
                if (txn.metadata().partitionColumns().nonEmpty()) {
                    numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions2));
                    numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions2));
                    numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                }
                object = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.removeWithTimestamp(operationTimestamp, x$7.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
            } else {
                boolean shouldWriteDVs = this.shouldWritePersistentDeletionVectors(sparkSession, txn);
                Seq candidateFiles = txn.filterFiles((Seq)metadataPredicates2.$plus$plus((GenTraversableOnce)otherPredicates2, Seq$.MODULE$.canBuildFrom()), shouldWriteDVs);
                numFilesAfterSkipping = candidateFiles.size();
                Tuple2<Object, Object> tuple25 = MergeIntoCommand$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)candidateFiles);
                if (tuple25 == null) {
                    throw new MatchError(tuple25);
                }
                long numCandidateBytes = tuple25._1$mcJ$sp();
                int numCandidatePartitions = tuple25._2$mcI$sp();
                Tuple2.mcJI.sp sp6 = new Tuple2.mcJI.sp(numCandidateBytes, numCandidatePartitions);
                Tuple2.mcJI.sp sp7 = sp6;
                long numCandidateBytes3 = sp7._1$mcJ$sp();
                int numCandidatePartitions3 = sp7._2$mcI$sp();
                numBytesAfterSkipping = numCandidateBytes3;
                if (txn.metadata().partitionColumns().nonEmpty()) {
                    numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions3));
                }
                Map<String, AddFile> nameToAddFileMap = this.generateCandidateFileMap(deltaLog.dataPath(), (Seq<AddFile>)candidateFiles);
                TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(sparkSession, "delete", candidateFiles, deltaLog, deltaLog.dataPath(), txn.snapshot(), TahoeBatchFileIndex$.MODULE$.$lessinit$greater$default$7());
                if (shouldWriteDVs) {
                    Dataset targetDf = DeleteWithDeletionVectorsHelper$.MODULE$.createTargetDfForScanningForMatches(sparkSession, this.target(), (TahoeFileIndex)fileIndex);
                    boolean mustReadDeletionVectors = DeletionVectorUtils$.MODULE$.deletionVectorsReadable((SnapshotDescriptor)txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                    Seq touchedFiles = DeleteWithDeletionVectorsHelper$.MODULE$.findTouchedFiles(sparkSession, txn, mustReadDeletionVectors, deltaLog, targetDf, (TahoeFileIndex)fileIndex, cond);
                    object = touchedFiles.nonEmpty() ? DeleteWithDeletionVectorsHelper$.MODULE$.processUnmodifiedData(touchedFiles) : Nil$.MODULE$;
                } else {
                    LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), (FileIndex)fileIndex);
                    Dataset data = Dataset$.MODULE$.ofRows(sparkSession, newTarget);
                    SQLMetric deletedRowCount = (SQLMetric)this.metrics().apply((Object)"numDeletedRows");
                    UserDefinedFunction deletedRowUdf = DeltaUDF$.MODULE$.boolean((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        deletedRowCount.$plus$eq(1L);
                        return true;
                    }).asNondeterministic();
                    String[] filesToRewrite = (String[])this.withStatusCode("DELTA", DeleteCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG(), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> candidateFiles.isEmpty() ? (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)) : (String[])data.filter(new Column(cond)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.input_file_name().as("input_files")})).filter(deletedRowUdf.apply((Seq)Nil$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.split(functions$.MODULE$.col("input_files"), ","))})).distinct().as(package$.MODULE$.stringEncoder()).collect());
                    numRemovedFiles = filesToRewrite.length;
                    scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).isEmpty()) {
                        if (txn.metadata().partitionColumns().nonEmpty()) {
                            numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                            numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        object = Nil$.MODULE$;
                    } else {
                        Not filterCond;
                        HadoopFsRelation baseRelation = this.buildBaseRelation(sparkSession, txn, "delete", deltaLog.dataPath(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), nameToAddFileMap);
                        LogicalPlan newTarget2 = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), baseRelation.location());
                        Dataset targetDF = Dataset$.MODULE$.ofRows(sparkSession, newTarget2);
                        Seq<FileAction> rewrittenActions = this.rewriteFiles(txn, (Dataset<Row>)targetDF, (Expression)(filterCond = new Not((Expression)new EqualNullSafe(cond, (Expression)Literal$.MODULE$.TrueLiteral()))), filesToRewrite.length);
                        Tuple2 tuple26 = rewrittenActions.partition((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$6(x$9)));
                        if (tuple26 == null) {
                            throw new MatchError((Object)tuple26);
                        }
                        Seq changeFiles = (Seq)tuple26._1();
                        Seq rewrittenFiles = (Seq)tuple26._2();
                        Tuple2 tuple27 = new Tuple2((Object)changeFiles, (Object)rewrittenFiles);
                        Tuple2 tuple28 = tuple27;
                        Seq changeFiles2 = (Seq)tuple28._1();
                        Seq rewrittenFiles2 = (Seq)tuple28._2();
                        numAddedFiles = rewrittenFiles2.size();
                        AddFile[] removedFiles = (AddFile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).map((Function1 & Serializable & scala.Serializable)f -> this.getTouchedFile(deltaLog.dataPath(), (String)f, nameToAddFileMap), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddFile.class)));
                        Tuple2<Object, Object> tuple29 = MergeIntoCommand$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)Predef$.MODULE$.wrapRefArray((Object[])removedFiles));
                        if (tuple29 == null) {
                            throw new MatchError(tuple29);
                        }
                        long removedBytes = tuple29._1$mcJ$sp();
                        int removedPartitions = tuple29._2$mcI$sp();
                        Tuple2.mcJI.sp sp8 = new Tuple2.mcJI.sp(removedBytes, removedPartitions);
                        Tuple2.mcJI.sp sp9 = sp8;
                        long removedBytes2 = sp9._1$mcJ$sp();
                        int removedPartitions2 = sp9._2$mcI$sp();
                        numRemovedBytes = removedBytes2;
                        Tuple2<Object, Object> tuple210 = MergeIntoCommand$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)rewrittenFiles2);
                        if (tuple210 == null) {
                            throw new MatchError(tuple210);
                        }
                        long rewrittenBytes = tuple210._1$mcJ$sp();
                        int rewrittenPartitions = tuple210._2$mcI$sp();
                        Tuple2.mcJI.sp sp10 = new Tuple2.mcJI.sp(rewrittenBytes, rewrittenPartitions);
                        Tuple2.mcJI.sp sp11 = sp10;
                        long rewrittenBytes2 = sp11._1$mcJ$sp();
                        int rewrittenPartitions2 = sp11._2$mcI$sp();
                        numAddedBytes = rewrittenBytes2;
                        if (txn.metadata().partitionColumns().nonEmpty()) {
                            numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)removedPartitions2));
                            numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)rewrittenPartitions2));
                        }
                        numAddedChangeFiles = changeFiles2.size();
                        changeFileBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)changeFiles2.collect((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 instanceof AddCDCFile) {
                                    AddCDCFile addCDCFile = (AddCDCFile)A1;
                                    object = BoxesRunTime.boxToLong((long)addCDCFile.size());
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(FileAction x1) {
                                FileAction fileAction = x1;
                                boolean bl = fileAction instanceof AddCDCFile;
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        rewriteTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L - scanTimeMs;
                        numDeletedRows = new Some((Object)BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value()));
                        numCopiedRows = new Some((Object)BoxesRunTime.boxToLong((long)(((SQLMetric)this.metrics().apply((Object)"numTouchedRows")).value() - ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value())));
                        long operationTimestamp = System.currentTimeMillis();
                        object = (Seq)this.removeFilesFromPaths(deltaLog, nameToAddFileMap, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), operationTimestamp).$plus$plus(rewrittenActions, Seq$.MODULE$.canBuildFrom());
                    }
                }
            }
            seq = object;
        } else {
            throw new MatchError(option);
        }
        Seq deleteActions = seq;
        ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set(numRemovedFiles);
        ((SQLMetric)this.metrics().apply((Object)"numAddedFiles")).set(numAddedFiles);
        long executionTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
        ((SQLMetric)this.metrics().apply((Object)"executionTimeMs")).set(executionTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"scanTimeMs")).set(scanTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"rewriteTimeMs")).set(rewriteTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"numAddedChangeFiles")).set(numAddedChangeFiles);
        ((SQLMetric)this.metrics().apply((Object)"changeFileBytes")).set(changeFileBytes);
        ((SQLMetric)this.metrics().apply((Object)"numAddedBytes")).set(numAddedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numRemovedBytes")).set(numRemovedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numFilesBeforeSkipping")).set(numFilesBeforeSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numBytesBeforeSkipping")).set(numBytesBeforeSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numFilesAfterSkipping")).set(numFilesAfterSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numBytesAfterSkipping")).set(numBytesAfterSkipping);
        SQLMetric sQLMetric = (SQLMetric)this.metrics().apply((Object)"numPartitionsAfterSkipping");
        numPartitionsAfterSkipping.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric.set(v));
        SQLMetric sQLMetric2 = (SQLMetric)this.metrics().apply((Object)"numPartitionsAddedTo");
        numPartitionsAddedTo.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric2.set(v));
        SQLMetric sQLMetric3 = (SQLMetric)this.metrics().apply((Object)"numPartitionsRemovedFrom");
        numPartitionsRemovedFrom.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric3.set(v));
        SQLMetric sQLMetric4 = (SQLMetric)this.metrics().apply((Object)"numCopiedRows");
        numCopiedRows.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric4.set(v));
        txn.registerSQLMetrics(sparkSession, this.metrics());
        this.sendDriverMetrics(sparkSession, this.metrics());
        DeltaLog x$1 = deltaLog;
        String x$2 = "delta.dml.delete.stats";
        DeleteMetric x$32 = new DeleteMetric((String)this.condition().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.sql()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "true"), numFilesTotal, numFilesAfterSkipping, numAddedFiles, numRemovedFiles, numAddedFiles, numAddedChangeFiles, numFilesBeforeSkipping, numBytesBeforeSkipping, numFilesAfterSkipping, numBytesAfterSkipping, (Option<Object>)numPartitionsAfterSkipping, (Option<Object>)numPartitionsAddedTo, (Option<Object>)numPartitionsRemovedFrom, (Option<Object>)numCopiedRows, (Option<Object>)numDeletedRows, numAddedBytes, numRemovedBytes, changeFileBytes, scanTimeMs, rewriteTimeMs);
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$52 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$2, x$4, x$32, x$52);
        return deleteActions.nonEmpty() ? (Seq)Option$.MODULE$.option2Iterable(this.createSetTransaction(sparkSession, deltaLog, this.createSetTransaction$default$3())).toSeq().$plus$plus((GenTraversableOnce)deleteActions, Seq$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
    }

    private Seq<FileAction> rewriteFiles(OptimisticTransaction txn, Dataset<Row> baseData, Expression filterCondition, long numFilesToRewrite) {
        boolean shouldWriteCdc = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHANGE_DATA_FEED().fromMetaData(txn.metadata()));
        SQLMetric numTouchedRows = (SQLMetric)this.metrics().apply((Object)"numTouchedRows");
        UserDefinedFunction numTouchedRowsUdf = DeltaUDF$.MODULE$.boolean((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            numTouchedRows.$plus$eq(1L);
            return true;
        }).asNondeterministic();
        return (Seq)this.withStatusCode("DELTA", DeleteCommand$.MODULE$.rewritingFilesMsg(numFilesToRewrite), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset dfToWrite = shouldWriteCdc ? baseData.filter(numTouchedRowsUdf.apply((Seq)Nil$.MODULE$)).withColumn(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME(), new Column((Expression)new If(filterCondition, (Expression)CDCReader$.MODULE$.CDC_TYPE_NOT_CDC(), (Expression)CDCReader$.MODULE$.CDC_TYPE_DELETE()))) : baseData.filter(numTouchedRowsUdf.apply((Seq)Nil$.MODULE$)).filter(new Column(filterCondition));
            return txn.writeFiles(dfToWrite);
        });
    }

    public boolean shouldWritePersistentDeletionVectors(SparkSession spark, OptimisticTransaction txn) {
        return Utils$.MODULE$.isTesting() && BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELETE_USE_PERSISTENT_DELETION_VECTORS())) && DeletionVectorUtils$.MODULE$.deletionVectorsWritable((SnapshotDescriptor)txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$3());
    }

    public DeleteCommand copy(DeltaLog deltaLog, LogicalPlan target, Option<Expression> condition) {
        return new DeleteCommand(deltaLog, target, condition);
    }

    public DeltaLog copy$default$1() {
        return this.deltaLog();
    }

    public LogicalPlan copy$default$2() {
        return this.target();
    }

    public Option<Expression> copy$default$3() {
        return this.condition();
    }

    public String productPrefix() {
        return "DeleteCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.deltaLog();
                break;
            }
            case 1: {
                option = this.target();
                break;
            }
            case 2: {
                option = this.condition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeleteCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeleteCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeleteCommand deleteCommand = (DeleteCommand)x$1;
        DeltaLog deltaLog = this.deltaLog();
        DeltaLog deltaLog2 = deleteCommand.deltaLog();
        if (deltaLog == null) {
            if (deltaLog2 != null) {
                return false;
            }
        } else if (!deltaLog.equals(deltaLog2)) return false;
        LogicalPlan logicalPlan = this.target();
        LogicalPlan logicalPlan2 = deleteCommand.target();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        Option<Expression> option = this.condition();
        Option<Expression> option2 = deleteCommand.condition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!deleteCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$2(DeleteCommand $this, SparkSession sparkSession$1, Object nonLocalReturnKey2$1, OptimisticTransaction txn) {
        DeltaLog$.MODULE$.assertRemovable(txn.snapshot());
        if ($this.hasBeenExecuted(txn, sparkSession$1, $this.hasBeenExecuted$default$3())) {
            $this.sendDriverMetrics(sparkSession$1, $this.metrics());
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)Nil$.MODULE$);
        }
        Seq<Action> deleteActions = $this.performDelete(sparkSession$1, $this.deltaLog(), txn);
        txn.commitIfNeeded(deleteActions, (DeltaOperations.Operation)new DeltaOperations.Delete(Option$.MODULE$.option2Iterable($this.condition().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.sql())).toSeq()));
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$6(FileAction x$9) {
        return x$9 instanceof AddCDCFile;
    }

    public DeleteCommand(DeltaLog deltaLog, LogicalPlan target, Option<Expression> condition) {
        this.deltaLog = deltaLog;
        this.target = target;
        this.condition = condition;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$((DeltaProgressReporter)this);
        DatabricksLogging.$init$((DatabricksLogging)this);
        DeltaLogging.$init$((DeltaLogging)this);
        DeltaCommand.$init$((DeltaCommand)this);
        DeleteCommandMetrics.$init$(this);
        String x$1 = "num_affected_rows";
        LongType$ x$2 = LongType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        this.output = (Seq)new .colon.colon((Object)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$);
    }
}

