/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B!C\u00015C\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0005?\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!b\u0001\n\u0003a\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011M\u0004!Q1A\u0005\u00021D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\tk\u0002\u0011)\u0019!C\u0001Y\"Aa\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003y\u0011)\tI\u0001\u0001B\u0001B\u0003%\u00111\u0002\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011%\tI\u0004\u0001a\u0001\n\u0003\tY\u0004C\u0005\u0002H\u0001\u0001\r\u0011\"\u0001\u0002J!A\u0011Q\u000b\u0001!B\u0013\ti\u0004C\u0005\u0002X\u0001\u0001\r\u0011\"\u0001\u0002Z!I\u0011\u0011\r\u0001A\u0002\u0013\u0005\u00111\r\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002\\!I\u0011\u0011\u000e\u0001C\u0002\u0013\u0005\u00111\u000e\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002n!I\u00111\u0010\u0001C\u0002\u0013\u0005\u0011Q\u0010\u0005\t\u0003\u0003\u0003\u0001\u0015!\u0003\u0002\u0000!I\u00111\u0011\u0001A\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003'\u0003\u0001\u0019!C\u0001\u0003+C\u0001\"!'\u0001A\u0003&\u0011q\u0011\u0005\b\u0003K\u0001A\u0011AAN\u0011%\t9\u000b\u0001b\u0001\n\u0003\tI\u000b\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAV\u0011!\t\u0019\f\u0001a\u0001\n\u0003a\u0007\"CA[\u0001\u0001\u0007I\u0011AA\\\u0011\u001d\tY\f\u0001Q!\n5D\u0011\"!0\u0001\u0001\u0004%\t!!\u0017\t\u0013\u0005}\u0006\u00011A\u0005\u0002\u0005\u0005\u0007\u0002CAc\u0001\u0001\u0006K!a\u0017\t\u0011\u0005\u001d\u0007\u00011A\u0005\u00021D\u0011\"!3\u0001\u0001\u0004%\t!a3\t\u000f\u0005=\u0007\u0001)Q\u0005[\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003kDq!a=\u0001\t\u0003\ti\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\f\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005CAqA!\n\u0001\t\u0003\u00119\u0003C\u0004\u0003*\u0001!\t!!8\t\u000f\t-\u0002\u0001\"\u0001\u0003.!9!1\u0007\u0001\u0005\u0002\u0005u\u0007b\u0002B\u001b\u0001\u0011\u0005!q\u0007\u0005\n\u0005\u000b\u0002\u0011\u0013!C\u0001\u0005\u000fBqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0004\u0003f\u0001!\tE!\t\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!1\u000f\u0001\u0005B\t5qa\u0002B;\u0005\"\u0005!q\u000f\u0004\u0007\u0003\nC\tA!\u001f\t\u000f\u0005\u0015R\b\"\u0001\u0003|!9!QP\u001f\u0005\u0002\t}\u0004\"\u0003BC{\u0005\u0005I\u0011\u0002BD\u0005)9vN]6fe&sgm\u001c\u0006\u0003\u0007\u0012\u000bA!\\3uC*\u0011QIR\u0001\u0007G>lWn\u001c8\u000b\u0005\u001dC\u0015\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\nV,\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g!\tyU+\u0003\u0002W!\na1+\u001a:jC2L'0\u00192mKB\u0011\u0001lW\u0007\u00023*\u0011!\fR\u0001\tS:$XM\u001d8bY&\u0011A,\u0017\u0002\b\u0019><w-\u001b8h\u0003\u0011Awn\u001d;\u0016\u0003}\u0003\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012Q\u001b\u0005\u0019'B\u00013M\u0003\u0019a$o\\8u}%\u0011a\rU\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g!\u0006)\u0001n\\:uA\u00059!\u000f]2Q_J$X#A7\u0011\u0005=s\u0017BA8Q\u0005\rIe\u000e^\u0001\teB\u001c\u0007k\u001c:uA\u0005A\u0001/^:i!>\u0014H/A\u0005qkND\u0007k\u001c:uA\u0005Ia-\u001a;dQB{'\u000f^\u0001\u000bM\u0016$8\r\u001b)peR\u0004\u0013!\u0004:fa2L7-\u0019;f!>\u0014H/\u0001\bsKBd\u0017nY1uKB{'\u000f\u001e\u0011\u0002\u0015}#\u0017n]6J]\u001a|7\u000fE\u0003z}~\u000b\t!D\u0001{\u0015\tYH0\u0001\u0003vi&d'\"A?\u0002\t)\fg/Y\u0005\u0003\u007fj\u00141!T1q!\u0011\t\u0019!!\u0002\u000e\u0003\tK1!a\u0002C\u0005!!\u0015n]6J]\u001a|\u0017\u0001G0vg\u0016\u0014(+Z:pkJ\u001cWmQ8ogVl\u0007\u000f^5p]B1\u0011P`A\u0007\u00033\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'!\u0015\u0001C5eK:$\u0018\u000e^=\n\t\u0005]\u0011\u0011\u0003\u0002\u000f+N,'/\u00133f]RLg-[3s!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\t\u0006)\u0011/^8uC&!\u00111EA\u000f\u0005M\u0011Vm]8ve\u000e,7i\u001c8tk6\u0004H/[8o\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011FA\u0016\u0003[\ty#!\r\u00024\u0005U\u0012q\u0007\t\u0004\u0003\u0007\u0001\u0001\"B/\u000e\u0001\u0004y\u0006\"B6\u000e\u0001\u0004i\u0007\"B9\u000e\u0001\u0004i\u0007\"B:\u000e\u0001\u0004i\u0007\"B;\u000e\u0001\u0004i\u0007\"B<\u000e\u0001\u0004A\bbBA\u0005\u001b\u0001\u0007\u00111B\u0001\u0010]\u0016$xo\u001c:l\u0019>\u001c\u0017\r^5p]V\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t?\u0002\t1\fgnZ\u0005\u0004Q\u0006\u0005\u0013a\u00058fi^|'o\u001b'pG\u0006$\u0018n\u001c8`I\u0015\fH\u0003BA&\u0003#\u00022aTA'\u0013\r\ty\u0005\u0015\u0002\u0005+:LG\u000fC\u0005\u0002T=\t\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010J\u0019\u0002!9,Go^8sW2{7-\u0019;j_:\u0004\u0013!\u00047bgRDU-\u0019:uE\u0016\fG/\u0006\u0002\u0002\\A\u0019q*!\u0018\n\u0007\u0005}\u0003K\u0001\u0003M_:<\u0017!\u00057bgRDU-\u0019:uE\u0016\fGo\u0018\u0013fcR!\u00111JA3\u0011%\t\u0019FEA\u0001\u0002\u0004\tY&\u0001\bmCN$\b*Z1si\n,\u0017\r\u001e\u0011\u0002\u0013\u0011L7o[%oM>\u001cXCAA7!\u001d\ty'!\u001e`\u0003\u0003i!!!\u001d\u000b\u0007\u0005M$0\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u001e\u0002r\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0002\u0015\u0011L7o[%oM>\u001c\b%A\fvg\u0016\u0014(+Z:pkJ\u001cWmQ8ogVl\u0007\u000f^5p]V\u0011\u0011q\u0010\t\t\u0003_\n)(!\u0004\u0002\u001a\u0005ARo]3s%\u0016\u001cx.\u001e:dK\u000e{gn];naRLwN\u001c\u0011\u0002\u0011\u0015tG\r]8j]R,\"!a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$E\u0003\r\u0011\boY\u0005\u0005\u0003#\u000bYI\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\u0019\u0015tG\r]8j]R|F%Z9\u0015\t\u0005-\u0013q\u0013\u0005\n\u0003'J\u0012\u0011!a\u0001\u0003\u000f\u000b\u0011\"\u001a8ea>Lg\u000e\u001e\u0011\u0015\u0019\u0005%\u0012QTAP\u0003C\u000b\u0019+!*\t\u000bu[\u0002\u0019A0\t\u000b-\\\u0002\u0019A7\t\u000bE\\\u0002\u0019A7\t\u000bM\\\u0002\u0019A7\t\u000bU\\\u0002\u0019A7\u0002#\u0005dGn\\2bi&|gNQ;dW\u0016$8/\u0006\u0002\u0002,B!q*!,n\u0013\r\ty\u000b\u0015\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0013C2dwnY1uS>t')^2lKR\u001c\b%A\u0006ck\u000e\\W\r^%oI\u0016D\u0018a\u00042vG.,G/\u00138eKb|F%Z9\u0015\t\u0005-\u0013\u0011\u0018\u0005\t\u0003'z\u0012\u0011!a\u0001[\u0006a!-^2lKRLe\u000eZ3yA\u0005Q!-^2lKR$\u0016.\\3\u0002\u001d\t,8m[3u)&lWm\u0018\u0013fcR!\u00111JAb\u0011%\t\u0019FIA\u0001\u0002\u0004\tY&A\u0006ck\u000e\\W\r\u001e+j[\u0016\u0004\u0013!\u00052vG.,G/\u00117m_\u000e\fG/[8og\u0006)\"-^2lKR\fE\u000e\\8dCRLwN\\:`I\u0015\fH\u0003BA&\u0003\u001bD\u0001\"a\u0015&\u0003\u0003\u0005\r!\\\u0001\u0013EV\u001c7.\u001a;BY2|7-\u0019;j_:\u001c\b%\u0001\u0005jg\u0006\u001bG/\u001b<f+\t\t)\u000eE\u0002P\u0003/L1!!7Q\u0005\u001d\u0011un\u001c7fC:\f\u0011\"^:fINcw\u000e^:\u0015\u0005\u0005m\u0013!D1mY>\u001c\u0017\r^3TY>$8\u000f\u0006\u0004\u0002L\u0005\r\u0018q\u001d\u0005\u0007\u0003KL\u0003\u0019A0\u0002\u0015MDWO\u001a4mK.+\u0017\u0010C\u0004\u0002j&\u0002\r!a;\u0002\u0019Mdw\u000e^:QKJ$\u0015n]6\u0011\u000betx,!<\u0011\t\u0005}\u0012q^\u0005\u0005\u0003c\f\tEA\u0004J]R,w-\u001a:\u0002\u0019I,G.Z1tKNcw\u000e^:\u0015\r\u0005-\u0013q_A}\u0011\u0019\t)O\u000ba\u0001?\"9\u00111 \u0016A\u0002\u0005-\u0018!B:m_R\u001cH\u0003BA&\u0003\u007fDa!!:,\u0001\u0004y\u0016\u0001E4fiNCWO\u001a4mK.+\u0017pU3u+\t\u0011)\u0001\u0005\u0003z\u0005\u000fy\u0016b\u0001B\u0005u\n9\u0001*Y:i'\u0016$\u0018!F1mY>\u001c\u0017\r^5p]NLe\u000eT1ti\"{WO\u001d\u000b\u0002[\u0006y\u0001.Y:TC6,\u0017J\u001c4p/&$\b\u000e\u0006\u0003\u0002V\nM\u0001b\u0002B\u000b]\u0001\u0007\u0011\u0011F\u0001\u0006_RDWM]\u0001\u000eg\u0016$X\u000f]#oIB|\u0017N\u001c;\u0015\t\u0005-#1\u0004\u0005\b\u0005;y\u0003\u0019AAD\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0002\u001fI,\u0017\rZ1cY\u0016\fE\r\u001a:fgN$\u0012aX\u0001\u000bi>,f.[9vK&#\u0017!D:m_R\fe/Y5mC\ndW\r\u0006\u0002\u0002V\u0006iq-\u001a;U_R\fGn\u00157piN\f!#\u001e9eCR,G)[:l\u001b\u0006D8\u000b\\8ugR!\u00111\nB\u0018\u0011\u001d\u0011\t\u0004\u000ea\u0001\u00037\na#Z:uS6\fG/\u001a3QCJ$\u0018\u000e^5p]NK'0Z\u0001\u0014i>$\u0018\r\\!wC&d\u0017M\u00197f'2|Go]\u0001\u0017kB$\u0017\r^3UQ\u0016tw)\u001a;ESN\\\u0017J\u001c4pgR)\u0001P!\u000f\u0003>!1!1\b\u001cA\u0002a\fAB\\3x\t&\u001c8.\u00138g_ND\u0011B!\r7!\u0003\u0005\rAa\u0010\u0011\u000b=\u0013\t%a\u0017\n\u0007\t\r\u0003K\u0001\u0004PaRLwN\\\u0001!kB$\u0017\r^3UQ\u0016tw)\u001a;ESN\\\u0017J\u001c4pg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003J)\"!q\bB&W\t\u0011i\u0005\u0005\u0003\u0003P\teSB\u0001B)\u0015\u0011\u0011\u0019F!\u0016\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B,!\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm#\u0011\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001J;qI\u0006$X\r\u00165f]\u001e+G/V:feJ+7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8\u0015\t\u0005-!\u0011\r\u0005\b\u0005GB\u0004\u0019AA\u0006\u0003-\u0019wN\\:v[B$\u0018n\u001c8\u0002\u0011Q|7\u000b\u001e:j]\u001e\fa!Z9vC2\u001cH\u0003BAk\u0005WBqA!\u0006;\u0001\u0004\u0011i\u0007E\u0002P\u0005_J1A!\u001dQ\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eK\u0006Qqk\u001c:lKJLeNZ8\u0011\u0007\u0005\rQhE\u0002>\u001dR#\"Aa\u001e\u0002\u0019\u0019\u0014x.\\+oSF,X-\u00133\u0015\t\u0005%\"\u0011\u0011\u0005\u0007\u0005\u0007{\u0004\u0019A0\u0002\u0005%$\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!#\u0011\t\u0005}\"1R\u0005\u0005\u0005\u001b\u000b\tE\u0001\u0004PE*,7\r\u001e")
public class WorkerInfo
implements scala.Serializable,
Logging {
    private final String host;
    private final int rpcPort;
    private final int pushPort;
    private final int fetchPort;
    private final int replicatePort;
    private String networkLocation;
    private long lastHeartbeat;
    private final ConcurrentHashMap<String, DiskInfo> diskInfos;
    private final ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption;
    private RpcEndpointRef endpoint;
    private final int[] allocationBuckets;
    private int bucketIndex;
    private long bucketTime;
    private int bucketAllocations;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static WorkerInfo fromUniqueId(String string) {
        return WorkerInfo$.MODULE$.fromUniqueId(string);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String host() {
        return this.host;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int pushPort() {
        return this.pushPort;
    }

    public int fetchPort() {
        return this.fetchPort;
    }

    public int replicatePort() {
        return this.replicatePort;
    }

    public String networkLocation() {
        return this.networkLocation;
    }

    public void networkLocation_$eq(String x$1) {
        this.networkLocation = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public ConcurrentHashMap<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption() {
        return this.userResourceConsumption;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public int[] allocationBuckets() {
        return this.allocationBuckets;
    }

    public int bucketIndex() {
        return this.bucketIndex;
    }

    public void bucketIndex_$eq(int x$1) {
        this.bucketIndex = x$1;
    }

    public long bucketTime() {
        return this.bucketTime;
    }

    public void bucketTime_$eq(long x$1) {
        this.bucketTime = x$1;
    }

    public int bucketAllocations() {
        return this.bucketAllocations;
    }

    public void bucketAllocations_$eq(int x$1) {
        this.bucketAllocations = x$1;
    }

    public boolean isActive() {
        return ((NettyRpcEndpointRef)this.endpoint()).client().isActive();
    }

    public synchronized long usedSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$usedSlots$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized void allocateSlots(String shuffleKey, Map<String, Integer> slotsPerDisk) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("shuffle ").append(shuffleKey).append(" allocations ").append(slotsPerDisk).toString());
        IntRef totalSlots = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slotsPerDisk).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$allocateSlots$2(this, shuffleKey, totalSlots, x0$1);
            return BoxedUnit.UNIT;
        });
        long current = System.currentTimeMillis();
        if (current - this.bucketTime() > 60000L) {
            this.bucketIndex_$eq((this.bucketIndex() + 1) % this.allocationBuckets().length);
            this.allocationBuckets()[this.bucketIndex()] = 0;
            this.bucketTime_$eq(current);
        }
        this.allocationBuckets()[this.bucketIndex()] = this.allocationBuckets()[this.bucketIndex()] + totalSlots.elem;
    }

    public synchronized void releaseSlots(String shuffleKey, Map<String, Integer> slots) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$releaseSlots$1(this, shuffleKey, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void releaseSlots(String shuffleKey) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            WorkerInfo.$anonfun$releaseSlots$2(shuffleKey, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized HashSet<String> getShuffleKeySet() {
        HashSet<String> shuffleKeySet = new HashSet<String>();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)shuffleKeySet.addAll(diskInfo.getShuffleKeySet())));
        return shuffleKeySet;
    }

    public synchronized int allocationsInLastHour() {
        IntRef total = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 60).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            total$1.elem += this.allocationBuckets()[(this.bucketIndex() + n) % this.allocationBuckets().length];
        });
        return total.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameInfoWith(WorkerInfo other) {
        if (this.rpcPort() != other.rpcPort()) return false;
        if (this.pushPort() != other.pushPort()) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.fetchPort() != other.fetchPort()) return false;
        if (this.replicatePort() != other.replicatePort()) return false;
        return true;
    }

    public void setupEndpoint(RpcEndpointRef endpointRef) {
        if (this.endpoint() == null) {
            this.endpoint_$eq(endpointRef);
            return;
        }
    }

    public String readableAddress() {
        return new StringBuilder(50).append("Host:").append(this.host()).append(":RpcPort:").append(this.rpcPort()).append(":PushPort:").append(this.pushPort()).append(":").append("FetchPort:").append(this.fetchPort()).append(":ReplicatePort:").append(this.replicatePort()).toString();
    }

    public String toUniqueId() {
        return new StringBuilder(4).append(this.host()).append(":").append(this.rpcPort()).append(":").append(this.pushPort()).append(":").append(this.fetchPort()).append(":").append(this.replicatePort()).toString();
    }

    public synchronized boolean slotAvailable() {
        return ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$slotAvailable$1(x0$1)));
    }

    public synchronized long getTotalSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$getTotalSlots$1(x$3)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized void updateDiskMaxSlots(long estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$updateDiskMaxSlots$1(estimatedPartitionSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized long totalAvailableSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalAvailableSlots$1(x$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized Map<String, DiskInfo> updateThenGetDiskInfos(Map<String, DiskInfo> newDiskInfos, Option<Object> estimatedPartitionSize) {
        block0: {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(newDiskInfos.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)newDisk -> {
                String mountPoint;
                block2: {
                    mountPoint = newDisk.mountPoint();
                    DiskInfo curDisk = this.diskInfos().get(mountPoint);
                    if (curDisk != null) {
                        curDisk.actualUsableSpace_$eq(newDisk.actualUsableSpace());
                        curDisk.activeSlots_$eq(newDisk.activeSlots());
                        curDisk.avgFlushTime_$eq(newDisk.avgFlushTime());
                        curDisk.avgFetchTime_$eq(newDisk.avgFetchTime());
                        if (estimatedPartitionSize.nonEmpty()) {
                            curDisk.maxSlots_$eq(curDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                        }
                        return curDisk.setStatus(newDisk.status());
                    }
                    if (!estimatedPartitionSize.nonEmpty()) break block2;
                    newDisk.maxSlots_$eq(newDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                }
                return this.diskInfos().put(mountPoint, (DiskInfo)newDisk);
            });
            HashSet nonExistsMountPoints = new HashSet();
            nonExistsMountPoints.addAll(this.diskInfos().keySet());
            nonExistsMountPoints.removeAll(newDiskInfos.keySet());
            if (nonExistsMountPoints.isEmpty()) break block0;
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(nonExistsMountPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)nonExistsMountPoint -> this.diskInfos().remove(nonExistsMountPoint));
        }
        return JavaUtils.newConcurrentHashMap(this.diskInfos());
    }

    public Option<Object> updateThenGetDiskInfos$default$2() {
        return None$.MODULE$;
    }

    public Map<UserIdentifier, ResourceConsumption> updateThenGetUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> consumption) {
        this.userResourceConsumption().clear();
        this.userResourceConsumption().putAll(consumption);
        return this.userResourceConsumption();
    }

    public String toString() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.diskInfos() == null || this.diskInfos().isEmpty()) {
            tuple22 = new Tuple2((Object)"empty", (Object)BoxesRunTime.boxToInteger((int)0));
        } else if (this.diskInfos() != null) {
            String str = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DiskInfo diskInfo = (DiskInfo)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(13).append("\n  DiskInfo").append(index).append(": ").append(diskInfo).toString();
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("");
            tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToLong((long)this.usedSlots()));
        } else {
            tuple22 = tuple2 = BoxedUnit.UNIT;
        }
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple23 = tuple2;
        Object diskInfosString = tuple23._1();
        Object slots = tuple23._2();
        Tuple2 tuple24 = new Tuple2(diskInfosString, slots);
        Object diskInfosString2 = tuple24._1();
        Object slots2 = tuple24._2();
        String userResourceConsumptionString = this.userResourceConsumption() == null || this.userResourceConsumption().isEmpty() ? "empty" : (this.userResourceConsumption() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.userResourceConsumption()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new StringBuilder(42).append("\n  UserIdentifier: ").append(userIdentifier).append(", ResourceConsumption: ").append(resourceConsumption).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("") : BoxedUnit.UNIT);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(253).append("\n       |Host: ").append(this.host()).append("\n       |RpcPort: ").append(this.rpcPort()).append("\n       |PushPort: ").append(this.pushPort()).append("\n       |FetchPort: ").append(this.fetchPort()).append("\n       |ReplicatePort: ").append(this.replicatePort()).append("\n       |SlotsUsed: ").append(slots2).append("\n       |LastHeartbeat: ").append(this.lastHeartbeat()).append("\n       |HeartbeatElapsedSeconds: ").append((System.currentTimeMillis() - this.lastHeartbeat()) / 1000L).append("\n       |Disks: ").append(diskInfosString2).append("\n       |UserResourceConsumption: ").append((Object)userResourceConsumptionString).append("\n       |WorkerRef: ").append(this.endpoint()).append("\n       |").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof WorkerInfo)) return false;
        WorkerInfo workerInfo = (WorkerInfo)object;
        String string = this.host();
        String string2 = workerInfo.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.rpcPort() != workerInfo.rpcPort()) return false;
        if (this.pushPort() != workerInfo.pushPort()) return false;
        if (this.fetchPort() != workerInfo.fetchPort()) return false;
        if (this.replicatePort() != workerInfo.replicatePort()) return false;
        return true;
    }

    public int hashCode() {
        Seq state = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.rpcPort()), BoxesRunTime.boxToInteger((int)this.pushPort()), BoxesRunTime.boxToInteger((int)this.fetchPort()), BoxesRunTime.boxToInteger((int)this.replicatePort())}));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)state.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ long $anonfun$usedSlots$1(Tuple2 x$1) {
        return ((DiskInfo)x$1._2()).activeSlots();
    }

    public static final /* synthetic */ void $anonfun$allocateSlots$2(WorkerInfo $this, String shuffleKey$1, IntRef totalSlots$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slots = (Integer)tuple2._2();
            if (!$this.diskInfos().containsKey(disk)) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Unknown disk ").append(disk).toString());
            } else {
                $this.diskInfos().get(disk).allocateSlots(shuffleKey$1, Predef$.MODULE$.Integer2int(slots));
            }
            totalSlots$1.elem += Predef$.MODULE$.Integer2int(slots);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$1(WorkerInfo $this, String shuffleKey$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slot = (Integer)tuple2._2();
            if ($this.diskInfos().containsKey(disk)) {
                $this.diskInfos().get(disk).releaseSlots(shuffleKey$2, Predef$.MODULE$.Integer2int(slot));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$2(String shuffleKey$3, Tuple2 x$2) {
        ((DiskInfo)x$2._2()).releaseSlots(shuffleKey$3);
    }

    public static final /* synthetic */ boolean $anonfun$slotAvailable$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            return disk.maxSlots() - disk.activeSlots() > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getTotalSlots$1(Tuple2 x$3) {
        return ((DiskInfo)x$3._2()).maxSlots();
    }

    public static final /* synthetic */ void $anonfun$updateDiskMaxSlots$1(long estimatedPartitionSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            disk.maxSlots_$eq(disk.actualUsableSpace() / estimatedPartitionSize$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$totalAvailableSlots$1(Tuple2 x$4) {
        return ((DiskInfo)x$4._2()).availableSlots();
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> _diskInfos, Map<UserIdentifier, ResourceConsumption> _userResourceConsumption) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        Logging.$init$(this);
        this.networkLocation = "/default-rack";
        this.lastHeartbeat = 0L;
        this.diskInfos = _diskInfos != null ? JavaUtils.newConcurrentHashMap(_diskInfos) : null;
        this.userResourceConsumption = _userResourceConsumption != null ? JavaUtils.newConcurrentHashMap(_userResourceConsumption) : null;
        this.endpoint = null;
        this.allocationBuckets = new int[61];
        this.bucketIndex = 0;
        this.bucketTime = System.currentTimeMillis();
        this.bucketAllocations = 0;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.allocationBuckets().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            $this.allocationBuckets()[n] = 0;
        });
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }
}

