/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.MetricsConfig;
import org.apache.celeborn.common.metrics.MetricsSystem$;
import org.apache.celeborn.common.metrics.sink.PrometheusHttpRequestHandler;
import org.apache.celeborn.common.metrics.sink.PrometheusServlet;
import org.apache.celeborn.common.metrics.sink.Sink;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u00192\u0001qB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005]\u0001\t\u0015\r\u0011\"\u0001K\u0011!i\u0006A!A!\u0002\u0013Y\u0005\"\u00020\u0001\t\u0003y\u0006BB3\u0001A\u0003%a\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\re\u0004\u0001\u0015!\u0003l\u0011\u001dQ\bA1A\u0005\nmDq!a\u0002\u0001A\u0003%A\u0010C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f!A\u0011q\u0004\u0001!\u0002\u0013\ti\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!I\u0011\u0011\u0007\u0001A\u0002\u0013%\u00111\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015)\u0003\u0002&!I\u0011\u0011\t\u0001A\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u001bB\u0001\"!\u0015\u0001A\u0003&\u0011Q\t\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\ti\u0006\u0001C\u0001\u0003?B\u0011\"!\u001a\u0001#\u0003%\t!a\u001a\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005}\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!+\u0001\t\u0003\tY\u000bC\u0004\u00020\u0002!I!a \t\u000f\u0005E\u0006\u0001\"\u0003\u0002\u0000\u001d9\u00111W\u0019\t\u0002\u0005UfA\u0002\u00192\u0011\u0003\t9\f\u0003\u0004_A\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003w\u0003#\u0019!C\u0001\u0003{C\u0001\"a4!A\u0003%\u0011q\u0018\u0005\n\u0003#\u0004#\u0019!C\u0001\u0003{C\u0001\"a5!A\u0003%\u0011q\u0018\u0005\n\u0003+\u0004#\u0019!C\u0001\u0003/D\u0001\"a:!A\u0003%\u0011\u0011\u001c\u0005\n\u0003S\u0004#\u0019!C\u0001\u0003/D\u0001\"a;!A\u0003%\u0011\u0011\u001c\u0005\n\u0003[\u0004#\u0019!C\u0001\u0003/D\u0001\"a<!A\u0003%\u0011\u0011\u001c\u0005\t\u0003c\u0004\u0003\u0015!\u0003\u0002t\"A!\u0011\u0001\u0011!\u0002\u0013\u0011\u0019\u0001C\u0004\u0003\n\u0001\"\tAa\u0003\t\u000f\tU\u0001\u0005\"\u0001\u0003\u0018\tiQ*\u001a;sS\u000e\u001c8+_:uK6T!AM\u001a\u0002\u000f5,GO]5dg*\u0011A'N\u0001\u0007G>lWn\u001c8\u000b\u0005Y:\u0014\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0002\u0001'\r\u0001Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019\u001b\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005!+%a\u0002'pO\u001eLgnZ\u0001\tS:\u001cH/\u00198dKV\t1\n\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d~j\u0011a\u0014\u0006\u0003!n\na\u0001\u0010:p_Rt\u0014B\u0001*@\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I{\u0014!C5ogR\fgnY3!\u0003\u0011\u0019wN\u001c4\u0011\u0005eSV\"A\u001a\n\u0005m\u001b$\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017aC:feZdW\r\u001e)bi\"\fAb]3sm2,G\u000fU1uQ\u0002\na\u0001P5oSRtD\u0003\u00021cG\u0012\u0004\"!\u0019\u0001\u000e\u0003EBQ!\u0013\u0004A\u0002-CQa\u0016\u0004A\u0002aCQ\u0001\u0018\u0004A\u0002-\u000bQ\"\\3ue&\u001c7oQ8oM&<\u0007CA1h\u0013\tA\u0017GA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0006g&t7n]\u000b\u0002WB\u0019A.]:\u000e\u00035T!A\\8\u0002\u000f5,H/\u00192mK*\u0011\u0001oP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001:n\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005Q<X\"A;\u000b\u0005Y\f\u0014\u0001B:j].L!\u0001_;\u0003\tMKgn[\u0001\u0007g&t7n\u001d\u0011\u0002\u000fM|WO]2fgV\tA\u0010E\u0002mcv\u00042A`A\u0002\u001b\u0005y(bAA\u0001c\u000511o\\;sG\u0016L1!!\u0002\u0000\u0005\u0019\u0019v.\u001e:dK\u0006A1o\\;sG\u0016\u001c\b%\u0001\u0005sK\u001eL7\u000f\u001e:z+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005mQBAA\t\u0015\r\u0011\u00141\u0003\u0006\u0005\u0003+\t9\"\u0001\u0005d_\u0012\f\u0007.\u00197f\u0015\t\tI\"A\u0002d_6LA!!\b\u0002\u0012\tqQ*\u001a;sS\u000e\u0014VmZ5tiJL\u0018!\u0003:fO&\u001cHO]=!\u0003E\u0001(o\\7fi\",Wo]*feZdW\r^\u000b\u0003\u0003K\u0001RAPA\u0014\u0003WI1!!\u000b@\u0005\u0019y\u0005\u000f^5p]B\u0019A/!\f\n\u0007\u0005=ROA\tQe>lW\r\u001e5fkN\u001cVM\u001d<mKR\fQ\u0003\u001d:p[\u0016$\b.Z;t'\u0016\u0014h\u000f\\3u?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005m\u0002c\u0001 \u00028%\u0019\u0011\u0011H \u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{y\u0011\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u0003I\u0001(o\\7fi\",Wo]*feZdW\r\u001e\u0011\u0002\u000fI,hN\\5oOV\u0011\u0011Q\t\t\u0004}\u0005\u001d\u0013bAA%\u007f\t9!i\\8mK\u0006t\u0017a\u0003:v]:LgnZ0%KF$B!!\u000e\u0002P!I\u0011Q\b\n\u0002\u0002\u0003\u0007\u0011QI\u0001\teVtg.\u001b8hA\u0005!r-\u001a;Qe>lW\r\u001e5fkND\u0015M\u001c3mKJ,\"!a\u0016\u0011\u0007Q\fI&C\u0002\u0002\\U\u0014A\u0004\u0015:p[\u0016$\b.Z;t\u0011R$\bOU3rk\u0016\u001cH\u000fS1oI2,'/A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u00026\u0005\u0005\u0004\"CA2+A\u0005\t\u0019AA#\u0003U\u0011XmZ5ti\u0016\u00148\u000b^1uS\u000e\u001cv.\u001e:dKN\fqb\u001d;beR$C-\u001a4bk2$H%M\u000b\u0003\u0003SRC!!\u0012\u0002l-\u0012\u0011Q\u000e\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003%)hn\u00195fG.,GMC\u0002\u0002x}\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY(!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003ti>\u0004HCAA\u001b\u0003\u0019\u0011X\r]8si\u0006\t\"-^5mIJ+w-[:ueft\u0015-\\3\u0015\u0007-\u000b9\t\u0003\u0004\u0002\u0002e\u0001\r!`\u0001\u0011O\u0016$8k\\;sG\u0016\u001c()\u001f(b[\u0016$B!!$\u0002 B)\u0011qRAM{:!\u0011\u0011SAK\u001d\rq\u00151S\u0005\u0002\u0001&\u0019\u0011qS \u0002\u000fA\f7m[1hK&!\u00111TAO\u0005\r\u0019V-\u001d\u0006\u0004\u0003/{\u0004BBAQ5\u0001\u00071*\u0001\u0006t_V\u00148-\u001a(b[\u0016\faB]3hSN$XM]*pkJ\u001cW\r\u0006\u0003\u00026\u0005\u001d\u0006BBA\u00017\u0001\u0007Q0\u0001\u0007sK6|g/Z*pkJ\u001cW\r\u0006\u0003\u00026\u00055\u0006BBA\u00019\u0001\u0007Q0A\bsK\u001eL7\u000f^3s'>,(oY3t\u00035\u0011XmZ5ti\u0016\u00148+\u001b8lg\u0006iQ*\u001a;sS\u000e\u001c8+_:uK6\u0004\"!\u0019\u0011\u0014\u0005\u0001jDCAA[\u0003)\u0019\u0016JT&`%\u0016;U\tW\u000b\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\tImP\u0001\u0005kRLG.\u0003\u0003\u0002N\u0006\r'!\u0002*fO\u0016D\u0018aC*J\u001d.{&+R$F1\u0002\nAbU(V%\u000e+uLU#H\u000bb\u000bQbU(V%\u000e+uLU#H\u000bb\u0003\u0013a\u0003*P\u0019\u0016{vk\u0014*L\u000bJ+\"!!7\u0011\t\u0005m\u0017Q]\u0007\u0003\u0003;TA!a8\u0002b\u0006!A.\u00198h\u0015\t\t\u0019/\u0001\u0003kCZ\f\u0017b\u0001+\u0002^\u0006a!k\u0014'F?^{%kS#SA\u0005Y!k\u0014'F?6\u000b5\u000bV#S\u00031\u0011v\nT#`\u001b\u0006\u001bF+\u0012*!\u00031\u0019VI\u0015,M\u000bR{\u0006+\u0011+I\u00035\u0019VI\u0015,M\u000bR{\u0006+\u0011+IA\u0005\tR*\u0013(J\u001b\u0006cu\fU(M\u0019~+f*\u0013+\u0011\t\u0005U\u0018Q`\u0007\u0003\u0003oTA!!?\u0002|\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005%\u0017\u0011]\u0005\u0005\u0003\u007f\f9P\u0001\u0005US6,WK\\5u\u0003Mi\u0015JT%N\u00032{\u0006k\u0014'M?B+%+S(E!\rq$QA\u0005\u0004\u0005\u000fy$aA%oi\u0006I2\r[3dW6Kg.[7bYB{G\u000e\\5oOB+'/[8e)\u0019\t)D!\u0004\u0003\u0012!9!q\u0002\u0018A\u0002\u0005M\u0018\u0001\u00039pY2,f.\u001b;\t\u000f\tMa\u00061\u0001\u0003\u0004\u0005Q\u0001o\u001c7m!\u0016\u0014\u0018n\u001c3\u0002'\r\u0014X-\u0019;f\u001b\u0016$(/[2t'f\u001cH/Z7\u0015\u000f\u0001\u0014IBa\u0007\u0003\u001e!)\u0011j\fa\u0001\u0017\")qk\fa\u00011\")Al\fa\u0001\u0017\u0002")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final CelebornConf conf;
    private final String servletPath;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private Option<PrometheusServlet> prometheusServlet;
    private boolean running;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static MetricsSystem createMetricsSystem(String string, CelebornConf celebornConf, String string2) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, celebornConf, string2);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static String SERVLET_PATH() {
        return MetricsSystem$.MODULE$.SERVLET_PATH();
    }

    public static String ROLE_MASTER() {
        return MetricsSystem$.MODULE$.ROLE_MASTER();
    }

    public static String ROLE_WORKER() {
        return MetricsSystem$.MODULE$.ROLE_WORKER();
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        MetricsSystem metricsSystem = this;
        synchronized (metricsSystem) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String instance() {
        return this.instance;
    }

    public String servletPath() {
        return this.servletPath;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public PrometheusHttpRequestHandler getPrometheusHandler() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (PrometheusHttpRequestHandler)this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandler($this.conf)).orNull(Predef$.MODULE$.$conforms());
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.report();
            return BoxedUnit.UNIT;
        });
    }

    private String buildRegistryName(Source source) {
        return MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return (Seq)this.sources().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$5)));
    }

    public void registerSource(Source source) {
        this.sources().$plus$eq((Object)source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().$minus$eq((Object)source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                ArrayBuffer arrayBuffer;
                try {
                    Object object = kv._1();
                    String string = "prometheusServlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        Object servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, ArrayBuffer.class, String.class).newInstance(kv._2(), this.registry(), this.sources(), this.servletPath());
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)((PrometheusServlet)servlet)));
                        arrayBuffer = BoxedUnit.UNIT;
                    } else {
                        Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                        arrayBuffer = this.sinks().$plus$eq((Object)((Sink)sink));
                    }
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
                return arrayBuffer;
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$5) {
        String string = x$5.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, CelebornConf conf, String servletPath) {
        this.instance = instance;
        this.conf = conf;
        this.servletPath = servletPath;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.prometheusServlet = None$.MODULE$;
        this.running = false;
        this.metricsConfig.initialize();
    }
}

