/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.view;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;

public class ModelViewGenerator {
    private final NDataModel model;

    public ModelViewGenerator(NDataModel model) {
        this.model = model;
    }

    public String generateViewSQL() {
        return this.getFlatTableSQL();
    }

    private String getFlatTableSQL() {
        StringBuilder builder = new StringBuilder("SELECT ");
        Iterator<TblColRef> cols = this.listModelViewColumns().iterator();
        if (!cols.hasNext()) {
            builder.append(" * ");
        } else {
            while (cols.hasNext()) {
                TblColRef colRef = cols.next();
                builder.append(this.quote(colRef, this.getColumnNameFromModel(colRef)));
                if (!cols.hasNext()) continue;
                builder.append(',');
            }
        }
        builder.append(" FROM ").append(this.quote(this.model.getRootFactTable()));
        for (JoinTableDesc joinTable : this.model.getJoinTables()) {
            JoinDesc join = joinTable.getJoin();
            builder.append(" ").append(join.getType()).append(" JOIN ");
            builder.append(this.quote(joinTable.getTableRef()));
            if (join.getNonEquiJoinCondition() != null) {
                builder.append(" ON ").append(join.getNonEquiJoinCondition().getExpr());
                continue;
            }
            builder.append(" ON ");
            for (int i = 0; i < join.getPrimaryKeyColumns().length; ++i) {
                builder.append(this.quote(join.getPrimaryKeyColumns()[i])).append(" = ").append(this.quote(join.getForeignKeyColumns()[i]));
                if (i == join.getPrimaryKeyColumns().length - 1) continue;
                builder.append(" AND ");
            }
        }
        return builder.toString();
    }

    private String quote(String ... ids) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            sb.append(Quoting.DOUBLE_QUOTE.string).append(ids[i]).append(Quoting.DOUBLE_QUOTE.string);
            if (i == ids.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    private String quote(TableRef ref) {
        if (ref.getTableDesc().getCaseSensitiveDatabase().equals("null")) {
            return this.quote(ref.getTableDesc().getCaseSensitiveName()) + " AS " + this.quote(ref.getAlias());
        }
        return this.quote(ref.getTableDesc().getCaseSensitiveDatabase(), ref.getTableDesc().getCaseSensitiveName()) + " AS " + this.quote(ref.getAlias());
    }

    private String quote(TblColRef tblColRef) {
        return this.quote(tblColRef.getTableAlias(), tblColRef.getName());
    }

    private String quote(TblColRef tblColRef, String alias) {
        return this.quote(tblColRef.getTableAlias(), tblColRef.getName()) + " AS " + this.quote(alias);
    }

    private Set<TblColRef> listModelViewColumns() {
        HashSet<TblColRef> colRefs = new HashSet<TblColRef>();
        this.model.getEffectiveDimensions().forEach((id, colRef) -> colRefs.add((TblColRef)colRef));
        this.model.getEffectiveMeasures().forEach((id, measure) -> colRefs.addAll(measure.getFunction().getColRefs()));
        List<TblColRef> ccCols = colRefs.stream().filter(col -> col.getColumnDesc().isComputedColumn()).collect(Collectors.toList());
        Set<TblColRef> ccTblColRefs = this.getComputedColumnSourceColumns(ccCols);
        ccTblColRefs.removeIf(tblColRef -> !colRefs.contains(tblColRef));
        colRefs.addAll(ccTblColRefs);
        String order = NProjectManager.getProjectConfig((String)this.model.getProject()).getColOrderForSelectStarInModelView();
        if (order.equals("orderByModel")) {
            return this.orderByModelColSequence(colRefs);
        }
        if (order.equals("orderByTable")) {
            return this.orderByTableColSeq(colRefs, this.model);
        }
        return colRefs;
    }

    private Set<TblColRef> orderByTableColSeq(Set<TblColRef> colRefs, NDataModel model) {
        Set linkedTblRefs = model.getAllTableRefs();
        List allCols = linkedTblRefs.stream().map(tableRef -> {
            Collection columns = tableRef.getColumns();
            return columns.stream().sorted(Comparator.comparingInt(o -> o.getColumnDesc().getZeroBasedIndex())).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        LinkedHashSet<TblColRef> orderedTableRefs = new LinkedHashSet<TblColRef>();
        for (TblColRef col : allCols) {
            if (!colRefs.contains(col)) continue;
            orderedTableRefs.add(col);
        }
        return orderedTableRefs;
    }

    private Set<TblColRef> orderByModelColSequence(Set<TblColRef> colRefs) {
        List allExistIds = this.model.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).map(NDataModel.NamedColumn::getId).collect(Collectors.toList());
        LinkedHashSet<TblColRef> orderedTableRefs = new LinkedHashSet<TblColRef>();
        for (Integer id : allExistIds) {
            TblColRef tblColRef = (TblColRef)this.model.getEffectiveCols().get((Object)id);
            if (tblColRef == null || !colRefs.contains(tblColRef)) continue;
            orderedTableRefs.add(tblColRef);
        }
        return orderedTableRefs;
    }

    private Set<TblColRef> getComputedColumnSourceColumns(List<TblColRef> ccCols) {
        List ccExprs = ccCols.stream().map(colRef -> this.model.findCCByCCColumnName(colRef.getName())).filter(Objects::nonNull).map(ComputedColumnDesc::getExpression).collect(Collectors.toList());
        try {
            SqlSelect select = (SqlSelect)CalciteParser.parse((String)("select " + String.join((CharSequence)",", ccExprs)), this.model != null ? this.model.getProject() : null);
            return ModelViewGenerator.getAllIdentifiers((SqlNode)select).stream().map(SqlIdentifier::toString).map(arg_0 -> ((NDataModel)this.model).getColRef(arg_0)).collect(Collectors.toSet());
        }
        catch (SqlParseException e) {
            return new HashSet<TblColRef>();
        }
    }

    private String getColumnNameFromModel(TblColRef colRef) {
        Integer id = (Integer)this.model.getEffectiveCols().inverse().get((Object)colRef);
        return id == null ? null : this.model.getNameByColumnId(id.intValue()).toUpperCase(Locale.getDefault());
    }

    private static List<SqlIdentifier> getAllIdentifiers(SqlNode sqlNode) {
        if (sqlNode instanceof SqlNodeList) {
            return ModelViewGenerator.getAllIdentifiersFromList(((SqlNodeList)sqlNode).getList());
        }
        if (sqlNode instanceof SqlCall) {
            return ModelViewGenerator.getAllIdentifiersFromList(((SqlCall)sqlNode).getOperandList());
        }
        if (sqlNode instanceof SqlIdentifier) {
            return Lists.newArrayList((Object[])new SqlIdentifier[]{(SqlIdentifier)sqlNode});
        }
        return Lists.newArrayList();
    }

    private static List<SqlIdentifier> getAllIdentifiersFromList(List<SqlNode> nodes) {
        return nodes.stream().map(ModelViewGenerator::getAllIdentifiers).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

