/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.dict;

import java.io.IOException;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.spark.dict.NGlobalDictHDFSStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NGlobalDictS3Store
extends NGlobalDictHDFSStore {
    private static final String WORKING_PREFIX = "working_";
    private static final Logger logger = LoggerFactory.getLogger(NGlobalDictS3Store.class);
    private static ConcurrentHashMap<String, Long> pathToVersion = new ConcurrentHashMap();

    public NGlobalDictS3Store(String baseDir) throws IOException {
        super(baseDir);
    }

    @Override
    public void prepareForWrite(String workingDir) throws IOException {
        super.prepareForWrite(workingDir);
        Path working = new Path(workingDir);
        Path workingFlagPath = this.getWorkingFlagPath(this.basePath);
        if (this.fileSystem.exists(workingFlagPath)) {
            this.fileSystem.delete(workingFlagPath, true);
            logger.trace("Working directory {} exits, delete it first", (Object)working);
        }
        this.fileSystem.mkdirs(workingFlagPath);
    }

    @Override
    public Long[] listAllVersions() throws IOException {
        if (!this.fileSystem.exists(this.basePath)) {
            return new Long[0];
        }
        FileStatus[] versionDirs = this.fileSystem.listStatus(this.basePath, path -> path.getName().startsWith("version_"));
        TreeSet<Long> versions = new TreeSet<Long>();
        for (FileStatus versionDir : versionDirs) {
            Path path2 = versionDir.getPath();
            long version = Long.parseLong(path2.getName().substring("version_".length()));
            if (this.fileSystem.exists(this.getWorkingFlagPath(this.basePath, version))) continue;
            versions.add(version);
        }
        return versions.toArray(new Long[versions.size()]);
    }

    @Override
    public void commit(String workingDir, int maxVersions, long versionTTL, long buildVersion) throws IOException {
        this.cleanWorkingFlagPath(this.basePath);
        logger.info("Commit {}", (Object)workingDir);
        this.cleanUp(maxVersions, versionTTL);
    }

    @Override
    public String getWorkingDir(long buildVersion) {
        Path path = this.getWorkingFlagPath(this.basePath, buildVersion);
        long timestamp = Long.parseLong(path.getName().substring(WORKING_PREFIX.length()));
        return this.baseDir + "version_" + timestamp;
    }

    private Path getWorkingFlagPath(Path basePath) {
        return this.getWorkingFlagPath(basePath, System.currentTimeMillis());
    }

    private Path getWorkingFlagPath(Path basePath, long buildVersion) {
        long timestamp = pathToVersion.getOrDefault(basePath.toString(), buildVersion);
        pathToVersion.putIfAbsent(basePath.toString(), timestamp);
        try {
            FileStatus[] workingDirs;
            FileSystem fileSystem = HadoopUtil.getFileSystem((Path)basePath);
            if (fileSystem.exists(basePath) && (workingDirs = fileSystem.listStatus(basePath, path -> path.getName().startsWith(WORKING_PREFIX))).length > 0) {
                Path path2 = workingDirs[0].getPath();
                timestamp = Long.parseLong(path2.getName().substring(WORKING_PREFIX.length()));
            }
        }
        catch (IOException ioe) {
            logger.error("Get exception when get version", (Throwable)ioe);
        }
        return this.generateWorkingFlagPath(basePath, timestamp);
    }

    private Path generateWorkingFlagPath(Path basePath, long version) {
        return new Path(basePath + "/" + WORKING_PREFIX + version);
    }

    private void cleanWorkingFlagPath(Path basePath) throws IOException {
        FileStatus[] workingDirs;
        pathToVersion.remove(basePath.toString());
        FileSystem fileSystem = HadoopUtil.getFileSystem((Path)basePath);
        for (FileStatus workingDir : workingDirs = fileSystem.listStatus(basePath, path -> path.getName().startsWith(WORKING_PREFIX))) {
            logger.info("Clean working path {}", (Object)workingDir);
            fileSystem.delete(workingDir.getPath(), true);
        }
    }
}

