/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasource.storage;

import java.io.Serializable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.QueryStats;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class RewriteRuntimeConfig$
implements Logging {
    public static RewriteRuntimeConfig$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RewriteRuntimeConfig$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void adjustQueryRuntimeConfigs(SparkSession spark, Seq<AddFile> files) {
        QueryStats queryStats = this.getQueryStats(files);
        this.recordQueryMetrics(queryStats);
        this.rewriteShufflePartitionSize(spark, queryStats);
    }

    public int calculatePartitionNumber(QueryStats queryStats, long fileNumSplit, long recordNumSplit, long partitionSizeSplit, long minPartitionSize) {
        long partitionNumByFileNum = queryStats.fileNum() / fileNumSplit + 1L;
        long partitionNumByRecordNum = queryStats.totalRecords() / recordNumSplit + 1L;
        long partitionNumBySize = queryStats.totalSize() / (partitionSizeSplit * 1024L * 1024L) + 1L;
        return (int)BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{partitionNumByFileNum, partitionNumByRecordNum, partitionNumBySize, minPartitionSize})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public void rewriteShufflePartitionSize(SparkSession spark, QueryStats queryStats) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int minPartitionSize = config.getV3ScanMinPartitionNum();
        long fileNumSplit = config.getV3ScanSplitFileNum();
        long recordNumSplit = config.getV3ScanSplitRecordNum();
        long partitionSizeSplit = config.getV3ScanSplitSizeMB();
        int computedPartitionNum = this.calculatePartitionNumber(queryStats, fileNumSplit, recordNumSplit, partitionSizeSplit, minPartitionSize);
        int lastConfigSize = QueryContext.current().getShufflePartitionsReset();
        int finalPartitionSize = BoxesRunTime.unboxToInt((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{computedPartitionNum, lastConfigSize})).max((Ordering)Ordering.Int$.MODULE$));
        spark.sessionState().conf().setLocalProperty(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), Integer.toString(finalPartitionSize));
        QueryContext.current().setShufflePartitionsReset(finalPartitionSize);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(190).append("\n         |Adjust spark.sql.shuffle.partitions = ").append(finalPartitionSize).append("\n         |Partition by file num: ").append(queryStats.fileNum() / fileNumSplit + 1L).append("\n         |Partition by file size: ").append(queryStats.totalSize() / (partitionSizeSplit * 1024L * 1024L) + 1L).append("\n         |Partition by record num: ").append(queryStats.totalRecords() / recordNumSplit + 1L).append("\n         |Min partition size: ").append(minPartitionSize).append("\n    ").toString())).stripMargin());
    }

    private void recordQueryMetrics(QueryStats stats) {
        QueryContext.current().getMetrics().setSourceScanBytes(stats.totalSize());
        QueryContext.current().getMetrics().setSourceScanRows(stats.totalRecords());
    }

    private QueryStats getQueryStats(Seq<AddFile> files) {
        long totalRecords = this.getTotalNumRecords(files);
        long totalSize = this.getTotalFileSize(files);
        int fileNum = files.size();
        return new QueryStats(fileNum, totalRecords, totalSize);
    }

    private long getTotalNumRecords(Seq<AddFile> files) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)RewriteRuntimeConfig$.$anonfun$getTotalNumRecords$1(x$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private long getTotalFileSize(Seq<AddFile> files) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$getTotalNumRecords$1(AddFile x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.numPhysicalRecords().get());
    }

    private RewriteRuntimeConfig$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

