/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.response.SQLResponseV2;
import org.apache.kylin.rest.service.QueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/query"})
public class NQueryControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="queryService")
    private QueryService queryService;

    @Deprecated
    @ApiOperation(value="query4JDBC", tags={"QE"})
    @PostMapping(value={""}, produces={"application/json"})
    @ResponseBody
    public SQLResponse query4JDBC(@Valid @RequestBody PrepareSqlRequest sqlRequest) {
        String projectName = this.checkProjectName(sqlRequest.getProject());
        sqlRequest.setProject(projectName);
        return this.queryService.queryWithCache((SQLRequest)sqlRequest);
    }

    @ApiOperation(value="query", tags={"QE"})
    @PostMapping(value={""}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<SQLResponseV2> query(@Valid @RequestBody PrepareSqlRequest sqlRequest) {
        String projectName = this.checkProjectName(sqlRequest.getProject());
        sqlRequest.setProject(projectName);
        SQLResponse sqlResponse = this.queryService.queryWithCache((SQLRequest)sqlRequest);
        SQLResponseV2 sqlResponseV2 = null == sqlResponse ? null : new SQLResponseV2(sqlResponse);
        return new EnvelopeResponse("000", (Object)sqlResponseV2, "");
    }

    @ApiOperation(value="prepareQuery", tags={"QE"})
    @PostMapping(value={"/prestate"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<SQLResponse> prepareQuery(@Valid @RequestBody PrepareSqlRequest sqlRequest) {
        String projectName = this.checkProjectName(sqlRequest.getProject());
        sqlRequest.setProject(projectName);
        HashMap newToggles = Maps.newHashMap();
        if (sqlRequest.getBackdoorToggles() != null) {
            newToggles.putAll(sqlRequest.getBackdoorToggles());
        }
        newToggles.put("DEBUG_TOGGLE_PREPARE_ONLY", "true");
        sqlRequest.setBackdoorToggles((Map)newToggles);
        return new EnvelopeResponse("000", (Object)this.queryService.queryWithCache((SQLRequest)sqlRequest), "");
    }
}

