/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.cluster.SchedulerInfoCmdHelper$;
import org.apache.kylin.cluster.YarnClusterManager$;
import org.apache.kylin.cluster.parser.SchedulerParser;
import org.apache.kylin.cluster.parser.SchedulerParserFactory$;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0010!\u0001%BQ\u0001\u0010\u0001\u0005\u0002uB\u0001b\u0010\u0001\t\u0006\u0004%I\u0001\u0011\u0005\u0006\t\u0002!\t\u0005\u0011\u0005\u0006\u000b\u0002!\tE\u0012\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\u0006y\u0002!\t! \u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\u001d9\u00111\t\u0011\t\u0002\u0005\u0015cAB\u0010!\u0011\u0003\t9\u0005\u0003\u0004=!\u0011\u0005\u0011\u0011\n\u0005\f\u0003\u0017\u0002\u0002\u0019!a\u0001\n\u0013\ti\u0005C\u0006\u0002^A\u0001\r\u00111A\u0005\n\u0005}\u0003bCA3!\u0001\u0007\t\u0011)Q\u0005\u0003\u001fB1\"a\u001a\u0011\u0001\u0004\u0005\r\u0011\"\u0003\u0002j!Y\u00111\u000e\tA\u0002\u0003\u0007I\u0011BA7\u0011)\t\t\b\u0005a\u0001\u0002\u0003\u0006KA\u0010\u0005\b\u0003g\u0002B\u0011AA;\u0011\u001d\tI\b\u0005C\u0001\u0003wBq!! \u0011\t\u0003\ty\bC\u0004\u0002$B!\t!!*\t\u000f\u0005E\u0006\u0003\"\u0003\u00024\"9\u0011\u0011\u0019\t\u0005\u0002\u0005\r\u0007bBAh!\u0011\u0005\u00111\u0017\u0002\u00133\u0006\u0014hn\u00117vgR,'/T1oC\u001e,'O\u0003\u0002\"E\u000591\r\\;ti\u0016\u0014(BA\u0012%\u0003\u0015Y\u0017\u0010\\5o\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M!\u0001A\u000b\u00195!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011GM\u0007\u0002A%\u00111\u0007\t\u0002\u0010\u0013\u000ecWo\u001d;fe6\u000bg.Y4feB\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\tS:$XM\u001d8bY*\u0011\u0011\bJ\u0001\u0006gB\f'o[\u0005\u0003wY\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002}A\u0011\u0011\u0007A\u0001\u001a[\u0006D\u0018.\\;n%\u0016\u001cx.\u001e:dK\u0006cGn\\2bi&|g.F\u0001B!\t\t$)\u0003\u0002DA\ta!+Z:pkJ\u001cW-\u00138g_\u0006qb-\u001a;dQ6\u000b\u00070[7v[J+7o\\;sG\u0016\fE\u000e\\8dCRLwN\\\u0001\u001cM\u0016$8\r[)vKV,\u0017I^1jY\u0006\u0014G.\u001a*fg>,(oY3\u0015\u0005\u001dS\u0005CA\u0019I\u0013\tI\u0005EA\tBm\u0006LG.\u00192mKJ+7o\\;sG\u0016DQa\u0013\u0003A\u00021\u000b\u0011\"];fk\u0016t\u0015-\\3\u0011\u00055#fB\u0001(S!\tyE&D\u0001Q\u0015\t\t\u0006&\u0001\u0004=e>|GOP\u0005\u0003'2\na\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111\u000bL\u0001\u0019O\u0016$\u0018,\u0019:o\u0003B\u0004H.[2bi&|gNU3q_J$HCA-f!\tQ6-D\u0001\\\u0015\taV,A\u0004sK\u000e|'\u000fZ:\u000b\u0005y{\u0016aA1qS*\u0011\u0001-Y\u0001\u0005s\u0006\u0014hN\u0003\u0002cI\u00051\u0001.\u00193p_BL!\u0001Z.\u0003#\u0005\u0003\b\u000f\\5dCRLwN\u001c*fa>\u0014H\u000fC\u0003g\u000b\u0001\u0007A*A\u0007baBd\u0017nY1uS>t\u0017\nZ\u0001\u0014O\u0016$()^5mIR\u0013\u0018mY6j]\u001e,&\u000f\u001c\u000b\u0003\u0019&DQA\u001b\u0004A\u0002-\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u001d\u0002\u0007M\fH.\u0003\u0002q[\na1\u000b]1sWN+7o]5p]\u0006y1.\u001b7m\u0003B\u0004H.[2bi&|g\u000e\u0006\u0002tmB\u00111\u0006^\u0005\u0003k2\u0012A!\u00168ji\")qo\u0002a\u0001\u0019\u0006I!n\u001c2Ti\u0016\u0004\u0018\n\u001a\u000b\u0004gf\\\b\"\u0002>\t\u0001\u0004a\u0015!\u00046pEN#X\r\u001d)sK\u001aL\u0007\u0010C\u0003x\u0011\u0001\u0007A*\u0001\bhKR\u0014VO\u001c8j]\u001eTuNY:\u0015\u0007y\fi\u0001\u0005\u0003\u0000\u0003\u0013aUBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000f\tAA[1wC&!\u00111BA\u0001\u0005\u0011a\u0015n\u001d;\t\u000f\u0005=\u0011\u00021\u0001\u0002\u0012\u00051\u0011/^3vKN\u0004Ba`A\n\u0019&!\u0011QCA\u0001\u0005\r\u0019V\r^\u0001\u0015M\u0016$8\r[)vKV,7\u000b^1uSN$\u0018nY:\u0015\u0007\u0005\u000bY\u0002C\u0003L\u0015\u0001\u0007A*A\fjg\u0006\u0003\b\u000f\\5dCRLwN\u001c\"fK:\\\u0015\u000e\u001c7fIR!\u0011\u0011EA\u0014!\rY\u00131E\u0005\u0004\u0003Ka#a\u0002\"p_2,\u0017M\u001c\u0005\u0006o.\u0001\r\u0001T\u0001\u0013CB\u0004H.[2bi&|g.\u0012=jgR,G\r\u0006\u0003\u0002\"\u00055\u0002BBA\u0018\u0019\u0001\u0007A*A\u0003k_\nLE-\u0001\bmSN$\u0018+^3vK:\u000bW.Z:\u0015\u0003y\facZ3u\u0003B\u0004H.[2bi&|gNT1nK\nK\u0018\n\u001a\u000b\u0004\u0019\u0006e\u0002bBA\u001e\u001d\u0001\u0007\u0011QH\u0001\ns\u0006\u0014h.\u00119q\u0013\u0012\u00042aKA \u0013\r\t\t\u0005\f\u0002\u0004\u0013:$\u0018AE-be:\u001cE.^:uKJl\u0015M\\1hKJ\u0004\"!\r\t\u0014\u0005AQCCAA#\u0003)I\u0018M\u001d8DY&,g\u000e^\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002Z5\u0011\u00111\u000b\u0006\u0004=\u0006U#bAA,?\u000611\r\\5f]RLA!a\u0017\u0002T\tQ\u0011,\u0019:o\u00072LWM\u001c;\u0002\u001de\f'O\\\"mS\u0016tGo\u0018\u0013fcR\u00191/!\u0019\t\u0013\u0005\r4#!AA\u0002\u0005=\u0013a\u0001=%c\u0005Y\u00110\u0019:o\u00072LWM\u001c;!\u0003II\u0018M\u001d8DYV\u001cH/\u001a:NC:\fw-\u001a:\u0016\u0003y\na#_1s]\u000ecWo\u001d;fe6\u000bg.Y4fe~#S-\u001d\u000b\u0004g\u0006=\u0004\u0002CA2-\u0005\u0005\t\u0019\u0001 \u0002'e\f'O\\\"mkN$XM]'b]\u0006<WM\u001d\u0011\u0002\u001bM,G/W1s]\u000ec\u0017.\u001a8u)\rq\u0014q\u000f\u0005\b\u0003\u0017B\u0002\u0019AA(\u0003E!Wm\u001d;s_fL\u0016M\u001d8DY&,g\u000e\u001e\u000b\u0002g\u0006ia.Z<ZCJt7\t\\5f]R,B!!!\u0002\bR!\u00111QAM!\u0011\t))a\"\r\u0001\u00119\u0011\u0011\u0012\u000eC\u0002\u0005-%!\u0001+\u0012\t\u00055\u00151\u0013\t\u0004W\u0005=\u0015bAAIY\t9aj\u001c;iS:<\u0007cA\u0016\u0002\u0016&\u0019\u0011q\u0013\u0017\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u001cj\u0001\r!!(\u0002\t\t|G-\u001f\t\bW\u0005}\u0015qJAB\u0013\r\t\t\u000b\f\u0002\n\rVt7\r^5p]F\nab^5uQf\u000b'O\\\"mS\u0016tG/\u0006\u0003\u0002(\u0006-F\u0003BAU\u0003[\u0003B!!\"\u0002,\u00129\u0011\u0011R\u000eC\u0002\u0005-\u0005bBAN7\u0001\u0007\u0011q\u0016\t\bW\u0005}\u0015qJAU\u0003A9W\r^*qK\u000eLg-[3e\u0007>tg-\u0006\u0002\u00026B!\u0011qWA_\u001b\t\tILC\u0002\u0002<~\u000bAaY8oM&!\u0011qXA]\u0005EI\u0016M\u001d8D_:4\u0017nZ;sCRLwN\\\u0001\u001fo&$\b.W1s]\u000ec\u0017.\u001a8u\rJ|Wn\u0016:ji\u0016\u001cE.^:uKJ,B!!2\u0002JR!\u0011qYAf!\u0011\t))!3\u0005\u000f\u0005%UD1\u0001\u0002\f\"9\u00111T\u000fA\u0002\u00055\u0007cB\u0016\u0002 \u0006=\u0013qY\u0001!O\u0016$8\u000b]3dS\u001aLW\rZ\"p]\u001a4%o\\7Xe&$Xm\u00117vgR,'\u000f")
public class YarnClusterManager
implements IClusterManager,
Logging {
    private ResourceInfo maximumResourceAllocation;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static YarnConfiguration getSpecifiedConfFromWriteCluster() {
        return YarnClusterManager$.MODULE$.getSpecifiedConfFromWriteCluster();
    }

    public static <T> T withYarnClientFromWriteCluster(Function1<YarnClient, T> function1) {
        return YarnClusterManager$.MODULE$.withYarnClientFromWriteCluster(function1);
    }

    public static <T> T withYarnClient(Function1<YarnClient, T> function1) {
        return YarnClusterManager$.MODULE$.withYarnClient(function1);
    }

    public static <T> T newYarnClient(Function1<YarnClient, T> function1) {
        return YarnClusterManager$.MODULE$.newYarnClient(function1);
    }

    public static void destroyYarnClient() {
        YarnClusterManager$.MODULE$.destroyYarnClient();
    }

    public static YarnClusterManager setYarnClient(YarnClient yarnClient) {
        return YarnClusterManager$.MODULE$.setYarnClient(yarnClient);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void withConfig(KylinConfig config) {
        IClusterManager.withConfig$((IClusterManager)this, (KylinConfig)config);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ResourceInfo maximumResourceAllocation$lzycompute() {
        YarnClusterManager yarnClusterManager = this;
        synchronized (yarnClusterManager) {
            if (!this.bitmap$0) {
                this.maximumResourceAllocation = (ResourceInfo)YarnClusterManager$.MODULE$.withYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> {
                    ResourceInfo resourceInfo;
                    try {
                        GetNewApplicationResponse response = yarnClient.createApplication().getNewApplicationResponse();
                        Resource cap = response.getMaximumResourceCapability();
                        ResourceInfo resourceInfo2 = new ResourceInfo(cap.getMemory(), cap.getVirtualCores());
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Cluster maximum resource allocation ").append(resourceInfo2).toString());
                        resourceInfo = resourceInfo2;
                    }
                    catch (Throwable throwable) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when get resource upper limit per container.", throwable);
                        throw throwable;
                    }
                    return resourceInfo;
                });
                this.bitmap$0 = true;
            }
        }
        return this.maximumResourceAllocation;
    }

    private ResourceInfo maximumResourceAllocation() {
        return !this.bitmap$0 ? this.maximumResourceAllocation$lzycompute() : this.maximumResourceAllocation;
    }

    public ResourceInfo fetchMaximumResourceAllocation() {
        return this.maximumResourceAllocation();
    }

    public AvailableResource fetchQueueAvailableResource(String queueName) {
        String info = SchedulerInfoCmdHelper$.MODULE$.schedulerInfo();
        SchedulerParser parser = SchedulerParserFactory$.MODULE$.create(info);
        parser.parse(info);
        return parser.availableResource(queueName);
    }

    public ApplicationReport getYarnApplicationReport(String applicationId) {
        ApplicationReport applicationReport;
        Object object = new Object();
        try {
            applicationReport = (ApplicationReport)YarnClusterManager$.MODULE$.withYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> {
                String[] array = applicationId.split("_");
                if (array.length < 3) {
                    throw new NonLocalReturnControl(object, null);
                }
                ApplicationId appId = ApplicationId.newInstance((long)new StringOps(Predef$.MODULE$.augmentString(array[1])).toLong(), (int)new StringOps(Predef$.MODULE$.augmentString(array[2])).toInt());
                return yarnClient.getApplicationReport(appId);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                applicationReport = (ApplicationReport)ex.value();
            }
            throw ex;
        }
        return applicationReport;
    }

    public String getBuildTrackingUrl(SparkSession sparkSession) {
        String applicationId = sparkSession.sparkContext().applicationId();
        ApplicationReport applicationReport = this.getYarnApplicationReport(applicationId);
        return applicationReport == null ? null : applicationReport.getTrackingUrl();
    }

    public void killApplication(String jobStepId) {
        this.killApplication("job_step_", jobStepId);
    }

    public void killApplication(String jobStepPrefix, String jobStepId) {
        Object object = new Object();
        try {
            YarnClusterManager$.MODULE$.withYarnClientFromWriteCluster((Function1 & Serializable & scala.Serializable)yarnClient -> {
                YarnClusterManager.$anonfun$killApplication$1(this, object, jobStepPrefix, jobStepId, yarnClient);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public List<String> getRunningJobs(Set<String> queues) {
        return (List)YarnClusterManager$.MODULE$.withYarnClientFromWriteCluster((Function1 & Serializable & scala.Serializable)yarnClient -> {
            List list;
            if (queues.isEmpty()) {
                List applications = yarnClient.getApplications(EnumSet.of(YarnApplicationState.RUNNING));
                list = applications == null ? new ArrayList() : (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(applications).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Buffer$.MODULE$.canBuildFrom())).asJava();
            } else {
                void var3_3;
                ArrayList runningJobs = new ArrayList();
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(queues).asScala()).foreach((Function1 & Serializable & scala.Serializable)queue -> {
                    List applications = yarnClient.getQueueInfo(queue).getApplications();
                    return applications != null ? ((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(applications).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)YarnClusterManager.$anonfun$getRunningJobs$4(x$2)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)runningJobs.add(x$1)), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
                });
                list = var3_3;
            }
            return list;
        });
    }

    public ResourceInfo fetchQueueStatistics(String queueName) {
        return (ResourceInfo)YarnClusterManager$.MODULE$.withYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> {
            QueueStatistics qs = yarnClient.getQueueInfo(queueName).getQueueStatistics();
            return new ResourceInfo((int)qs.getAvailableMemoryMB(), (int)qs.getAvailableVCores());
        });
    }

    public boolean isApplicationBeenKilled(String jobStepId) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(YarnClusterManager$.MODULE$.withYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> BoxesRunTime.boxToBoolean((boolean)YarnClusterManager.$anonfun$isApplicationBeenKilled$1(jobStepId, object, yarnClient))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public boolean applicationExisted(String jobId) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(YarnClusterManager$.MODULE$.withYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> {
                EnumSet<YarnApplicationState> states;
                HashSet types = Sets.newHashSet((Object[])new String[]{"SPARK"});
                List applicationReports = yarnClient.getApplications((Set)types, states = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING));
                if (!CollectionUtils.isEmpty((Collection)applicationReports)) {
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(applicationReports).asScala()).foreach((Function1 & Serializable & scala.Serializable)report -> {
                        YarnClusterManager.$anonfun$applicationExisted$2(jobId, object, report);
                        return BoxedUnit.UNIT;
                    });
                }
                throw new NonLocalReturnControl.mcZ.sp(object, false);
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public List<String> listQueueNames() {
        return (List)YarnClusterManager$.MODULE$.withYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> {
            void var2_2;
            List queues = yarnClient.getAllQueues();
            ArrayList queueNames = Lists.newArrayList();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(queues).asScala()).foreach((Function1 & Serializable & scala.Serializable)queue -> BoxesRunTime.boxToBoolean((boolean)queueNames.add(queue.getQueueName())));
            return var2_2;
        });
    }

    public String getApplicationNameById(int yarnAppId) {
        String string;
        Object object = new Object();
        try {
            YarnClusterManager$.MODULE$.newYarnClient((Function1 & Serializable & scala.Serializable)yarnClient -> {
                YarnClusterManager.$anonfun$getApplicationNameById$1(yarnAppId, object, yarnClient);
                return BoxedUnit.UNIT;
            });
            string = "";
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$killApplication$2(YarnClusterManager $this, String jobStepPrefix$1, String jobStepId$1, ObjectRef orphanApplicationId$1, YarnClient yarnClient$1, ApplicationReport report) {
        block0: {
            if (!report.getName().equalsIgnoreCase(new StringBuilder(0).append(jobStepPrefix$1).append(jobStepId$1).toString())) break block0;
            orphanApplicationId$1.elem = report.getApplicationId().toString();
            yarnClient$1.killApplication(report.getApplicationId());
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("kill orphan yarn application ").append((String)orphanApplicationId$1.elem).append(" succeed, job step ").append(jobStepId$1).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$killApplication$1(YarnClusterManager $this, Object nonLocalReturnKey2$1, String jobStepPrefix$1, String jobStepId$1, YarnClient yarnClient) {
        ObjectRef orphanApplicationId = ObjectRef.create(null);
        try {
            HashSet types = Sets.newHashSet((Object[])new String[]{"SPARK"});
            EnumSet<YarnApplicationState> states = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING);
            List applicationReports = yarnClient.getApplications((Set)types, states);
            if (CollectionUtils.isEmpty((Collection)applicationReports)) {
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(applicationReports).asScala()).foreach((Function1 & Serializable & scala.Serializable)report -> {
                YarnClusterManager.$anonfun$killApplication$2($this, jobStepPrefix$1, jobStepId$1, orphanApplicationId, yarnClient, report);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof YarnException ? true : throwable2 instanceof IOException;
            if (bl) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("kill orphan yarn application ").append((String)orphanApplicationId$1.elem).append(" failed, job step ").append(jobStepId$1).toString(), throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getRunningJobs$4(ApplicationReport x$2) {
        YarnApplicationState yarnApplicationState = x$2.getYarnApplicationState();
        YarnApplicationState yarnApplicationState2 = YarnApplicationState.RUNNING;
        return !(yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState2) : yarnApplicationState2 != null);
    }

    public static final /* synthetic */ void $anonfun$isApplicationBeenKilled$2(String jobStepId$2, Object nonLocalReturnKey3$1, ApplicationReport report) {
        if (report.getName().equalsIgnoreCase(new StringBuilder(9).append("job_step_").append(jobStepId$2).toString())) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isApplicationBeenKilled$1(String jobStepId$2, Object nonLocalReturnKey3$1, YarnClient yarnClient) {
        block0: {
            EnumSet<YarnApplicationState> states;
            HashSet types = Sets.newHashSet((Object[])new String[]{"SPARK"});
            List applicationReports = yarnClient.getApplications((Set)types, states = EnumSet.of(YarnApplicationState.KILLED));
            if (CollectionUtils.isEmpty((Collection)applicationReports)) break block0;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(applicationReports).asScala()).foreach((Function1 & Serializable & scala.Serializable)report -> {
                YarnClusterManager.$anonfun$isApplicationBeenKilled$2(jobStepId$2, nonLocalReturnKey3$1, report);
                return BoxedUnit.UNIT;
            });
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$applicationExisted$2(String jobId$1, Object nonLocalReturnKey4$1, ApplicationReport report) {
        if (report.getName().equalsIgnoreCase(jobId$1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey4$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$getApplicationNameById$2(int yarnAppId$1, Object nonLocalReturnKey5$1, ApplicationReport report) {
        if (report.getApplicationId().getId() == yarnAppId$1) {
            throw new NonLocalReturnControl(nonLocalReturnKey5$1, (Object)report.getName());
        }
    }

    public static final /* synthetic */ void $anonfun$getApplicationNameById$1(int yarnAppId$1, Object nonLocalReturnKey5$1, YarnClient yarnClient) {
        block0: {
            EnumSet<YarnApplicationState> states;
            HashSet types = Sets.newHashSet((Object[])new String[]{"SPARK"});
            List applicationReports = yarnClient.getApplications((Set)types, states = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING));
            if (CollectionUtils.isEmpty((Collection)applicationReports)) break block0;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(applicationReports).asScala()).foreach((Function1 & Serializable & scala.Serializable)report -> {
                YarnClusterManager.$anonfun$getApplicationNameById$2(yarnAppId$1, nonLocalReturnKey5$1, report);
                return BoxedUnit.UNIT;
            });
        }
    }

    public YarnClusterManager() {
        IClusterManager.$init$((IClusterManager)this);
        Logging.$init$((Logging)this);
    }
}

