/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.acl.AclTCRDigest;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractModelService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractModelService.class);
    public static final String VALID_NAME_FOR_MODEL = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_";
    protected static final String SAVE_INDEXES_STRATEGY = "single_dim_and_reduce_hc";
    @Autowired
    public AclEvaluate aclEvaluate;
    @Autowired
    public AccessService accessService;

    public void checkModelPermission(String project, String modelId) {
        String userName = this.aclEvaluate.getCurrentUserName();
        Set groups = this.getCurrentUserGroups();
        if (AclPermissionUtil.isAdmin() || AclPermissionUtil.isAdminInProject((String)project, (Set)groups)) {
            return;
        }
        HashSet allAuthTables = Sets.newHashSet();
        HashSet allAuthColumns = Sets.newHashSet();
        AclTCRDigest auths = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, userName, true);
        allAuthTables.addAll(auths.getTables());
        allAuthColumns.addAll(auths.getColumns());
        for (String group : groups) {
            auths = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, group, false);
            allAuthTables.addAll(auths.getTables());
            allAuthColumns.addAll(auths.getColumns());
        }
        NDataModel model = this.getModelById(modelId, project);
        HashSet tablesInModel = Sets.newHashSet();
        model.getJoinTables().forEach(table -> tablesInModel.add(table.getTable()));
        tablesInModel.add(model.getRootFactTableName());
        tablesInModel.forEach(table -> {
            if (!allAuthTables.contains(table)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, MsgPicker.getMsg().getModelModifyAbandon(table));
            }
        });
        tablesInModel.stream().filter(allAuthTables::contains).forEach(table -> {
            ColumnDesc[] columnDescs = NTableMetadataManager.getInstance((KylinConfig)this.getConfig(), (String)project).getTableDesc(table).getColumns();
            Arrays.stream(columnDescs).map(column -> table + "." + column.getName()).forEach(column -> {
                if (!allAuthColumns.contains(column)) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, MsgPicker.getMsg().getModelModifyAbandon(column));
                }
            });
        });
    }

    public NDataModel getModelById(String modelId, String project) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel nDataModel = modelManager.getDataModelDesc(modelId);
        if (null == nDataModel) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        return nDataModel;
    }

    public NDataModel getModelByAlias(String modelAlias, String project) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel nDataModel = modelManager.getDataModelDescByAlias(modelAlias);
        if (null == nDataModel) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        return nDataModel;
    }

    public Set<String> listAllModelIdsInProject(String project) {
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        return dataModelManager.listAllModelIds();
    }

    public IndexPlan getIndexPlan(String modelId, String project) {
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        return indexPlanManager.getIndexPlan(modelId);
    }

    public void primaryCheck(NDataModel modelDesc) {
        if (modelDesc == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NOT_EXIST, new Object[0]);
        }
        String modelAlias = modelDesc.getAlias();
        if (StringUtils.isEmpty((CharSequence)modelAlias)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_EMPTY, new Object[0]);
        }
        if (!StringUtils.containsOnly((CharSequence)modelAlias, (String)VALID_NAME_FOR_MODEL)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_INVALID, new Object[]{modelAlias});
        }
    }

    private boolean needToDeleteLayout(NTableMetadataManager tableManager, NDataModel model, IndexEntity index) {
        int dimSize = index.getDimensions().size();
        if (dimSize > 1) {
            return true;
        }
        if (dimSize == 0) {
            return false;
        }
        return tableManager.isHighCardinalityDim(model.getColRef((Integer)index.getDimensions().get(0)));
    }

    private Pair<Boolean, Integer> processIndex(NDataModel model, IndexEntity index, IndexPlan.IndexPlanUpdateHandler updateHandler, NTableMetadataManager tableManager) {
        boolean needSplit = true;
        Integer shardByCol = null;
        List layouts = index.getLayouts();
        for (int i = layouts.size() - 1; i >= 0; --i) {
            LayoutEntity layout = (LayoutEntity)layouts.get(i);
            if (layout.isBaseIndex()) {
                needSplit = false;
                continue;
            }
            List shardByCols = layout.getShardByColumns();
            if (CollectionUtils.isNotEmpty((Collection)shardByCols)) {
                shardByCol = (Integer)shardByCols.get(0);
            }
            if (!this.needToDeleteLayout(tableManager, model, index)) continue;
            updateHandler.remove((LayoutEntity)layouts.get(i), IndexEntity.isAggIndex((long)index.getId()), false, false);
        }
        return Pair.newPair((Object)needSplit, shardByCol);
    }

    protected void splitIndexesIntoSingleDimIndexes(NDataModel model, IndexPlan indexPlan) {
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, model.getProject());
        IndexPlan.IndexPlanUpdateHandler updateHandler = indexPlan.createUpdateHandler();
        List indexes = indexPlan.getIndexes();
        for (IndexEntity index : indexes) {
            Pair<Boolean, Integer> needSplitAndShardByCol = this.processIndex(model, index, updateHandler, tableManager);
            boolean needSplit = (Boolean)needSplitAndShardByCol.getFirst();
            Integer shardByCol = (Integer)needSplitAndShardByCol.getSecond();
            if (!needSplit) continue;
            List measures = index.getMeasures();
            for (Integer dimension : index.getDimensions()) {
                TblColRef colRef = model.getColRef(dimension);
                if (tableManager.isHighCardinalityDim(colRef)) {
                    log.warn("The col {} is high cardinality dimension, not recommended as an index", (Object)colRef.getName());
                    continue;
                }
                ArrayList colOrder = Lists.newArrayList();
                colOrder.add(dimension);
                boolean containShardByCol = colOrder.contains(shardByCol);
                colOrder.addAll(measures);
                LayoutEntity singleDimensionAggLayout = containShardByCol ? indexPlan.createLayout((List)colOrder, true, false, (List)Lists.newArrayList((Object[])new Integer[]{shardByCol})) : indexPlan.createLayout((List)colOrder, true, false, (List)Lists.newArrayList());
                updateHandler.add(singleDimensionAggLayout, true, true);
            }
        }
        updateHandler.complete();
    }
}

