/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.curator.framework.imps;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.kyuubi.shaded.curator.RetryLoop;
import org.apache.kyuubi.shaded.curator.drivers.OperationTrace;
import org.apache.kyuubi.shaded.curator.framework.api.BackgroundCallback;
import org.apache.kyuubi.shaded.curator.framework.api.CuratorEventType;
import org.apache.kyuubi.shaded.curator.framework.api.ErrorListenerPathable;
import org.apache.kyuubi.shaded.curator.framework.api.GetACLBuilder;
import org.apache.kyuubi.shaded.curator.framework.api.Pathable;
import org.apache.kyuubi.shaded.curator.framework.api.UnhandledErrorListener;
import org.apache.kyuubi.shaded.curator.framework.imps.BackgroundOperation;
import org.apache.kyuubi.shaded.curator.framework.imps.Backgrounding;
import org.apache.kyuubi.shaded.curator.framework.imps.CuratorEventImpl;
import org.apache.kyuubi.shaded.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.kyuubi.shaded.curator.framework.imps.OperationAndData;
import org.apache.kyuubi.shaded.zookeeper.AsyncCallback;
import org.apache.kyuubi.shaded.zookeeper.data.ACL;
import org.apache.kyuubi.shaded.zookeeper.data.Stat;

class GetACLBuilderImpl
implements GetACLBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<List<ACL>> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Stat responseStat;

    GetACLBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.responseStat = new Stat();
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<List<ACL>> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public Pathable<List<ACL>> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetACLBuilderImpl-Background");
            AsyncCallback.ACLCallback callback = new AsyncCallback.ACLCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                    trace.setReturnCode(rc).setPath(path).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(GetACLBuilderImpl.this.client, CuratorEventType.GET_ACL, rc, path, null, ctx, stat, null, null, null, acl);
                    GetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            this.client.getZooKeeper().getACL(operationAndData.getData(), this.responseStat, callback, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e);
        }
    }

    @Override
    public List<ACL> forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        List<ACL> result = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
        } else {
            result = this.pathInForeground(path);
        }
        return result;
    }

    private List<ACL> pathInForeground(final String path) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetACLBuilderImpl-Foreground");
        List<ACL> result = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<List<ACL>>(){

            @Override
            public List<ACL> call() throws Exception {
                return GetACLBuilderImpl.this.client.getZooKeeper().getACL(path, GetACLBuilderImpl.this.responseStat);
            }
        });
        trace.setPath(path).setStat(this.responseStat).commit();
        return result;
    }
}

