/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.SearchControls;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.stringtemplate.v4.ST;

public final class Query {
    private final String filter;
    private final SearchControls controls;

    public Query(String filter, SearchControls controls) {
        this.filter = filter;
        this.controls = controls;
    }

    public String getFilter() {
        return this.filter;
    }

    public SearchControls getControls() {
        return this.controls;
    }

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public static final class QueryBuilder {
        private ST filterTemplate;
        private final SearchControls controls = new SearchControls();
        private final List<String> returningAttributes = new ArrayList<String>();

        private QueryBuilder() {
            this.controls.setSearchScope(2);
            this.controls.setReturningAttributes(new String[0]);
        }

        public QueryBuilder filter(String filterTemplate) {
            this.filterTemplate = new ST(filterTemplate);
            return this;
        }

        public QueryBuilder map(String key, String value) {
            this.filterTemplate.add(key, (Object)value);
            return this;
        }

        public QueryBuilder map(String key, String[] values) {
            this.filterTemplate.add(key, (Object)values);
            return this;
        }

        public QueryBuilder returnAttribute(String attributeName) {
            this.returningAttributes.add(attributeName);
            return this;
        }

        public QueryBuilder limit(int limit) {
            this.controls.setCountLimit(limit);
            return this;
        }

        private void validate() {
            Preconditions.checkArgument(this.filterTemplate != null, "filter is required for LDAP search query");
        }

        private String createFilter() {
            return this.filterTemplate.render();
        }

        private void updateControls() {
            if (!this.returningAttributes.isEmpty()) {
                this.controls.setReturningAttributes(this.returningAttributes.toArray(new String[this.returningAttributes.size()]));
            }
        }

        public Query build() {
            this.validate();
            String filter = this.createFilter();
            this.updateControls();
            return new Query(filter, this.controls);
        }
    }
}

