/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$ServiceNode$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.io.netty.handler.ssl.SslContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001B-[\u0001\u001dD\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\u0006s\u0002!\tA\u001f\u0004\u0005}\u0002\u0001u\u0010\u0003\u0006\u0002\u000e\r\u0011)\u001a!C\u0001\u0003\u001fA!\"a\n\u0004\u0005#\u0005\u000b\u0011BA\t\u0011)\tIc\u0001BK\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003g\u0019!\u0011#Q\u0001\n\u00055\u0002BB=\u0004\t\u0003\t)\u0004C\u0005\u0002@\r\t\t\u0011\"\u0001\u0002B!I\u0011qI\u0002\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003?\u001a\u0011\u0013!C\u0001\u0003CB\u0011\"!\u001a\u0004\u0003\u0003%\t%a\u001a\t\u0013\u0005]4!!A\u0005\u0002\u0005e\u0004\"CAA\u0007\u0005\u0005I\u0011AAB\u0011%\tyiAA\u0001\n\u0003\n\t\nC\u0005\u0002 \u000e\t\t\u0011\"\u0001\u0002\"\"I\u00111V\u0002\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003_\u001b\u0011\u0011!C!\u0003cC\u0011\"a-\u0004\u0003\u0003%\t%!.\b\u0013\u0005e\u0006!!A\t\u0002\u0005mf\u0001\u0003@\u0001\u0003\u0003E\t!!0\t\re,B\u0011AAf\u0011%\ty+FA\u0001\n\u000b\n\t\fC\u0005\u0002NV\t\t\u0011\"!\u0002P\"I\u0011Q[\u000b\u0002\u0002\u0013\u0005\u0015q\u001b\u0005\u000b;\u0002\u0001\r\u00111A\u0005\u0002\u0005%\bbCA\u007f\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u007fD1B!\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002l\"Y!1\u0002\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0007\u0011-\u0011)\u0002\u0001a\u0001\u0002\u0004%\tAa\u0006\t\u0017\tm\u0001\u00011A\u0001B\u0003&!q\u0002\u0005\f\u0005;\u0001\u0001\u0019!a\u0001\n\u0003\u0011y\u0002C\u0006\u0003(\u0001\u0001\r\u00111A\u0005\u0002\t%\u0002b\u0003B\u0017\u0001\u0001\u0007\t\u0011)Q\u0005\u0005CA1Ba\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00032!Y!\u0011\b\u0001A\u0002\u0003\u0007I\u0011\u0001B\u001e\u0011-\u0011y\u0004\u0001a\u0001\u0002\u0003\u0006KAa\r\t\u0017\t\u0005\u0003\u00011AA\u0002\u0013\u0005!1\t\u0005\f\u0005\u000b\u0002\u0001\u0019!a\u0001\n\u0003\u00119\u0005C\u0006\u0003L\u0001\u0001\r\u0011!Q!\n\u0005]\u0002b\u0003B'\u0001\u0001\u0007\t\u0019!C\u0001\u0003WA1Ba\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003R!Y!Q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0017\u0011\u001d\u00119\u0006\u0001C\u0005\u00053BqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003`\u0001!\tA!\u0018\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!I!q\u000e\u0001\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u00119\t\u0001C\u0001\u0005\u0013CqAa(\u0001\t\u0003\u0011\t\u000bC\u0004\u0003&\u0002!\tAa*\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"I!Q\u0017\u0001\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\b\u0005o\u0003A\u0011\u0001B]\u0011\u001d\u0011)\r\u0001C\u0001\u0005\u000fDqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003|\u0002!\tA!@\t\u000f\r\u0015\u0001\u0001\"\u0001\u0004\b!I1\u0011\u0005\u0001\u0012\u0002\u0013\u000511\u0005\u0005\n\u0007O\u0001\u0011\u0013!C\u0001\u0005cBqa!\u000b\u0001\t\u0003\u0019Y\u0003C\u0005\u0004>\u0001\t\n\u0011\"\u0001\u0004@!I11\t\u0001\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\b\u0007\u000b\u0002A\u0011\u0001B/\u0011\u001d\u00199\u0005\u0001C\u0001\u0007\u0013Bqa!\u0014\u0001\t\u0003\u0019y\u0005C\u0005\u0004^\u0001\t\n\u0011\"\u0001\u0004@!I1q\f\u0001\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\b\u0007C\u0002A\u0011AB2\u0011%\u0019y\tAI\u0001\n\u0003\u0011\t\bC\u0004\u0004\u0012\u0002!Iaa%\t\u0013\r}\u0005!%A\u0005\n\r}\u0002\"CBQ\u0001E\u0005I\u0011\u0002B9\r\u0019\u0019\u0019\u000b\u0001\u0001\u0004&\"Q1qK&\u0003\u0002\u0003\u0006I!!\u0005\t\u0015\tu6J!A!\u0002\u0013\u0011y\f\u0003\u0004z\u0017\u0012\u000511\u0018\u0005\b\u0007\u0007\\E\u0011IBc\u0011\u001d\u00199n\u0013C!\u00073Dqa!:L\t\u0003\u0012ifB\u0004\u0004hjC\ta!;\u0007\reS\u0006\u0012ABv\u0011\u0019I8\u000b\"\u0001\u0004n\"I1q^*C\u0002\u00135\u00111\u0006\u0005\t\u0007c\u001c\u0006\u0015!\u0004\u0002.!Q11_*C\u0002\u0013\u0015!l!>\t\u0011\ru8\u000b)A\u0007\u0007o\u00141#\u0012;dI\u0012K7oY8wKJL8\t\\5f]RT!a\u0017/\u0002\t\u0015$8\r\u001a\u0006\u0003;z\u000baa\u00197jK:$(BA0a\u0003\tA\u0017M\u0003\u0002bE\u000611._;vE&T!a\u00193\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0017aA8sO\u000e\u00011c\u0001\u0001i]B\u0011\u0011\u000e\\\u0007\u0002U*\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\n1\u0011I\\=SK\u001a\u0004\"a\u001c9\u000e\u0003qK!!\u001d/\u0003\u001f\u0011K7oY8wKJL8\t\\5f]R\fAaY8oMB\u0011Ao^\u0007\u0002k*\u0011a\u000fY\u0001\u0007G>tg-[4\n\u0005a,(AC&zkV\u0014\u0017nQ8oM\u00061A(\u001b8jiz\"\"a_?\u0011\u0005q\u0004Q\"\u0001.\t\u000bI\u0014\u0001\u0019A:\u0003\u0017M+'O^5dK:{G-Z\n\u0007\u0007!\f\t!a\u0002\u0011\u0007%\f\u0019!C\u0002\u0002\u0006)\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002j\u0003\u0013I1!a\u0003k\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0005\u0005E\u0001\u0003BA\n\u0003CqA!!\u0006\u0002\u001eA\u0019\u0011q\u00036\u000e\u0005\u0005e!bAA\u000eM\u00061AH]8pizJ1!a\bk\u0003\u0019\u0001&/\u001a3fM&!\u00111EA\u0013\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u00046\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u000b1,\u0017m]3\u0016\u0005\u00055\u0002cA5\u00020%\u0019\u0011\u0011\u00076\u0003\t1{gnZ\u0001\u0007Y\u0016\f7/\u001a\u0011\u0015\r\u0005]\u00121HA\u001f!\r\tIdA\u0007\u0002\u0001!9\u0011Q\u0002\u0005A\u0002\u0005E\u0001bBA\u0015\u0011\u0001\u0007\u0011QF\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u00028\u0005\r\u0013Q\t\u0005\n\u0003\u001bI\u0001\u0013!a\u0001\u0003#A\u0011\"!\u000b\n!\u0003\u0005\r!!\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\n\u0016\u0005\u0003#\tie\u000b\u0002\u0002PA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!C;oG\",7m[3e\u0015\r\tIF[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA/\u0003'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0019+\t\u00055\u0012QJ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0005Y\u0006twM\u0003\u0002\u0002t\u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0004cA5\u0002~%\u0019\u0011q\u00106\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00151\u0012\t\u0004S\u0006\u001d\u0015bAAEU\n\u0019\u0011I\\=\t\u0013\u00055e\"!AA\u0002\u0005m\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0014B1\u0011QSAN\u0003\u000bk!!a&\u000b\u0007\u0005e%.\u0001\u0006d_2dWm\u0019;j_:LA!!(\u0002\u0018\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019+!+\u0011\u0007%\f)+C\u0002\u0002(*\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u000eB\t\t\u00111\u0001\u0002\u0006\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002|\u0005AAo\\*ue&tw\r\u0006\u0002\u0002j\u00051Q-];bYN$B!a)\u00028\"I\u0011QR\n\u0002\u0002\u0003\u0007\u0011QQ\u0001\f'\u0016\u0014h/[2f\u001d>$W\rE\u0002\u0002:U\u0019R!FA`\u0003\u000f\u0001\"\"!1\u0002H\u0006E\u0011QFA\u001c\u001b\t\t\u0019MC\u0002\u0002F*\fqA];oi&lW-\u0003\u0003\u0002J\u0006\r'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111X\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003o\t\t.a5\t\u000f\u00055\u0001\u00041\u0001\u0002\u0012!9\u0011\u0011\u0006\rA\u0002\u00055\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u00033\f)\u000fE\u0003j\u00037\fy.C\u0002\u0002^*\u0014aa\u00149uS>t\u0007cB5\u0002b\u0006E\u0011QF\u0005\u0004\u0003GT'A\u0002+va2,'\u0007C\u0005\u0002hf\t\t\u00111\u0001\u00028\u0005\u0019\u0001\u0010\n\u0019\u0016\u0005\u0005-\b\u0003BAw\u0003sl!!a<\u000b\t\u0005E\u00181_\u0001\u0006U\u0016$8\r\u001a\u0006\u00047\u0006U(BAA|\u0003\tIw.\u0003\u0003\u0002|\u0006=(AB\"mS\u0016tG/\u0001\u0006dY&,g\u000e^0%KF$BA!\u0001\u0003\bA\u0019\u0011Na\u0001\n\u0007\t\u0015!N\u0001\u0003V]&$\b\"CAG7\u0005\u0005\t\u0019AAv\u0003\u001d\u0019G.[3oi\u0002\n\u0001b\u001b<DY&,g\u000e^\u000b\u0003\u0005\u001f\u0001B!!<\u0003\u0012%!!1CAx\u0005\tYe+\u0001\u0007lm\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0003\u0002\te\u0001\"CAG=\u0005\u0005\t\u0019\u0001B\b\u0003%Ygo\u00117jK:$\b%\u0001\u0006m_\u000e\\7\t\\5f]R,\"A!\t\u0011\t\u00055(1E\u0005\u0005\u0005K\tyO\u0001\u0003M_\u000e\\\u0017A\u00047pG.\u001cE.[3oi~#S-\u001d\u000b\u0005\u0005\u0003\u0011Y\u0003C\u0005\u0002\u000e\u0006\n\t\u00111\u0001\u0003\"\u0005YAn\\2l\u00072LWM\u001c;!\u0003-aW-Y:f\u00072LWM\u001c;\u0016\u0005\tM\u0002\u0003BAw\u0005kIAAa\u000e\u0002p\n)A*Z1tK\u0006yA.Z1tK\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0003\u0002\tu\u0002\"CAGI\u0005\u0005\t\u0019\u0001B\u001a\u00031aW-Y:f\u00072LWM\u001c;!\u0003-\u0019XM\u001d<jG\u0016tu\u000eZ3\u0016\u0005\u0005]\u0012aD:feZL7-\u001a(pI\u0016|F%Z9\u0015\t\t\u0005!\u0011\n\u0005\n\u0003\u001b;\u0013\u0011!a\u0001\u0003o\tAb]3sm&\u001cWMT8eK\u0002\n\u0001\u0002\\3bg\u0016$F\u000bT\u0001\rY\u0016\f7/\u001a+U\u0019~#S-\u001d\u000b\u0005\u0005\u0003\u0011\u0019\u0006C\u0005\u0002\u000e*\n\t\u00111\u0001\u0002.\u0005IA.Z1tKR#F\nI\u0001\fEVLG\u000eZ\"mS\u0016tG\u000f\u0006\u0002\u0002l\u0006a1M]3bi\u0016\u001cE.[3oiR\u0011!\u0011A\u0001\fG2|7/Z\"mS\u0016tG/\u0001\u0004de\u0016\fG/\u001a\u000b\t\u0003#\u0011)Ga\u001a\u0003l!9\u0011QB\u0018A\u0002\u0005E\u0001b\u0002B5_\u0001\u0007\u0011\u0011C\u0001\u0005[>$W\rC\u0005\u0003n=\u0002\n\u00111\u0001\u0002$\u0006a1M]3bi\u0016\u0004\u0016M]3oi\u0006\u00012M]3bi\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0005gRC!a)\u0002N\u00059q-\u001a;ECR\fG\u0003\u0002B=\u0005\u000b\u0003R!\u001bB>\u0005\u007fJ1A! k\u0005\u0015\t%O]1z!\rI'\u0011Q\u0005\u0004\u0005\u0007S'\u0001\u0002\"zi\u0016Dq!!\u00042\u0001\u0004\t\t\"A\u0006hKR\u001c\u0005.\u001b7ee\u0016tG\u0003\u0002BF\u0005;\u0003bA!$\u0003\u0018\u0006Ea\u0002\u0002BH\u0005'sA!a\u0006\u0003\u0012&\t1.C\u0002\u0003\u0016*\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001a\nm%\u0001\u0002'jgRT1A!&k\u0011\u001d\tiA\ra\u0001\u0003#\t!\u0002]1uQ\u0016C\u0018n\u001d;t)\u0011\t\u0019Ka)\t\u000f\u000551\u00071\u0001\u0002\u0012\u0005i\u0001/\u0019;i\u001d>tW\t_5tiN$B!a)\u0003*\"9\u0011Q\u0002\u001bA\u0002\u0005E\u0011A\u00023fY\u0016$X\r\u0006\u0004\u0003\u0002\t=&\u0011\u0017\u0005\b\u0003\u001b)\u0004\u0019AA\t\u0011%\u0011\u0019,\u000eI\u0001\u0002\u0004\t\u0019+\u0001\beK2,G/Z\"iS2$'/\u001a8\u0002!\u0011,G.\u001a;fI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D7p]&$xN]*uCR,G\u0003\u0002B\u0001\u0005wCqA!08\u0001\u0004\u0011y,\u0001\ttKJ4\u0018nY3ESN\u001cwN^3ssB\u0019qN!1\n\u0007\t\rGL\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u0006YAO]=XSRDGj\\2l+\u0011\u0011IM!5\u0015\r\t-'q\u001dBv)\u0011\u0011iM!8\u0011\t\t='\u0011\u001b\u0007\u0001\t\u001d\u0011\u0019\u000e\u000fb\u0001\u0005+\u0014\u0011\u0001V\t\u0005\u0005/\f)\tE\u0002j\u00053L1Aa7k\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001Ba89\t\u0003\u0007!\u0011]\u0001\u0002MB)\u0011Na9\u0003N&\u0019!Q\u001d6\u0003\u0011q\u0012\u0017P\\1nKzBqA!;9\u0001\u0004\t\t\"\u0001\u0005m_\u000e\\\u0007+\u0019;i\u0011\u001d\u0011i\u000f\u000fa\u0001\u0003[\tq\u0001^5nK>,H/A\u0007hKR\u001cVM\u001d<fe\"{7\u000f\u001e\u000b\u0005\u0005g\u00149\u0010E\u0003j\u00037\u0014)\u0010E\u0004j\u0003C\f\t\"a\u001f\t\u000f\te\u0018\b1\u0001\u0002\u0012\u0005Ia.Y7fgB\f7-Z\u0001\u0011O\u0016$XI\\4j]\u0016\u0014\u0015PU3g\u0013\u0012$bAa=\u0003\u0000\u000e\u0005\u0001b\u0002B}u\u0001\u0007\u0011\u0011\u0003\u0005\b\u0007\u0007Q\u0004\u0019AA\t\u0003-)gnZ5oKJ+g-\u00133\u0002'\u001d,GoU3sm&\u001cWMT8eKNLeNZ8\u0015\u0011\r%1QCB\f\u0007;\u0001bA!$\u0004\f\r=\u0011\u0002BB\u0007\u00057\u00131aU3r!\ry7\u0011C\u0005\u0004\u0007'a&aD*feZL7-\u001a(pI\u0016LeNZ8\t\u000f\te8\b1\u0001\u0002\u0012!I1\u0011D\u001e\u0011\u0002\u0003\u000711D\u0001\bg&TXm\u00149u!\u0015I\u00171\\A>\u0011%\u0019yb\u000fI\u0001\u0002\u0004\t\u0019+\u0001\u0004tS2,g\u000e^\u0001\u001eO\u0016$8+\u001a:wS\u000e,gj\u001c3fg&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0005\u0016\u0005\u00077\ti%A\u000fhKR\u001cVM\u001d<jG\u0016tu\u000eZ3t\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003=\u0011XmZ5ti\u0016\u00148+\u001a:wS\u000e,G\u0003\u0004B\u0001\u0007[\u0019yc!\r\u00044\re\u0002\"\u0002:?\u0001\u0004\u0019\bb\u0002B}}\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005{s\u0004\u0019\u0001B`\u0011%\u0019)D\u0010I\u0001\u0002\u0004\u00199$A\u0004wKJ\u001c\u0018n\u001c8\u0011\u000b%\fY.!\u0005\t\u0013\rmb\b%AA\u0002\u0005\r\u0016\u0001C3yi\u0016\u0014h.\u00197\u00023I,w-[:uKJ\u001cVM\u001d<jG\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u0003RCaa\u000e\u0002N\u0005I\"/Z4jgR,'oU3sm&\u001cW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003E!WM]3hSN$XM]*feZL7-Z\u0001\u0016a>\u001cH\u000fR3sK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\u0011\t\u0019ka\u0013\t\u000f\te(\t1\u0001\u0002\u0012\u000592M]3bi\u0016\fe\u000eZ$fiN+'O^5dK:{G-\u001a\u000b\r\u0003#\u0019\tfa\u0015\u0004V\re31\f\u0005\u0006e\u000e\u0003\ra\u001d\u0005\b\u0005s\u001c\u0005\u0019AA\t\u0011\u001d\u00199f\u0011a\u0001\u0003#\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\n\u0007k\u0019\u0005\u0013!a\u0001\u0007oA\u0011ba\u000fD!\u0003\u0005\r!a)\u0002C\r\u0014X-\u0019;f\u0003:$w)\u001a;TKJ4\u0018nY3O_\u0012,G\u0005Z3gCVdG\u000f\n\u001b\u0002C\r\u0014X-\u0019;f\u0003:$w)\u001a;TKJ4\u0018nY3O_\u0012,G\u0005Z3gCVdG\u000fJ\u001b\u0002\u001fM$\u0018M\u001d;TK\u000e\u0014X\r\u001e(pI\u0016$\"B!\u0001\u0004f\r%4QNB9\u0011\u001d\u00199G\u0012a\u0001\u0003#\t!b\u0019:fCR,Wj\u001c3f\u0011\u001d\u0019YG\u0012a\u0001\u0003#\t\u0001BY1tKB\u000bG\u000f\u001b\u0005\b\u0007_2\u0005\u0019AA\t\u0003!Ig.\u001b;ECR\f\u0007\"CB:\rB\u0005\t\u0019AAR\u00035)8/\u001a)s_R,7\r^5p]\"\u001aaia\u001e\u0011\t\re41R\u0007\u0003\u0007wRAa! \u0004\u0000\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\u0019\tia!\u0002\r\r|W.\\8o\u0015\u0011\u0019)ia\"\u0002\r\u001d|wn\u001a7f\u0015\t\u0019I)A\u0002d_6LAa!$\u0004|\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u00023M$\u0018M\u001d;TK\u000e\u0014X\r\u001e(pI\u0016$C-\u001a4bk2$H\u0005N\u0001\u0015GJ,\u0017\r^3QKJ\u001c\u0018n\u001d;f]Rtu\u000eZ3\u0015\u0019\u0005]2QSBL\u00073\u001bYj!(\t\u000bID\u0005\u0019A:\t\u000f\te\b\n1\u0001\u0002\u0012!91q\u000b%A\u0002\u0005E\u0001\"CB\u001b\u0011B\u0005\t\u0019AB\u001c\u0011%\u0019Y\u0004\u0013I\u0001\u0002\u0004\t\u0019+\u0001\u0010de\u0016\fG/\u001a)feNL7\u000f^3oi:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005q2M]3bi\u0016\u0004VM]:jgR,g\u000e\u001e(pI\u0016$C-\u001a4bk2$H%\u000e\u0002\u0012\t\u0016\u0014VmZ5ti\u0016\u0014x+\u0019;dQ\u0016\u00148#B&\u0004(\u000e5\u0006\u0003BA6\u0007SKAaa+\u0002n\t1qJ\u00196fGR\u0004Baa,\u00046:!\u0011Q^BY\u0013\u0011\u0019\u0019,a<\u0002\u000b]\u000bGo\u00195\n\t\r]6\u0011\u0018\u0002\t\u0019&\u001cH/\u001a8fe*!11WAx)\u0019\u0019ila0\u0004BB\u0019\u0011\u0011H&\t\u000f\r]c\n1\u0001\u0002\u0012!9!Q\u0018(A\u0002\t}\u0016AB8o\u001d\u0016DH\u000f\u0006\u0003\u0003\u0002\r\u001d\u0007bBBe\u001f\u0002\u000711Z\u0001\u000eo\u0006$8\r\u001b*fgB|gn]3\u0011\t\r571[\u0007\u0003\u0007\u001fTAa!5\u0002p\u0006)q/\u0019;dQ&!1Q[Bh\u000559\u0016\r^2i%\u0016\u001c\bo\u001c8tK\u00069qN\\#se>\u0014H\u0003\u0002B\u0001\u00077Dqa!8Q\u0001\u0004\u0019y.A\u0005uQJ|w/\u00192mKB!!QRBq\u0013\u0011\u0019\u0019Oa'\u0003\u0013QC'o\\<bE2,\u0017aC8o\u0007>l\u0007\u000f\\3uK\u0012\f1#\u0012;dI\u0012K7oY8wKJL8\t\\5f]R\u0004\"\u0001`*\u0014\u0005MCGCABu\u0003AaU)Q*F?:+F\nT0W\u00032+V)A\tM\u000b\u0006\u001bVi\u0018(V\u00192{f+\u0011'V\u000b\u0002\n\u0001\u0003T(D\u0017~\u0003\u0016\t\u0016%`'V3e)\u0013-\u0016\u0005\r]xBAB}C\t\u0019Y0A\u00030Y>\u001c7.A\tM\u001f\u000e[u\fU!U\u0011~\u001bVK\u0012$J1\u0002\u0002")
public class EtcdDiscoveryClient
implements DiscoveryClient {
    private volatile EtcdDiscoveryClient$ServiceNode$ ServiceNode$module;
    private final KyuubiConf conf;
    private Client client;
    private KV kvClient;
    private Lock lockClient;
    private Lease leaseClient;
    private ServiceNode serviceNode;
    private long leaseTTL;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    public EtcdDiscoveryClient$ServiceNode$ ServiceNode() {
        if (this.ServiceNode$module == null) {
            this.ServiceNode$lzycompute$1();
        }
        return this.ServiceNode$module;
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public KV kvClient() {
        return this.kvClient;
    }

    public void kvClient_$eq(KV x$1) {
        this.kvClient = x$1;
    }

    public Lock lockClient() {
        return this.lockClient;
    }

    public void lockClient_$eq(Lock x$1) {
        this.lockClient = x$1;
    }

    public Lease leaseClient() {
        return this.leaseClient;
    }

    public void leaseClient_$eq(Lease x$1) {
        this.leaseClient = x$1;
    }

    public ServiceNode serviceNode() {
        return this.serviceNode;
    }

    public void serviceNode_$eq(ServiceNode x$1) {
        this.serviceNode = x$1;
    }

    public long leaseTTL() {
        return this.leaseTTL;
    }

    public void leaseTTL_$eq(long x$1) {
        this.leaseTTL = x$1;
    }

    private Client buildClient() {
        Client client;
        String[] endpoints = this.conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES()).split(",");
        boolean sslEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_ENABLED()));
        if (!sslEnabled) {
            client = Client.builder().endpoints(endpoints).build();
        } else {
            String caPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).append(" is not defined").toString());
            });
            String crtPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_CRT_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_CRT_PATH().key()).append(" is not defined").toString());
            });
            String keyPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_KEY_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_KEY_PATH().key()).append(" is not defined").toString());
            });
            SslContext context = GrpcSslContexts.forClient().trustManager(new File(caPath)).keyManager(new File(crtPath), new File(keyPath)).build();
            client = Client.builder().endpoints(endpoints).sslContext(context).build();
        }
        return client;
    }

    @Override
    public void createClient() {
        this.client_$eq(this.buildClient());
        this.kvClient_$eq(this.client().getKVClient());
        this.lockClient_$eq(this.client().getLockClient());
        this.leaseClient_$eq(this.client().getLeaseClient());
        this.leaseTTL_$eq(BoxesRunTime.unboxToLong((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_LEASE_TIMEOUT())) / 1000L);
    }

    @Override
    public void closeClient() {
        block0: {
            if (this.client() == null) break block0;
            this.client().close();
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        String string = mode;
        if (!"PERSISTENT".equals(string)) {
            throw new KyuubiException(new StringBuilder(36).append("Create mode ").append(string).append(" is not support in etcd!").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        PutResponse putResponse = this.kvClient().put(ByteSequence.from(path.getBytes()), ByteSequence.from(path.getBytes())).get();
        return path;
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        GetResponse response = this.kvClient().get(ByteSequence.from(path.getBytes())).get();
        if (response.getKvs().isEmpty()) {
            throw new KyuubiException(new StringBuilder(42).append("Key[").append(path).append("] not exists in ETCD, please check it.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return response.getKvs().get(0).getValue().getBytes();
    }

    @Override
    public List<String> getChildren(String path) {
        java.util.List<KeyValue> kvs = this.kvClient().get(ByteSequence.from(path.getBytes()), GetOption.newBuilder().isPrefix(true).build()).get().getKvs();
        return kvs.isEmpty() ? List$.MODULE$.empty() : ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(kvs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(kv.getKey().toString(StandardCharsets.UTF_8))).stripPrefix(path))).stripPrefix("/"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getChildren$2(key)))).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return !this.pathNonExists(path);
    }

    @Override
    public boolean pathNonExists(String path) {
        return this.kvClient().get(ByteSequence.from(path.getBytes())).get().getKvs().isEmpty();
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        this.kvClient().delete(ByteSequence.from(path.getBytes()), DeleteOption.newBuilder().isPrefix(deleteChildren).build()).get();
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        Object object;
        long leaseTime = timeout / 1000L + 3L;
        long leaseId = this.leaseClient().grant(leaseTime).get().getID();
        try {
            try {
                this.lockClient().lock(ByteSequence.from(lockPath.getBytes()), leaseId).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), e);
            }
            object = f.apply();
        }
        catch (Throwable throwable) {
            try {
                this.lockClient().unlock(ByteSequence.from(lockPath.getBytes())).get();
                this.leaseClient().revoke(leaseId).get();
            }
            catch (Exception e) {
                throw new KyuubiException(e.getMessage(), e.getCause());
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            this.lockClient().unlock(ByteSequence.from(lockPath.getBytes())).get();
            this.leaseClient().revoke(leaseId).get();
        }
        catch (Exception e) {
            throw new KyuubiException(e.getMessage(), e.getCause());
        }
        return (T)object2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        None$ none$;
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            none$ = new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$12 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$12, x$3, x$2).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            List<String> hosts = this.getChildren(DiscoveryPaths$.MODULE$.makePath(null, namespace));
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> hosts.size()));
            nil$ = (Seq)hosts.takeRight(size).map((Function1 & Serializable & scala.Serializable)p -> {
                String path = DiscoveryPaths$.MODULE$.makePath(namespace, (String)p);
                String instance = new String(this.getData(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                Tuple2 tuple23 = tuple22;
                String host2 = (String)tuple23._1();
                int port2 = tuple23._2$mcI$sp();
                Option version = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith("version="))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5)).stripPrefix("version="));
                Option engineRefId = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.startsWith("refId="))).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringOps(Predef$.MODULE$.augmentString(x$7)).stripPrefix("refId="));
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(" and version:").append(version).append(" under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId);
            }, List$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        DeRegisterWatcher watcher = new DeRegisterWatcher(this, instance, serviceDiscovery);
        ServiceNode serviceNode = this.createPersistentNode(conf, namespace, instance, version, external);
        this.client().getWatchClient().watch(ByteSequence.from(serviceNode.path().getBytes()), watcher);
        if (this.pathNonExists(serviceNode.path())) {
            throw new KyuubiException(new StringBuilder(61).append("Unable to create keyValue for this Kyuubi ").append("instance[").append(instance).append("] on ETCD.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        block1: {
            if (this.serviceNode() == null) break block1;
            if (this.serviceNode().lease() != EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE()) {
                this.client().getLeaseClient().revoke(this.serviceNode().lease());
                this.delete(this.serviceNode().path(), this.delete$default$2());
            }
            this.serviceNode_$eq(null);
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        boolean bl;
        if (namespace != null) {
            this.delete(DiscoveryPaths$.MODULE$.makePath(null, namespace), true);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external).path();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        this.client().getKVClient().put(ByteSequence.from(basePath.getBytes()), ByteSequence.from(initData.getBytes())).get();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    private ServiceNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        String ns = DiscoveryPaths$.MODULE$.makePath(null, namespace);
        this.create(ns, "PERSISTENT", this.create$default$3());
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String pathPrefix = DiscoveryPaths$.MODULE$.makePath(namespace, new StringBuilder(30).append("serviceUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(";").append(session).append("sequence=").toString());
        String znode = instance;
        LongRef leaseId = LongRef.create((long)EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE());
        ObjectRef realPath = ObjectRef.create(null);
        long timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.tryWithLock(new StringBuilder(5).append(ns).append("/lock").toString(), timeout, (Function0 & Serializable & scala.Serializable)() -> {
            PutResponse putResponse;
            List instances = (List)this.getChildren(pathPrefix).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)EtcdDiscoveryClient.$anonfun$createPersistentNode$5(pathPrefix, x$8)), List$.MODULE$.canBuildFrom());
            long sequence = instances.isEmpty() ? 0L : BoxesRunTime.unboxToLong((Object)instances.max((Ordering)Ordering.Long$.MODULE$)) + 1L;
            realPath$1.elem = new StringBuilder(0).append(pathPrefix).append(new StringOps(Predef$.MODULE$.augmentString("%010d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sequence)}))).toString();
            if (external) {
                putResponse = this.client().getKVClient().put(ByteSequence.from(((String)realPath$1.elem).getBytes()), ByteSequence.from(znode.getBytes())).get();
            } else {
                leaseId$1.elem = this.client().getLeaseClient().grant(this.leaseTTL()).get().getID();
                this.client().getLeaseClient().keepAlive(leaseId$1.elem, new StreamObserver<LeaseKeepAliveResponse>(null){

                    public void onNext(LeaseKeepAliveResponse v) {
                    }

                    public void onError(Throwable throwable) {
                    }

                    public void onCompleted() {
                    }
                });
                putResponse = this.client().getKVClient().put(ByteSequence.from(((String)realPath$1.elem).getBytes()), ByteSequence.from(znode.getBytes()), PutOption.newBuilder().withLeaseId(leaseId$1.elem).build()).get();
            }
            return putResponse;
        });
        return new ServiceNode(this, (String)realPath.elem, leaseId.elem);
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    private final void ServiceNode$lzycompute$1() {
        EtcdDiscoveryClient etcdDiscoveryClient = this;
        synchronized (etcdDiscoveryClient) {
            if (this.ServiceNode$module == null) {
                this.ServiceNode$module = new EtcdDiscoveryClient$ServiceNode$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getChildren$2(String key) {
        return new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && !key.startsWith("lock");
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(engineRefId$1)));
    }

    public static final /* synthetic */ long $anonfun$createPersistentNode$5(String pathPrefix$1, String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(x$8)).stripPrefix(pathPrefix$1))).toLong();
    }

    public EtcdDiscoveryClient(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$(this);
    }

    public class DeRegisterWatcher
    implements Watch.Listener {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        @Override
        public void onNext(WatchResponse watchResponse) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(watchResponse.getEvents()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeRegisterWatcher.$anonfun$onNext$1(x$9)))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                DeRegisterWatcher.$anonfun$onNext$2(this, x$10);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public void onError(Throwable throwable) {
            throw new KyuubiException(throwable.getMessage(), throwable.getCause());
        }

        @Override
        public void onCompleted() {
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onNext$1(WatchEvent x$9) {
            WatchEvent.EventType eventType = x$9.getEventType();
            WatchEvent.EventType eventType2 = WatchEvent.EventType.DELETE;
            return !(eventType != null ? !((Object)((Object)eventType)).equals((Object)eventType2) : eventType2 != null);
        }

        public static final /* synthetic */ void $anonfun$onNext$2(DeRegisterWatcher $this, WatchEvent x$10) {
            $this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(123).append("This Kyuubi instance ").append($this.instance).append(" is now de-registered from").append(" ETCD. The server will be shut down after the last client session completes.").toString());
            $this.serviceDiscovery.stopGracefully($this.serviceDiscovery.stopGracefully$default$1());
        }

        public DeRegisterWatcher(EtcdDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class ServiceNode
    implements Product,
    scala.Serializable {
        private final String path;
        private final long lease;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public String path() {
            return this.path;
        }

        public long lease() {
            return this.lease;
        }

        public ServiceNode copy(String path, long lease) {
            return new ServiceNode(this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer(), path, lease);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.lease();
        }

        public String productPrefix() {
            return "ServiceNode";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.lease());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServiceNode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lease()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ServiceNode)) return false;
            if (((ServiceNode)object).org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() != this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ServiceNode serviceNode = (ServiceNode)x$1;
            String string = this.path();
            String string2 = serviceNode.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.lease() != serviceNode.lease()) return false;
            if (!serviceNode.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() {
            return this.$outer;
        }

        public ServiceNode(EtcdDiscoveryClient $outer, String path, long lease) {
            this.path = path;
            this.lease = lease;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

