/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.AbstractNameResolver;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IPNameResolver
extends AbstractNameResolver {
    public static final String SCHEME = "ip";
    private final List<HostAndPort> addresses;

    public IPNameResolver(URI targetUri) {
        super(targetUri);
        this.addresses = Stream.of(targetUri.getPath().split(",")).map(address -> address.startsWith("/") ? address.substring(1) : address).map(HostAndPort::fromString).collect(Collectors.toList());
    }

    @Override
    protected List<EquivalentAddressGroup> computeAddressGroups() {
        if (this.addresses.isEmpty()) {
            throw EtcdExceptionFactory.newEtcdException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unable to resolve endpoint " + this.getTargetUri()));
        }
        return this.addresses.stream().map(address -> new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(address.getHost(), address.getPortOrDefault(2379)), Strings.isNullOrEmpty((String)this.getServiceAuthority()) ? Attributes.newBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, (Object)address.toString()).build() : Attributes.EMPTY)).collect(Collectors.toList());
    }
}

