/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.jpa.dao.EventRepository;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.service.AbstractPagingAndSortingService;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional
public class EventServiceImpl
extends AbstractPagingAndSortingService
implements EventService {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private EventRepository eventRepository;

    @Override
    public List<EventModel> getEvents() {
        return this.eventRepository.findAll();
    }

    @Override
    public List<EventModel> getEvents(String catalogId) {
        return this.eventRepository.findByCatalogId(catalogId);
    }

    @Override
    public List<EventModel> getEvents(int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.eventRepository.findAll(pageable);
        return page.getContent();
    }

    @Override
    public List<EventModel> getEvents(String catalogId, int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.eventRepository.findByCatalogId(catalogId, pageable);
        return page.getContent();
    }

    @Override
    public Map<String, EventModel> getEventMap() {
        List<EventModel> events = this.getEvents();
        HashMap<String, EventModel> eventMap = new HashMap<String, EventModel>(events.size());
        for (EventModel event : events) {
            eventMap.put(event.getName(), event);
        }
        return eventMap;
    }

    @Override
    public Optional<EventModel> getEvent(Long eventId) {
        return this.eventRepository.findOne(eventId);
    }

    @Override
    public Optional<EventModel> getEvent(String catalogId, String eventName) {
        return this.eventRepository.findByCatalogIdAndName(catalogId, eventName);
    }

    @Override
    public EventModel saveEvent(EventModel event) {
        return this.eventRepository.save(event);
    }

    @Override
    public void deleteEvent(Long eventId) {
        this.eventRepository.deleteById(eventId);
    }
}

