/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.catalog.api.Product;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.model.ProductModel;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.modelmapper.AbstractConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductConverter
extends AbstractConverter<Product, ProductModel> {
    @Autowired
    private EventService eventService;

    public ProductModel convert(Product product) {
        Map<String, EventModel> eventMap = this.eventService.getEventMap();
        ProductModel model = new ProductModel();
        model.setId(product.getId());
        model.setName(product.getName());
        model.setDescription(product.getDescription());
        model.setDisplayName(product.getDisplayName());
        model.setCatalogId(product.getCatalogId());
        ArrayList<EventModel> events = new ArrayList<EventModel>(product.getEvents().size());
        for (String name : product.getEvents()) {
            EventModel event = eventMap.get(name);
            if (event != null) {
                events.add(event);
                continue;
            }
            throw new IllegalArgumentException("Unknown event " + name + " for product " + product.getName());
        }
        model.setEvents(events);
        return model;
    }
}

