﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class RussianStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "\u0432", -1, 1 ),
                    new Among ( "\u0438\u0432", 0, 2 ),
                    new Among ( "\u044B\u0432", 0, 2 ),
                    new Among ( "\u0432\u0448\u0438", -1, 1 ),
                    new Among ( "\u0438\u0432\u0448\u0438", 3, 2 ),
                    new Among ( "\u044B\u0432\u0448\u0438", 3, 2 ),
                    new Among ( "\u0432\u0448\u0438\u0441\u044C", -1, 1 ),
                    new Among ( "\u0438\u0432\u0448\u0438\u0441\u044C", 6, 2 ),
                    new Among ( "\u044B\u0432\u0448\u0438\u0441\u044C", 6, 2 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "\u0435\u0435", -1, 1 ),
                    new Among ( "\u0438\u0435", -1, 1 ),
                    new Among ( "\u043E\u0435", -1, 1 ),
                    new Among ( "\u044B\u0435", -1, 1 ),
                    new Among ( "\u0438\u043C\u0438", -1, 1 ),
                    new Among ( "\u044B\u043C\u0438", -1, 1 ),
                    new Among ( "\u0435\u0439", -1, 1 ),
                    new Among ( "\u0438\u0439", -1, 1 ),
                    new Among ( "\u043E\u0439", -1, 1 ),
                    new Among ( "\u044B\u0439", -1, 1 ),
                    new Among ( "\u0435\u043C", -1, 1 ),
                    new Among ( "\u0438\u043C", -1, 1 ),
                    new Among ( "\u043E\u043C", -1, 1 ),
                    new Among ( "\u044B\u043C", -1, 1 ),
                    new Among ( "\u0435\u0433\u043E", -1, 1 ),
                    new Among ( "\u043E\u0433\u043E", -1, 1 ),
                    new Among ( "\u0435\u043C\u0443", -1, 1 ),
                    new Among ( "\u043E\u043C\u0443", -1, 1 ),
                    new Among ( "\u0438\u0445", -1, 1 ),
                    new Among ( "\u044B\u0445", -1, 1 ),
                    new Among ( "\u0435\u044E", -1, 1 ),
                    new Among ( "\u043E\u044E", -1, 1 ),
                    new Among ( "\u0443\u044E", -1, 1 ),
                    new Among ( "\u044E\u044E", -1, 1 ),
                    new Among ( "\u0430\u044F", -1, 1 ),
                    new Among ( "\u044F\u044F", -1, 1 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "\u0435\u043C", -1, 1 ),
                    new Among ( "\u043D\u043D", -1, 1 ),
                    new Among ( "\u0432\u0448", -1, 1 ),
                    new Among ( "\u0438\u0432\u0448", 2, 2 ),
                    new Among ( "\u044B\u0432\u0448", 2, 2 ),
                    new Among ( "\u0449", -1, 1 ),
                    new Among ( "\u044E\u0449", 5, 1 ),
                    new Among ( "\u0443\u044E\u0449", 6, 2 )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "\u0441\u044C", -1, 1 ),
                    new Among ( "\u0441\u044F", -1, 1 )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "\u043B\u0430", -1, 1 ),
                    new Among ( "\u0438\u043B\u0430", 0, 2 ),
                    new Among ( "\u044B\u043B\u0430", 0, 2 ),
                    new Among ( "\u043D\u0430", -1, 1 ),
                    new Among ( "\u0435\u043D\u0430", 3, 2 ),
                    new Among ( "\u0435\u0442\u0435", -1, 1 ),
                    new Among ( "\u0438\u0442\u0435", -1, 2 ),
                    new Among ( "\u0439\u0442\u0435", -1, 1 ),
                    new Among ( "\u0435\u0439\u0442\u0435", 7, 2 ),
                    new Among ( "\u0443\u0439\u0442\u0435", 7, 2 ),
                    new Among ( "\u043B\u0438", -1, 1 ),
                    new Among ( "\u0438\u043B\u0438", 10, 2 ),
                    new Among ( "\u044B\u043B\u0438", 10, 2 ),
                    new Among ( "\u0439", -1, 1 ),
                    new Among ( "\u0435\u0439", 13, 2 ),
                    new Among ( "\u0443\u0439", 13, 2 ),
                    new Among ( "\u043B", -1, 1 ),
                    new Among ( "\u0438\u043B", 16, 2 ),
                    new Among ( "\u044B\u043B", 16, 2 ),
                    new Among ( "\u0435\u043C", -1, 1 ),
                    new Among ( "\u0438\u043C", -1, 2 ),
                    new Among ( "\u044B\u043C", -1, 2 ),
                    new Among ( "\u043D", -1, 1 ),
                    new Among ( "\u0435\u043D", 22, 2 ),
                    new Among ( "\u043B\u043E", -1, 1 ),
                    new Among ( "\u0438\u043B\u043E", 24, 2 ),
                    new Among ( "\u044B\u043B\u043E", 24, 2 ),
                    new Among ( "\u043D\u043E", -1, 1 ),
                    new Among ( "\u0435\u043D\u043E", 27, 2 ),
                    new Among ( "\u043D\u043D\u043E", 27, 1 ),
                    new Among ( "\u0435\u0442", -1, 1 ),
                    new Among ( "\u0443\u0435\u0442", 30, 2 ),
                    new Among ( "\u0438\u0442", -1, 2 ),
                    new Among ( "\u044B\u0442", -1, 2 ),
                    new Among ( "\u044E\u0442", -1, 1 ),
                    new Among ( "\u0443\u044E\u0442", 34, 2 ),
                    new Among ( "\u044F\u0442", -1, 2 ),
                    new Among ( "\u043D\u044B", -1, 1 ),
                    new Among ( "\u0435\u043D\u044B", 37, 2 ),
                    new Among ( "\u0442\u044C", -1, 1 ),
                    new Among ( "\u0438\u0442\u044C", 39, 2 ),
                    new Among ( "\u044B\u0442\u044C", 39, 2 ),
                    new Among ( "\u0435\u0448\u044C", -1, 1 ),
                    new Among ( "\u0438\u0448\u044C", -1, 2 ),
                    new Among ( "\u044E", -1, 2 ),
                    new Among ( "\u0443\u044E", 44, 2 )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "\u0430", -1, 1 ),
                    new Among ( "\u0435\u0432", -1, 1 ),
                    new Among ( "\u043E\u0432", -1, 1 ),
                    new Among ( "\u0435", -1, 1 ),
                    new Among ( "\u0438\u0435", 3, 1 ),
                    new Among ( "\u044C\u0435", 3, 1 ),
                    new Among ( "\u0438", -1, 1 ),
                    new Among ( "\u0435\u0438", 6, 1 ),
                    new Among ( "\u0438\u0438", 6, 1 ),
                    new Among ( "\u0430\u043C\u0438", 6, 1 ),
                    new Among ( "\u044F\u043C\u0438", 6, 1 ),
                    new Among ( "\u0438\u044F\u043C\u0438", 10, 1 ),
                    new Among ( "\u0439", -1, 1 ),
                    new Among ( "\u0435\u0439", 12, 1 ),
                    new Among ( "\u0438\u0435\u0439", 13, 1 ),
                    new Among ( "\u0438\u0439", 12, 1 ),
                    new Among ( "\u043E\u0439", 12, 1 ),
                    new Among ( "\u0430\u043C", -1, 1 ),
                    new Among ( "\u0435\u043C", -1, 1 ),
                    new Among ( "\u0438\u0435\u043C", 18, 1 ),
                    new Among ( "\u043E\u043C", -1, 1 ),
                    new Among ( "\u044F\u043C", -1, 1 ),
                    new Among ( "\u0438\u044F\u043C", 21, 1 ),
                    new Among ( "\u043E", -1, 1 ),
                    new Among ( "\u0443", -1, 1 ),
                    new Among ( "\u0430\u0445", -1, 1 ),
                    new Among ( "\u044F\u0445", -1, 1 ),
                    new Among ( "\u0438\u044F\u0445", 26, 1 ),
                    new Among ( "\u044B", -1, 1 ),
                    new Among ( "\u044C", -1, 1 ),
                    new Among ( "\u044E", -1, 1 ),
                    new Among ( "\u0438\u044E", 30, 1 ),
                    new Among ( "\u044C\u044E", 30, 1 ),
                    new Among ( "\u044F", -1, 1 ),
                    new Among ( "\u0438\u044F", 33, 1 ),
                    new Among ( "\u044C\u044F", 33, 1 )
                };

        private readonly static Among[] a_6 = {
                    new Among ( "\u043E\u0441\u0442", -1, 1 ),
                    new Among ( "\u043E\u0441\u0442\u044C", -1, 1 )
                };

        private readonly static Among[] a_7 = {
                    new Among ( "\u0435\u0439\u0448\u0435", -1, 1 ),
                    new Among ( "\u043D", -1, 2 ),
                    new Among ( "\u0435\u0439\u0448", -1, 1 ),
                    new Among ( "\u044C", -1, 3 )
                };

        private static readonly char[] g_v = { (char)33, (char)65, (char)8, (char)232 };

        private int I_p2;
        private int I_pV;

        private void copy_from(RussianStemmer other)
        {
            I_p2 = other.I_p2;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_mark_regions()
        {
            int v_1;
            // (, line 57
            I_pV = m_limit;
            I_p2 = m_limit;
            // do, line 61
            v_1 = m_cursor;
            do
            {
                // (, line 61
                // gopast, line 62
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 1072, 1103)))
                        {
                            goto lab2;
                        }
                        goto golab1;
                    } while (false);
                    lab2:
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                }
                golab1:
                // setmark pV, line 62
                I_pV = m_cursor;
                // gopast, line 62
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 1072, 1103)))
                        {
                            goto lab4;
                        }
                        goto golab3;
                    } while (false);
                    lab4:
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                }
                golab3:
                // gopast, line 63
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 1072, 1103)))
                        {
                            goto lab6;
                        }
                        goto golab5;
                    } while (false);
                    lab6:
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                }
                golab5:
                // gopast, line 63
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 1072, 1103)))
                        {
                            goto lab8;
                        }
                        goto golab7;
                    } while (false);
                    lab8:
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                }
                golab7:
                // setmark p2, line 63
                I_p2 = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_perfective_gerund()
        {
            int among_var;
            int v_1;
            // (, line 71
            // [, line 72
            m_ket = m_cursor;
            // substring, line 72
            among_var = FindAmongB(a_0, 9);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 72
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 76
                    // or, line 76
                    do
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 76
                            if (!(Eq_S_B(1, "\u0430")))
                            {
                                goto lab1;
                            }
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_1;
                        // literal, line 76
                        if (!(Eq_S_B(1, "\u044F")))
                        {
                            return false;
                        }
                    } while (false);
                    lab0:
                    // delete, line 76
                    SliceDel();
                    break;
                case 2:
                    // (, line 83
                    // delete, line 83
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_adjective()
        {
            int among_var;
            // (, line 87
            // [, line 88
            m_ket = m_cursor;
            // substring, line 88
            among_var = FindAmongB(a_1, 26);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 88
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 97
                    // delete, line 97
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_adjectival()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 101
            // call adjective, line 102
            if (!r_adjective())
            {
                return false;
            }
            // try, line 109
            v_1 = m_limit - m_cursor;
            do
            {
                // (, line 109
                // [, line 110
                m_ket = m_cursor;
                // substring, line 110
                among_var = FindAmongB(a_2, 8);
                if (among_var == 0)
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // ], line 110
                m_bra = m_cursor;
                switch (among_var)
                {
                    case 0:
                        m_cursor = m_limit - v_1;
                        goto lab0;
                    case 1:
                        // (, line 115
                        // or, line 115
                        do
                        {
                            v_2 = m_limit - m_cursor;
                            do
                            {
                                // literal, line 115
                                if (!(Eq_S_B(1, "\u0430")))
                                {
                                    goto lab2;
                                }
                                goto lab1;
                            } while (false);
                            lab2:
                            m_cursor = m_limit - v_2;
                            // literal, line 115
                            if (!(Eq_S_B(1, "\u044F")))
                            {
                                m_cursor = m_limit - v_1;
                                goto lab0;
                            }
                        } while (false);
                        lab1:
                        // delete, line 115
                        SliceDel();
                        break;
                    case 2:
                        // (, line 122
                        // delete, line 122
                        SliceDel();
                        break;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_reflexive()
        {
            int among_var;
            // (, line 128
            // [, line 129
            m_ket = m_cursor;
            // substring, line 129
            among_var = FindAmongB(a_3, 2);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 129
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 132
                    // delete, line 132
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_verb()
        {
            int among_var;
            int v_1;
            // (, line 136
            // [, line 137
            m_ket = m_cursor;
            // substring, line 137
            among_var = FindAmongB(a_4, 46);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 137
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 143
                    // or, line 143
                    do
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 143
                            if (!(Eq_S_B(1, "\u0430")))
                            {
                                goto lab1;
                            }
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_1;
                        // literal, line 143
                        if (!(Eq_S_B(1, "\u044F")))
                        {
                            return false;
                        }
                    } while (false);
                    lab0:
                    // delete, line 143
                    SliceDel();
                    break;
                case 2:
                    // (, line 151
                    // delete, line 151
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_noun()
        {
            int among_var;
            // (, line 159
            // [, line 160
            m_ket = m_cursor;
            // substring, line 160
            among_var = FindAmongB(a_5, 36);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 160
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 167
                    // delete, line 167
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_derivational()
        {
            int among_var;
            // (, line 175
            // [, line 176
            m_ket = m_cursor;
            // substring, line 176
            among_var = FindAmongB(a_6, 2);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 176
            m_bra = m_cursor;
            // call R2, line 176
            if (!r_R2())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 179
                    // delete, line 179
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_tidy_up()
        {
            int among_var;
            // (, line 183
            // [, line 184
            m_ket = m_cursor;
            // substring, line 184
            among_var = FindAmongB(a_7, 4);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 184
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 188
                    // delete, line 188
                    SliceDel();
                    // [, line 189
                    m_ket = m_cursor;
                    // literal, line 189
                    if (!(Eq_S_B(1, "\u043D")))
                    {
                        return false;
                    }
                    // ], line 189
                    m_bra = m_cursor;
                    // literal, line 189
                    if (!(Eq_S_B(1, "\u043D")))
                    {
                        return false;
                    }
                    // delete, line 189
                    SliceDel();
                    break;
                case 2:
                    // (, line 192
                    // literal, line 192
                    if (!(Eq_S_B(1, "\u043D")))
                    {
                        return false;
                    }
                    // delete, line 192
                    SliceDel();
                    break;
                case 3:
                    // (, line 194
                    // delete, line 194
                    SliceDel();
                    break;
            }
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            // (, line 199
            // do, line 201
            v_1 = m_cursor;
            do
            {
                // call mark_regions, line 201
                if (!r_mark_regions())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // backwards, line 202
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // setlimit, line 202
            v_2 = m_limit - m_cursor;
            // tomark, line 202
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_3 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_2;
            // (, line 202
            // do, line 203
            v_4 = m_limit - m_cursor;
            do
            {
                // (, line 203
                // or, line 204
                do
                {
                    v_5 = m_limit - m_cursor;
                    do
                    {
                        // call perfective_gerund, line 204
                        if (!r_perfective_gerund())
                        {
                            goto lab3;
                        }
                        goto lab2;
                    } while (false);
                    lab3:
                    m_cursor = m_limit - v_5;
                    // (, line 205
                    // try, line 205
                    v_6 = m_limit - m_cursor;
                    do
                    {
                        // call reflexive, line 205
                        if (!r_reflexive())
                        {
                            m_cursor = m_limit - v_6;
                            goto lab4;
                        }
                    } while (false);
                    lab4:
                    // or, line 206
                    do
                    {
                        v_7 = m_limit - m_cursor;
                        do
                        {
                            // call adjectival, line 206
                            if (!r_adjectival())
                            {
                                goto lab6;
                            }
                            goto lab5;
                        } while (false);
                        lab6:
                        m_cursor = m_limit - v_7;
                        do
                        {
                            // call verb, line 206
                            if (!r_verb())
                            {
                                goto lab7;
                            }
                            goto lab5;
                        } while (false);
                        lab7:
                        m_cursor = m_limit - v_7;
                        // call noun, line 206
                        if (!r_noun())
                        {
                            goto lab1;
                        }
                    } while (false);
                    lab5: {/* LUCENENET: intentionally blank */}
                } while (false);
                lab2: {/* LUCENENET: intentionally blank */}
            } while (false);
            lab1:
            m_cursor = m_limit - v_4;
            // try, line 209
            v_8 = m_limit - m_cursor;
            do
            {
                // (, line 209
                // [, line 209
                m_ket = m_cursor;
                // literal, line 209
                if (!(Eq_S_B(1, "\u0438")))
                {
                    m_cursor = m_limit - v_8;
                    goto lab8;
                }
                // ], line 209
                m_bra = m_cursor;
                // delete, line 209
                SliceDel();
            } while (false);
            lab8:
            // do, line 212
            v_9 = m_limit - m_cursor;
            do
            {
                // call derivational, line 212
                if (!r_derivational())
                {
                    goto lab9;
                }
            } while (false);
            lab9:
            m_cursor = m_limit - v_9;
            // do, line 213
            v_10 = m_limit - m_cursor;
            do
            {
                // call tidy_up, line 213
                if (!r_tidy_up())
                {
                    goto lab10;
                }
            } while (false);
            lab10:
            m_cursor = m_limit - v_10;
            m_limit_backward = v_3;
            m_cursor = m_limit_backward; return true;
        }
        public override bool Equals(object o)
        {
            return o is RussianStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}