/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.stream.Field;

public abstract class AbstractHeader
implements Header {
    private final List<Field> fields = new LinkedList<Field>();
    private final Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();

    public AbstractHeader() {
    }

    public AbstractHeader(Header other) {
        for (Field otherField : other.getFields()) {
            this.addField(otherField);
        }
    }

    @Override
    public void addField(Field field) {
        List<Field> values = this.fieldMap.get(field.getName().toLowerCase(Locale.US));
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(field.getName().toLowerCase(Locale.US), values);
        }
        values.add(field);
        this.fields.add(field);
    }

    @Override
    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public Field getField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    @Override
    public <F extends Field> F getField(String name, Class<F> clazz) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        for (int i = 0; i < l.size(); ++i) {
            Field field = l.get(i);
            if (!clazz.isInstance(field)) continue;
            return (F)((Field)clazz.cast(field));
        }
        return null;
    }

    @Override
    public List<Field> getFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        List<Field> results = l == null || l.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(l);
        return results;
    }

    @Override
    public <F extends Field> List<F> getFields(String name, Class<F> clazz) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null) {
            return Collections.emptyList();
        }
        ArrayList<F> results = new ArrayList<F>();
        for (int i = 0; i < l.size(); ++i) {
            Field field = l.get(i);
            if (!clazz.isInstance(field)) continue;
            results.add(clazz.cast(field));
        }
        return results;
    }

    @Override
    public Iterator<Field> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    @Override
    public int removeFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> removed = this.fieldMap.remove(lowerCaseName);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            if (!field.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        return removed.size();
    }

    @Override
    public void setField(Field field) {
        String lowerCaseName = field.getName().toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null || l.isEmpty()) {
            this.addField(field);
            return;
        }
        l.clear();
        l.add(field);
        int firstOccurrence = -1;
        int index = 0;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field f = iterator.next();
            if (f.getName().equalsIgnoreCase(field.getName())) {
                iterator.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index;
                }
            }
            ++index;
        }
        this.fields.add(firstOccurrence, field);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        for (Field field : this.fields) {
            str.append(field.toString());
            str.append("\r\n");
        }
        return str.toString();
    }
}

