/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.sphincsplus.HarakaSBase;
import org.bouncycastle.pqc.crypto.sphincsplus.HarakaSXof;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HarakaS512Digest
extends HarakaSBase
implements Digest {
    public HarakaS512Digest(HarakaSXof harakaSXof) {
        this.haraka512_rc = harakaSXof.haraka512_rc;
    }

    @Override
    public String getAlgorithmName() {
        return "HarakaS-512";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public void update(byte by) {
        if (this.off + 1 > 64) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        this.buffer[this.off++] = by;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.off + n2 > 64) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        System.arraycopy(byArray, n, this.buffer, this.off, n2);
        this.off += n2;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[64];
        this.haraka512Perm(byArray2);
        for (int i = 0; i < 64; ++i) {
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ this.buffer[i]);
        }
        System.arraycopy(byArray2, 8, byArray, n, 8);
        System.arraycopy(byArray2, 24, byArray, n + 8, 8);
        System.arraycopy(byArray2, 32, byArray, n + 16, 8);
        System.arraycopy(byArray2, 48, byArray, n + 24, 8);
        this.reset();
        return byArray2.length;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

