/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.client;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.common.ScpHelper;
import org.apache.sshd.scp.common.helpers.ScpIoUtils;

public abstract class AbstractScpClient
extends AbstractLoggingBean
implements ScpClient {
    protected AbstractScpClient() {
    }

    public boolean isOpen() {
        ClientSession session = this.getSession();
        return session.isOpen();
    }

    @Override
    public void download(String[] remote, String local, Collection<ScpClient.Option> options) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty((String)local, (String)"Invalid argument local: %s", (Object)local);
        if ((remote = (String[])ValidateUtils.checkNotNullAndNotEmpty((Object[])remote, (String)"Invalid argument remote: %s", (Object[])new Object[]{remote})).length > 1) {
            options = this.addTargetIsDirectory(options);
        }
        for (String r : remote) {
            this.download(r, local, options);
        }
    }

    @Override
    public void download(String[] remote, Path local, Collection<ScpClient.Option> options) throws IOException {
        if ((remote = (String[])ValidateUtils.checkNotNullAndNotEmpty((Object[])remote, (String)"Invalid argument remote: %s", (Object[])new Object[]{remote})).length > 1) {
            options = this.addTargetIsDirectory(options);
        }
        for (String r : remote) {
            this.download(r, local, options);
        }
    }

    @Override
    public void download(String remote, Path local, Collection<ScpClient.Option> options) throws IOException {
        local = (Path)ValidateUtils.checkNotNull((Object)local, (String)"Invalid argument local: %s", (Object)local);
        remote = ValidateUtils.checkNotNullAndNotEmpty((String)remote, (String)"Invalid argument remote: %s", (Object)remote);
        LinkOption[] opts = IoUtils.getLinkOptions((boolean)true);
        if (Files.isDirectory(local, opts)) {
            options = this.addTargetIsDirectory(options);
        }
        if (options.contains((Object)ScpClient.Option.TargetIsDirectory)) {
            Boolean status = IoUtils.checkFileExists((Path)local, (LinkOption[])opts);
            if (status == null) {
                throw new SshException("Target directory " + local.toString() + " is probably inaccesible");
            }
            if (!status.booleanValue()) {
                throw new SshException("Target directory " + local.toString() + " does not exist");
            }
            if (!Files.isDirectory(local, opts)) {
                throw new SshException("Target directory " + local.toString() + " is not a directory");
            }
        }
        this.download(remote, local.getFileSystem(), local, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String remote, String local, Collection<ScpClient.Option> options) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty((String)local, (String)"Invalid argument local: %s", (Object)local);
        ClientSession session = this.getClientSession();
        ClientFactoryManager manager = session.getFactoryManager();
        FileSystemFactory factory = manager.getFileSystemFactory();
        FileSystem fs = factory.createFileSystem((SessionContext)session);
        try {
            this.download(remote, fs, fs.getPath(local, new String[0]), options);
        }
        catch (Throwable throwable) {
            block8: {
                try {
                    fs.close();
                }
                catch (UnsupportedOperationException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug("download({}) {} => {} - failed ({}) to close file system={}: {}", new Object[]{session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage()});
                }
            }
            throw throwable;
        }
        try {
            fs.close();
        }
        catch (UnsupportedOperationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("download({}) {} => {} - failed ({}) to close file system={}: {}", new Object[]{session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage()});
            }
        }
    }

    protected abstract void download(String var1, FileSystem var2, Path var3, Collection<ScpClient.Option> var4) throws IOException;

    @Override
    public void upload(String[] local, String remote, Collection<ScpClient.Option> options) throws IOException {
        List<Object> paths = Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty((Object[])local, (String)"Invalid argument local: %s", (Object[])new Object[]{local}));
        this.runUpload(remote, options, paths, (helper, local1, sendOptions) -> helper.send(local1, sendOptions.contains((Object)ScpClient.Option.Recursive), sendOptions.contains((Object)ScpClient.Option.PreserveAttributes), 8192));
    }

    @Override
    public void upload(Path[] local, String remote, Collection<ScpClient.Option> options) throws IOException {
        List<Object> paths = Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty((Object[])local, (String)"Invalid argument local: %s", (Object[])new Object[]{local}));
        this.runUpload(remote, options, paths, (helper, local1, sendOptions) -> helper.sendPaths(local1, sendOptions.contains((Object)ScpClient.Option.Recursive), sendOptions.contains((Object)ScpClient.Option.PreserveAttributes), 8192));
    }

    protected abstract <T> void runUpload(String var1, Collection<ScpClient.Option> var2, Collection<T> var3, ScpOperationExecutor<T> var4) throws IOException;

    protected void handleCommandExitStatus(String cmd, ClientChannel channel) throws IOException {
        ScpIoUtils.handleCommandExitStatus(this.getClientSession(), cmd, channel, (session, command, status) -> this.handleCommandExitStatus(command, status), this.log);
    }

    protected void handleCommandExitStatus(String cmd, Integer exitStatus) throws IOException {
        ScpIoUtils.handleCommandExitStatus(this.getClientSession(), cmd, exitStatus, this.log);
    }

    protected Collection<ScpClient.Option> addTargetIsDirectory(Collection<ScpClient.Option> options) {
        if (GenericUtils.isEmpty(options) || !options.contains((Object)ScpClient.Option.TargetIsDirectory)) {
            options = GenericUtils.isEmpty(options) ? EnumSet.noneOf(ScpClient.Option.class) : GenericUtils.of(options);
            options.add(ScpClient.Option.TargetIsDirectory);
        }
        return options;
    }

    protected ChannelExec openCommandChannel(ClientSession session, String cmd) throws IOException {
        return ScpIoUtils.openCommandChannel(session, cmd, this.log);
    }

    @FunctionalInterface
    public static interface ScpOperationExecutor<T> {
        public void execute(ScpHelper var1, Collection<T> var2, Collection<ScpClient.Option> var3) throws IOException;
    }
}

