/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class AxisParentRecord
extends Record {
    public static final short sid = 4161;
    private short field_1_axisType;
    public static final short AXIS_TYPE_MAIN = 0;
    public static final short AXIS_TYPE_SECONDARY = 1;
    private int field_2_x;
    private int field_3_y;
    private int field_4_width;
    private int field_5_height;

    public AxisParentRecord() {
    }

    public AxisParentRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public AxisParentRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4161) {
            throw new RecordFormatException("Not a AxisParent record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_axisType = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_x = LittleEndian.getInt(data, pos + 2 + offset);
        this.field_3_y = LittleEndian.getInt(data, pos + 6 + offset);
        this.field_4_width = LittleEndian.getInt(data, pos + 10 + offset);
        this.field_5_height = LittleEndian.getInt(data, pos + 14 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AXISPARENT]\n");
        buffer.append("    .axisType             = ").append("0x").append(HexDump.toHex(this.getAxisType())).append(" (").append(this.getAxisType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .x                    = ").append("0x").append(HexDump.toHex(this.getX())).append(" (").append(this.getX()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .y                    = ").append("0x").append(HexDump.toHex(this.getY())).append(" (").append(this.getY()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .width                = ").append("0x").append(HexDump.toHex(this.getWidth())).append(" (").append(this.getWidth()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .height               = ").append("0x").append(HexDump.toHex(this.getHeight())).append(" (").append(this.getHeight()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/AXISPARENT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4161);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_axisType);
        LittleEndian.putInt(data, 6 + offset + pos, this.field_2_x);
        LittleEndian.putInt(data, 10 + offset + pos, this.field_3_y);
        LittleEndian.putInt(data, 14 + offset + pos, this.field_4_width);
        LittleEndian.putInt(data, 18 + offset + pos, this.field_5_height);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4161;
    }

    public Object clone() {
        AxisParentRecord rec = new AxisParentRecord();
        rec.field_1_axisType = this.field_1_axisType;
        rec.field_2_x = this.field_2_x;
        rec.field_3_y = this.field_3_y;
        rec.field_4_width = this.field_4_width;
        rec.field_5_height = this.field_5_height;
        return rec;
    }

    public short getAxisType() {
        return this.field_1_axisType;
    }

    public void setAxisType(short field_1_axisType) {
        this.field_1_axisType = field_1_axisType;
    }

    public int getX() {
        return this.field_2_x;
    }

    public void setX(int field_2_x) {
        this.field_2_x = field_2_x;
    }

    public int getY() {
        return this.field_3_y;
    }

    public void setY(int field_3_y) {
        this.field_3_y = field_3_y;
    }

    public int getWidth() {
        return this.field_4_width;
    }

    public void setWidth(int field_4_width) {
        this.field_4_width = field_4_width;
    }

    public int getHeight() {
        return this.field_5_height;
    }

    public void setHeight(int field_5_height) {
        this.field_5_height = field_5_height;
    }
}

