/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.util.Collection;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

class _ComponentUtils {
    private _ComponentUtils() {
    }

    static UIComponent findParentNamingContainer(UIComponent component, boolean returnRootIfNotFound) {
        UIComponent parent = component.getParent();
        if (returnRootIfNotFound && parent == null) {
            return component;
        }
        while (parent != null) {
            if (parent instanceof NamingContainer) {
                return parent;
            }
            if (returnRootIfNotFound) {
                UIComponent nextParent = parent.getParent();
                if (nextParent == null) {
                    return parent;
                }
                parent = nextParent;
                continue;
            }
            parent = parent.getParent();
        }
        return null;
    }

    static UniqueIdVendor findParentUniqueIdVendor(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UniqueIdVendor)) continue;
            return (UniqueIdVendor)parent;
        }
        return null;
    }

    static UIComponent getRootComponent(UIComponent component) {
        UIComponent parent;
        while ((parent = component.getParent()) != null) {
            component = parent;
        }
        return component;
    }

    static UIComponent findComponent(UIComponent findBase, String id, char separatorChar) {
        if (!(findBase instanceof NamingContainer) && _ComponentUtils.idsAreEqual(id, findBase, separatorChar)) {
            return findBase;
        }
        int facetCount = findBase.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : findBase.getFacets().values()) {
                if (!(facet instanceof NamingContainer)) {
                    UIComponent find = _ComponentUtils.findComponent(facet, id, separatorChar);
                    if (find == null) continue;
                    return find;
                }
                if (!_ComponentUtils.idsAreEqual(id, facet, separatorChar)) continue;
                return facet;
            }
        }
        int childCount = findBase.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)findBase.getChildren().get(i);
            if (!(child instanceof NamingContainer)) {
                UIComponent find = _ComponentUtils.findComponent(child, id, separatorChar);
                if (find == null) continue;
                return find;
            }
            if (!_ComponentUtils.idsAreEqual(id, child, separatorChar)) continue;
            return child;
        }
        if (findBase instanceof NamingContainer && _ComponentUtils.idsAreEqual(id, findBase, separatorChar)) {
            return findBase;
        }
        return null;
    }

    static UIComponent findComponentChildOrFacetFrom(UIComponent parent, String id, String innerExpr) {
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                UIComponent find;
                if (id.equals(facet.getId())) {
                    if (innerExpr == null) {
                        return facet;
                    }
                    if (!(facet instanceof NamingContainer) || (find = facet.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (facet instanceof NamingContainer || (find = _ComponentUtils.findComponentChildOrFacetFrom(facet, id, innerExpr)) == null) continue;
                return find;
            }
        }
        if (parent.getChildCount() > 0) {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent find;
                UIComponent child = (UIComponent)parent.getChildren().get(i);
                if (id.equals(child.getId())) {
                    if (innerExpr == null) {
                        return child;
                    }
                    if (!(child instanceof NamingContainer) || (find = child.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (child instanceof NamingContainer || (find = _ComponentUtils.findComponentChildOrFacetFrom(child, id, innerExpr)) == null) continue;
                return find;
            }
        }
        return null;
    }

    private static boolean idsAreEqual(String id, UIComponent cmp, char separatorChar) {
        return id.equals(cmp.getId());
    }

    private static boolean dynamicIdIsEqual(String dynamicId, String id) {
        return dynamicId.matches(id + ":[0-9]*");
    }

    static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        Collection facesMessages;
        FacesMessage facesMessage;
        String validatorMessage;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, (UIComponent)input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                input.setValid(false);
                validatorMessage = input.getValidatorMessage();
                if (validatorMessage != null) {
                    context.addMessage(input.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage));
                    continue;
                }
                facesMessage = e.getFacesMessage();
                if (facesMessage != null) {
                    context.addMessage(input.getClientId(context), facesMessage);
                }
                if ((facesMessages = e.getFacesMessages()) == null) continue;
                for (FacesMessage message : facesMessages) {
                    context.addMessage(input.getClientId(context), message);
                }
            }
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    validatorMessage = input.getValidatorMessage();
                    if (validatorMessage != null) {
                        context.addMessage(input.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage));
                    } else {
                        facesMessage = ((ValidatorException)cause).getFacesMessage();
                        if (facesMessage != null) {
                            context.addMessage(input.getClientId(context), facesMessage);
                        }
                        if ((facesMessages = ((ValidatorException)cause).getFacesMessages()) != null) {
                            for (FacesMessage message : facesMessages) {
                                context.addMessage(input.getClientId(context), message);
                            }
                        }
                    }
                }
                throw e;
            }
        }
    }

    static String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        _ComponentUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRendered(FacesContext facesContext, UIComponent uiComponent) {
        try {
            uiComponent.pushComponentToEL(facesContext, uiComponent);
            boolean bl = uiComponent.isRendered();
            return bl;
        }
        finally {
            uiComponent.popComponentFromEL(facesContext);
        }
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        _ComponentUtils.getPathToComponent(component.getParent(), buf);
    }
}

