/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;

public class ViewScopeContextualStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Object, ContextualInstanceInfo<?>> contextualInstances;
    private final Map<String, Object> nameBeanKeyMap;
    private transient BeanManager beanManager;
    private volatile transient boolean deactivated;

    public ViewScopeContextualStorage(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.contextualInstances = new HashMap();
        this.nameBeanKeyMap = new HashMap<String, Object>();
        this.deactivated = false;
    }

    public Map<Object, ContextualInstanceInfo<?>> getStorage() {
        return this.contextualInstances;
    }

    public Map<String, Object> getNameBeanKeyMap() {
        return this.nameBeanKeyMap;
    }

    public <T> T createContextualInstance(Contextual<T> bean, CreationalContext<T> creationalContext) {
        String name;
        Object beanKey = this.getBeanKey(bean);
        ContextualInstanceInfo<Object> instanceInfo = new ContextualInstanceInfo<Object>();
        instanceInfo.setCreationalContext(creationalContext);
        instanceInfo.setContextualInstance(bean.create(creationalContext));
        this.contextualInstances.put(beanKey, instanceInfo);
        if (bean instanceof Bean && (name = ((Bean)bean).getName()) != null) {
            this.nameBeanKeyMap.put(name, beanKey);
        }
        return instanceInfo.getContextualInstance();
    }

    public <T> Object getBeanKey(Contextual<T> bean) {
        return ((PassivationCapable)bean).getId();
    }

    public Contextual<?> getBean(FacesContext context, Object beanKey) {
        if (this.beanManager == null) {
            this.beanManager = CDIUtils.getBeanManager(context.getExternalContext());
        }
        return this.beanManager.getPassivationCapableBean((String)beanKey);
    }

    public boolean isActive() {
        return !this.deactivated;
    }

    public void deactivate() {
        this.deactivated = true;
    }
}

