/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.view.ViewScopeBeanHolder;
import org.apache.myfaces.cdi.view.ViewScopeContext;
import org.apache.myfaces.cdi.view.ViewScopeContextualKey;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorage;

public class ViewScopeCDIMap
implements Map<String, Object> {
    private String _viewScopeId;
    private ViewScopeContextualStorage storage;

    public ViewScopeCDIMap(FacesContext facesContext) {
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
        ViewScopeBeanHolder bean = CDIUtils.get(beanManager, ViewScopeBeanHolder.class);
        this._viewScopeId = bean.generateUniqueViewScopeId();
        this.storage = bean.getContextualStorage(beanManager, this._viewScopeId);
    }

    public ViewScopeCDIMap(FacesContext facesContext, String viewScopeId) {
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
        ViewScopeBeanHolder bean = CDIUtils.get(beanManager, ViewScopeBeanHolder.class);
        this._viewScopeId = viewScopeId;
        this.storage = bean.getContextualStorage(beanManager, this._viewScopeId);
    }

    private ViewScopeContextualStorage getStorage() {
        if (this.storage != null && !this.storage.isActivated()) {
            this.storage = null;
        }
        if (this.storage == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BeanManager beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
            ViewScopeBeanHolder bean = CDIUtils.get(beanManager, ViewScopeBeanHolder.class);
            this.storage = bean.getContextualStorage(beanManager, this._viewScopeId);
        }
        return this.storage;
    }

    private Map<String, Object> getNameBeanKeyMap() {
        return this.getStorage().getNameBeanKeyMap();
    }

    private Map<Object, ContextualInstanceInfo<?>> getCreationalContextInstances() {
        return this.getStorage().getStorage();
    }

    public String getViewScopeId() {
        return this._viewScopeId;
    }

    @Override
    public int size() {
        return this.getNameBeanKeyMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getNameBeanKeyMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNameBeanKeyMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : this.getCreationalContextInstances().entrySet()) {
                if (entry.getValue() == null || !value.equals(entry.getValue().getContextualInstance())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Object beanKey = this.getNameBeanKeyMap().get(key);
        if (beanKey != null) {
            ContextualInstanceInfo<?> info = this.getCreationalContextInstances().get(beanKey);
            return info == null ? null : info.getContextualInstance();
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        ViewScopeContextualKey beanKey = new ViewScopeContextualKey(key);
        this.getNameBeanKeyMap().put(key, beanKey);
        ContextualInstanceInfo<Object> info = new ContextualInstanceInfo<Object>();
        info.setContextualInstance(value);
        return this.getCreationalContextInstances().put(beanKey, info);
    }

    @Override
    public Object remove(Object key) {
        Object beanKey = this.getNameBeanKeyMap().remove(key);
        ContextualInstanceInfo<?> info = this.getCreationalContextInstances().remove(beanKey);
        return info == null ? null : info.getContextualInstance();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ViewScopeContextualStorage st;
        ViewScopeBeanHolder bean;
        BeanManager beanManager;
        boolean destroyed = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext())) != null && (bean = CDIUtils.get(beanManager, ViewScopeBeanHolder.class)) != null && (st = bean.getContextualStorage(beanManager, this._viewScopeId)) != null) {
            ViewScopeContext.destroyAllActive(st);
            this.storage = null;
            destroyed = true;
        }
        if (!destroyed) {
            ViewScopeContext.destroyAllActive(this.storage);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.getNameBeanKeyMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.getNameBeanKeyMap().size());
        for (Map.Entry<String, Object> entry : this.getNameBeanKeyMap().entrySet()) {
            ContextualInstanceInfo<?> info;
            if (entry.getValue() == null || (info = this.getCreationalContextInstances().get(entry.getValue())) == null) continue;
            values.add(info.getContextualInstance());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> values = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.getNameBeanKeyMap().entrySet()) {
            ContextualInstanceInfo<?> info;
            if (entry.getValue() == null || (info = this.getCreationalContextInstances().get(entry.getValue())) == null) continue;
            values.add(new EntryWrapper<String, Object>(entry));
        }
        return values;
    }

    private class EntryWrapper<String, Object>
    implements Map.Entry<String, Object> {
        private final Map.Entry<String, Object> entry;

        public EntryWrapper(Map.Entry<String, Object> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public Object getValue() {
            ContextualInstanceInfo info = (ContextualInstanceInfo)ViewScopeCDIMap.this.getCreationalContextInstances().get(this.entry.getValue());
            return info == null ? null : (Object)info.getContextualInstance();
        }

        @Override
        public Object setValue(Object value) {
            ContextualInstanceInfo<Object> info = (ContextualInstanceInfo<Object>)ViewScopeCDIMap.this.getCreationalContextInstances().get(this.entry.getValue());
            Object oldValue = null;
            if (info != null) {
                info.setContextualInstance(value);
            } else {
                info = new ContextualInstanceInfo<Object>();
                info.setContextualInstance(value);
                ViewScopeCDIMap.this.getCreationalContextInstances().put(this.entry.getValue(), info);
            }
            return oldValue;
        }
    }
}

