/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.event;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class SetPropertyActionListener
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression value;
    private boolean _transient;

    public SetPropertyActionListener() {
    }

    public SetPropertyActionListener(ValueExpression target, ValueExpression value) {
        this.target = target;
        this.value = value;
    }

    @Override
    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (this.target == null) {
            throw new AbortProcessingException("@target has not been set");
        }
        if (this.value == null) {
            throw new AbortProcessingException("@value has not been set");
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            throw new AbortProcessingException("FacesContext ctx is null");
        }
        ELContext ectx = ctx.getELContext();
        if (ectx == null) {
            throw new AbortProcessingException("ELContext ectx is null");
        }
        this.target.setValue(ectx, this.value.getValue(ectx));
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.target, this.value};
        return state;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.value = (ValueExpression)values[1];
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean trans) {
        this._transient = trans;
    }

    public ValueExpression getTarget() {
        return this.target;
    }

    public void setTarget(ValueExpression target) {
        this.target = target;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }
}

