/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.scope.conversation;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.security.SecurityViolation;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntry;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntryFactory;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.WindowContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupedConversationContext {
    protected BeanManager beanManager;
    private ConversationConfig conversationConfig;
    private boolean scopeBeanEventEnable = false;
    private boolean accessBeanEventEnable = false;
    private boolean unscopeBeanEventEnable = false;
    private static RuntimeException runtimeException = new RuntimeException();
    protected final boolean useFallback;

    protected AbstractGroupedConversationContext(BeanManager beanManager) {
        this.beanManager = beanManager;
        boolean useCreationFallback = true;
        for (StackTraceElement element : runtimeException.getStackTrace()) {
            if (!element.toString().contains("org.apache.webbeans.")) continue;
            useCreationFallback = false;
            break;
        }
        this.useFallback = useCreationFallback;
    }

    public <T> T create(Bean<T> bean, CreationalContext<T> creationalContext) {
        T scopedBean;
        if (this.useFallback && (scopedBean = this.resolve(bean)) != null) {
            return scopedBean;
        }
        this.lazyInitConversationConfig();
        WindowContextManager windowContextManager = this.resolveWindowContextManager();
        BeanEntry<T> beanEntry = this.resolveBeanEntryFactory().createBeanEntry(bean, creationalContext, this.scopeBeanEventEnable, this.accessBeanEventEnable, this.unscopeBeanEventEnable);
        this.scopeBeanEntry(windowContextManager, beanEntry);
        return beanEntry.getBeanInstance();
    }

    public <T> T resolve(Bean<T> bean) {
        WindowContextManager windowContextManager = this.resolveWindowContextManager();
        T foundBeanInstance = this.resolveBeanInstance(windowContextManager, bean);
        return foundBeanInstance;
    }

    protected abstract WindowContextManager resolveWindowContextManager();

    protected abstract BeanEntryFactory resolveBeanEntryFactory();

    protected abstract <T> T resolveBeanInstance(WindowContextManager var1, Bean<T> var2);

    protected abstract <T> void scopeBeanEntry(WindowContextManager var1, BeanEntry<T> var2);

    protected abstract ConversationConfig getConversationConfig();

    public abstract boolean isActive();

    protected abstract <T> Set<SecurityViolation> checkPermission(Bean<T> var1);

    private void lazyInitConversationConfig() {
        if (this.conversationConfig == null) {
            this.conversationConfig = this.getConversationConfig();
            this.scopeBeanEventEnable = this.conversationConfig.isScopeBeanEventEnabled();
            this.accessBeanEventEnable = this.conversationConfig.isAccessBeanEventEnabled();
            this.unscopeBeanEventEnable = this.conversationConfig.isUnscopeBeanEventEnabled();
        }
    }
}

