/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.parameter;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.factory.ClassMappingFactory;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationEntry;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationNames;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultValidationParameterFactory
implements ClassMappingFactory<Class, Class> {
    private Map<Class, Class> parameterMapping = new NullValueAwareConcurrentHashMap<Class, Class>(Class.class);

    @Override
    public Class create(Class source) {
        if (this.parameterMapping.containsKey(source)) {
            return this.parameterMapping.get(source);
        }
        Class result = this.tryToFindStaticConfig(source);
        if (result == null) {
            result = this.tryToFindGlobalParameter(source);
        }
        if (result == null) {
            result = source;
        }
        this.cacheMapping(source, result);
        return result;
    }

    private Class tryToFindGlobalParameter(Class source) {
        Object target = ExtValContext.getContext().getGlobalProperty(source.getName());
        if (target instanceof Class) {
            return (Class)target;
        }
        return null;
    }

    private Class tryToFindStaticConfig(Class source) {
        StaticConfiguration<String, String> config;
        Class result = null;
        Iterator<StaticConfiguration<String, String>> i$ = ExtValContext.getContext().getStaticConfiguration(StaticConfigurationNames.VALIDATION_PARAMETER_CONFIG).iterator();
        while (i$.hasNext() && (result = this.tryToMap(source, (config = i$.next()).getMapping())) == null) {
        }
        return result;
    }

    private Class tryToMap(Class source, List<StaticConfigurationEntry<String, String>> mapping) {
        Class target = null;
        for (StaticConfigurationEntry<String, String> entry : mapping) {
            if (!source.getName().equals(entry.getSource()) || (target = ClassUtils.tryToLoadClassForName(entry.getTarget())) == null) continue;
            break;
        }
        return target;
    }

    private void cacheMapping(Class source, Class target) {
        this.parameterMapping.put(source, target);
    }
}

