/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.baseval.strategy.SkipValidationStrategy;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class PropertyValidationUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyValidationUtils.class.getName());

    public static boolean isValidationSkipped(FacesContext facesContext, ValidationStrategy validationStrategy, MetaDataEntry metaDataEntry) {
        if (ExtValUtils.isSkipableValidationStrategy((Class)ProxyUtils.getUnproxiedClass(validationStrategy.getClass(), ValidationStrategy.class))) {
            Boolean skipValidation = (Boolean)metaDataEntry.getProperty("skip_validation", Boolean.class);
            if (Boolean.TRUE.equals(skipValidation)) {
                LOGGER.finest("validation of " + validationStrategy.getClass().getName() + " canceled");
                return true;
            }
        } else if (validationStrategy instanceof SkipValidationStrategy) {
            validationStrategy.validate(facesContext, null, metaDataEntry, null);
            return true;
        }
        return false;
    }
}

