<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
  -->

<!--
  - Stylesheet to expand xml entity references inline. 
  - 
  - This is a temporary workaround for a bug in the tlddoc application which means that
  - a (valid) xmlns attribute is rejected; tlddoc v1.3 only accepts input that (incorrectly)
  - puts the tld elements in no namespace. This stylesheet therefore generates a special
  - version of the tld for feeding to the tlddoc app, until such time as tlddoc is fixed.
  -->
<xsl:stylesheet version="1.1"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml"
      encoding="ISO-8859-1"
      doctype-public="-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN"
      doctype-system="http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd"
      indent="yes"/>

  <xsl:template match="*" priority="2">
    <!-- avoiding copy to get get rid of namespace attribute -->
    <xsl:element name="{name(.)}">
      <xsl:apply-templates select="@*|node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
