/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.application.ProjectStage;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugPhaseListener
implements PhaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(DebugPhaseListener.class);
    private static final String KEY = DebugPhaseListener.class.getName() + "_ID_";

    public void afterPhase(PhaseEvent phaseEvent) {
        boolean productionMode;
        FacesContext facesContext = phaseEvent.getFacesContext();
        boolean bl = productionMode = TobagoConfig.getInstance(facesContext).getProjectStage() == ProjectStage.Production;
        if (facesContext.getResponseComplete() || productionMode) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            Long start;
            Long end = System.currentTimeMillis();
            Map map = facesContext.getExternalContext().getRequestMap();
            map.put(KEY + phaseEvent.getPhaseId().getOrdinal() + "E", end);
            if (LOG.isTraceEnabled()) {
                LOG.trace("After Phase :" + phaseEvent.getPhaseId() + " Time=" + end);
            }
            if (LOG.isDebugEnabled()) {
                start = (Long)map.get(KEY + phaseEvent.getPhaseId().getOrdinal() + "S");
                LOG.debug("Phase " + phaseEvent.getPhaseId() + " needs " + (end - start) + " milliseconds");
            }
            if (phaseEvent.getPhaseId().getOrdinal() == 6) {
                if (LOG.isTraceEnabled()) {
                    HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    LOG.trace(" response Locale            = '" + response.getLocale() + "'");
                    LOG.trace(" response ContentType       = '" + response.getContentType() + "'");
                    LOG.trace(" response CharacterEncoding = '{" + response.getCharacterEncoding() + "}'");
                }
                if ((start = (Long)map.get(KEY + "1S")) != null) {
                    LOG.info("Total response time : " + (end - start) + " milliseconds");
                }
            }
            Iterator iterator = facesContext.getClientIdsWithMessages();
            while (iterator.hasNext()) {
                String clientId = (String)iterator.next();
                Iterator messageIterator = facesContext.getMessages(clientId);
                while (messageIterator.hasNext()) {
                    FacesMessage msg = (FacesMessage)messageIterator.next();
                    LOG.info(MessageFormat.format("Faces message found.\n  Component: {0} \n  Severity : {1}\n  Summary  : {2} \n  Detail   : {3}", clientId, msg.getSeverity(), msg.getSummary(), msg.getDetail()));
                }
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        boolean productionMode;
        FacesContext facesContext = phaseEvent.getFacesContext();
        boolean bl = productionMode = TobagoConfig.getInstance(facesContext).getProjectStage() == ProjectStage.Production;
        if (facesContext.getResponseComplete()) {
            LOG.info("Response is completed.");
            return;
        }
        if (productionMode) {
            LOG.warn("DebugPhaseListener disabled, because the project stage is 'production'.");
            return;
        }
        if (LOG.isInfoEnabled()) {
            PhaseId phaseId = phaseEvent.getPhaseId();
            if (LOG.isDebugEnabled() || phaseId.getOrdinal() == 1) {
                ExternalContext externalContext = facesContext.getExternalContext();
                if (LOG.isTraceEnabled() && PhaseId.RESTORE_VIEW == phaseId) {
                    Object request = externalContext.getRequest();
                    if (request instanceof HttpServletRequest) {
                        HttpServletRequest servletRequest = (HttpServletRequest)request;
                        LOG.trace("RequestURI = " + servletRequest.getRequestURI());
                    }
                    Map headerMap = externalContext.getRequestHeaderMap();
                    for (Object key : headerMap.keySet()) {
                        LOG.trace("Header : '" + key + "' = '" + headerMap.get(key) + "'");
                    }
                    Map parameterMap = externalContext.getRequestParameterMap();
                    for (Object key : parameterMap.keySet()) {
                        LOG.trace("Param  : '" + key + "' = '" + parameterMap.get(key) + "'");
                    }
                }
                Long start = System.currentTimeMillis();
                Map map = externalContext.getRequestMap();
                map.put(KEY + phaseId.getOrdinal() + "S", start);
                if (LOG.isDebugEnabled()) {
                    Long end = null;
                    int ordinal = phaseId.getOrdinal();
                    while (end == null && ordinal > 0) {
                        end = (Long)map.get(KEY + --ordinal + "E");
                    }
                    if (end != null) {
                        LOG.debug("Time between phases " + ordinal + " and " + phaseId.getOrdinal() + ": " + (start - end) + " milliseconds");
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Before Phase :" + phaseId + " Time=" + start);
                }
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

