/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectBoolean;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBooleanCheckboxRenderer
extends MessageLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectBooleanCheckboxRenderer.class);

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        UIInput input = (UIInput)component;
        if (ComponentUtils.isOutputOnly((UIComponent)input)) {
            return;
        }
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(input.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug("new value = '" + newValue + "'");
        }
        input.setSubmittedValue((Object)("true".equals(newValue) ? "true" : "false"));
        RenderUtils.decodeClientBehaviors(facesContext, (UIComponent)input);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISelectBoolean select = (AbstractUISelectBoolean)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = select.getClientId(facesContext);
        String fieldId = select.getFieldId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)select);
        boolean checked = "true".equals(currentValue);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey(select, true);
        String itemLabel = select.getItemLabel();
        Markup markup = select.getMarkup();
        writer.startElement(HtmlElements.DIV);
        if (select.isLabelLayoutSkip()) {
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        }
        writer.writeClassAttribute((CssItem)this.getTobagoClass(), this.getTobagoClass().createMarkup(markup), this.getOuterCssItems(facesContext, select), new CssItem[]{select.getCustomClass()});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.startElement(HtmlElements.INPUT);
        writer.writeClassAttribute(BootstrapClass.CUSTOM_CONTROL_INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
        writer.writeAttribute(HtmlAttributes.VALUE, "true", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, select.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, select.isRequired());
        HtmlRendererUtils.renderFocus(clientId, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.LABEL);
        writer.writeClassAttribute((CssItem)BootstrapClass.CUSTOM_CONTROL_LABEL, this.getCssItems(facesContext, select), new CssItem[0]);
        if (!disabled && label.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), clientId);
        }
        writer.writeAttribute(HtmlAttributes.FOR, fieldId, false);
        if (itemLabel != null && select.getLabel() == null && select.getAccessKey() != null) {
            if (itemLabel.contains(Character.toString(select.getAccessKey().charValue()))) {
                HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            }
        } else if (itemLabel != null) {
            writer.writeText(itemLabel);
        }
        writer.endElement(HtmlElements.LABEL);
    }

    protected TobagoClass getTobagoClass() {
        return TobagoClass.SELECT_BOOLEAN_CHECKBOX;
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISelectBoolean select = (AbstractUISelectBoolean)component;
        writer.endElement(HtmlElements.DIV);
    }

    protected CssItem[] getOuterCssItems(FacesContext facesContext, AbstractUISelectBoolean select) {
        return new CssItem[]{!select.isLabelLayoutSkip() ? BootstrapClass.COL_FORM_LABEL : null, BootstrapClass.CUSTOM_CONTROL, BootstrapClass.CUSTOM_CHECKBOX};
    }

    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUISelectBoolean select) {
        return null;
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        AbstractUISelectBoolean select = (AbstractUISelectBoolean)component;
        return select.getFieldId(facesContext);
    }
}

