/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISplitLayout;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitLayoutRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SplitLayoutRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        String clientId = component.getClientId();
        if (clientId.equals(sourceId)) {
            LOG.warn("todo update layout");
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISplitLayout splitLayout = (AbstractUISplitLayout)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = splitLayout.getMarkup();
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(splitLayout.getClientId(facesContext));
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(splitLayout.getMarkup()), false);
        writer.writeClassAttribute(BootstrapClass.D_FLEX, splitLayout.isHorizontal() ? BootstrapClass.FLEX_ROW : BootstrapClass.FLEX_COLUMN, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISplitLayout splitLayout = (AbstractUISplitLayout)component;
        List<UIComponent> components = ComponentUtils.findLayoutChildren((UIComponent)splitLayout);
        if (components.size() != 2) {
            LOG.warn("Illegal component count in splitLayout: {}", (Object)components.size());
        }
        components.get(0).encodeAll(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(splitLayout.isHorizontal() ? TobagoClass.SPLIT_LAYOUT__HORIZONTAL : TobagoClass.SPLIT_LAYOUT__VERTICAL);
        writer.endElement(HtmlElements.DIV);
        components.get(1).encodeAll(facesContext);
        if (components.get(0).isRendered() && components.get(1).isRendered()) {
            this.encodeHandle(facesContext, splitLayout);
        }
    }

    private void encodeHandle(FacesContext facesContext, AbstractUISplitLayout layout) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.SPAN);
    }
}

