/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnPanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnSelector;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.ShowPosition;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.model.SortedColumn;
import org.apache.myfaces.tobago.model.SortedColumnList;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetRenderer<T extends AbstractUISheet>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SUFFIX_WIDTHS = "::widths";
    private static final String SUFFIX_COLUMN_RENDERED = "::rendered";
    private static final String SUFFIX_SCROLL_POSITION = "::scrollPosition";
    private static final String SUFFIX_SELECTED = "::selected";
    private static final String SUFFIX_LAZY = ":pageActionlazy";
    private static final String SUFFIX_PAGE_ACTION = "pageAction";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String sourceId;
        List<AbstractUIColumnBase> columns = ((AbstractUISheet)component).getAllColumns();
        String clientId = component.getClientId(facesContext);
        String key = clientId + SUFFIX_WIDTHS;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        SheetState state = ((AbstractUISheet)component).getState();
        if (requestParameterMap.containsKey(key)) {
            String widths = (String)requestParameterMap.get(key);
            this.ensureColumnWidthsSize(state.getColumnWidths(), columns, JsonUtils.decodeIntegerArray(widths));
        }
        if (requestParameterMap.containsKey(key = clientId + SUFFIX_SELECTED)) {
            List<Integer> selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected = " + selected);
            }
            try {
                selectedRows = JsonUtils.decodeIntegerArray(selected);
            }
            catch (NumberFormatException e) {
                LOG.warn(selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            ComponentUtils.setAttribute(component, Attributes.selectedListString, selectedRows);
        }
        ((AbstractUISheet)component).setLazyUpdate((sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source")) != null && sourceId.equals(clientId + SUFFIX_LAZY));
        String value = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + SUFFIX_SCROLL_POSITION);
        if (value != null) {
            state.getScrollPosition().update(value);
        }
        RenderUtils.decodedStateOfTreeData(facesContext, component);
        this.decodeSheetAction(facesContext, (AbstractUISheet)component);
        this.decodeColumnAction(facesContext, columns);
    }

    private void decodeColumnAction(FacesContext facesContext, List<AbstractUIColumnBase> columns) {
        for (AbstractUIColumnBase column : columns) {
            boolean sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable);
            if (!sortable) continue;
            String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
            String columnId = column.getClientId(facesContext);
            String sorterId = columnId + "_" + "sorter";
            if (!sorterId.equals(sourceId)) continue;
            UIData data = (UIData)column.getParent();
            data.queueEvent((FacesEvent)new SortActionEvent(data, column));
        }
    }

    private void decodeSheetAction(FacesContext facesContext, AbstractUISheet component) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        String clientId = component.getClientId(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sourceId = '{}'", (Object)sourceId);
            LOG.debug("clientId = '{}'", (Object)clientId);
        }
        String sheetClientIdWithAction = clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + SUFFIX_PAGE_ACTION;
        if (sourceId != null && sourceId.startsWith(sheetClientIdWithAction)) {
            String actionString = sourceId.substring(sheetClientIdWithAction.length());
            int index = actionString.indexOf(45);
            SheetAction action = index != -1 ? SheetAction.valueOf(actionString.substring(0, index)) : SheetAction.valueOf(actionString);
            PageActionEvent event = null;
            switch (action) {
                case first: 
                case prev: 
                case next: 
                case last: {
                    event = new PageActionEvent((UIComponent)component, action);
                    break;
                }
                case toPage: 
                case toRow: 
                case lazy: {
                    int target;
                    String value;
                    event = new PageActionEvent((UIComponent)component, action);
                    if (index == -1) {
                        Map map = facesContext.getExternalContext().getRequestParameterMap();
                        value = (String)map.get(sourceId);
                    } else {
                        value = actionString.substring(index + 1);
                    }
                    try {
                        target = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Can't parse integer value for action " + action.name() + ": " + value);
                        break;
                    }
                    event.setValue(target);
                    break;
                }
            }
            if (event != null) {
                component.queueEvent((FacesEvent)event);
            }
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        String sheetId = component.getClientId(facesContext);
        Markup markup = component.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUIReload reload = ComponentUtils.getReloadFacet(component);
        UIComponent header = component.getHeader();
        if (header == null) {
            header = ComponentUtils.createComponent(facesContext, Tags.panel.componentType(), null, "_header");
            header.setTransient(true);
            List<AbstractUIColumnBase> columns = ((AbstractUISheet)component).getAllColumns();
            int i = 0;
            for (AbstractUIColumnBase column : columns) {
                if (!(column instanceof AbstractUIRow)) {
                    AbstractUIOut out = (AbstractUIOut)ComponentUtils.createComponent(facesContext, Tags.out.componentType(), RendererTypes.Out, "_col" + i);
                    out.setTransient(true);
                    ValueExpression valueExpression = column.getValueExpression(Attributes.label.getName());
                    if (valueExpression != null) {
                        out.setValueExpression(Attributes.value.getName(), valueExpression);
                    } else {
                        out.setValue(ComponentUtils.getAttribute((UIComponent)column, Attributes.label));
                    }
                    valueExpression = column.getValueExpression(Attributes.rendered.getName());
                    if (valueExpression != null) {
                        out.setValueExpression(Attributes.rendered.getName(), valueExpression);
                    } else {
                        out.setRendered(ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.rendered));
                    }
                    out.setLabelLayout(LabelLayout.skip);
                    header.getChildren().add(out);
                }
                ++i;
            }
            component.setHeader(header);
        }
        ((AbstractUISheet)component).init(facesContext);
        this.insideBegin(facesContext, HtmlElements.TOBAGO_SHEET);
        writer.startElement(HtmlElements.TOBAGO_SHEET);
        writer.writeIdAttribute(sheetId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeClassAttribute(component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        writer.writeAttribute(DataAttributes.SELECTION_MODE, ((AbstractUIData)component).getSelectable().name(), false);
        writer.writeAttribute(DataAttributes.FIRST, Integer.toString(component.getFirst()), false);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.ROWS, component.getRows());
        writer.writeAttribute(CustomAttributes.ROW_COUNT, Integer.toString(component.getRowCount()), false);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.LAZY, ((AbstractUISheet)component).isLazy());
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.LAZY_UPDATE, ((AbstractUISheet)component).getLazyUpdate());
        boolean autoLayout = ((AbstractUISheet)component).isAutoLayout();
        if (!autoLayout) {
            writer.writeAttribute(DataAttributes.LAYOUT, JsonUtils.encode(((AbstractUISheet)component).getColumnLayout(), "columns"), true);
        }
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        if (reload != null) {
            reload.encodeAll(facesContext);
        }
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractUIStyle)) continue;
            child.encodeAll(facesContext);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String sheetId = component.getClientId(facesContext);
        Selectable selectable = ((AbstractUIData)component).getSelectable();
        Application application = facesContext.getApplication();
        SheetState state = ((AbstractUISheet)component).getSheetState(facesContext);
        List<Integer> columnWidths = ((AbstractUISheet)component).getState().getColumnWidths();
        boolean definedColumnWidths = ((AbstractUISheet)component).getState().isDefinedColumnWidths();
        List<Integer> selectedRows = this.getSelectedRows((AbstractUISheet)component, state);
        List<AbstractUIColumnBase> columns = ((AbstractUISheet)component).getAllColumns();
        boolean autoLayout = ((AbstractUISheet)component).isAutoLayout();
        this.ensureColumnWidthsSize(columnWidths, columns, Collections.emptyList());
        if (!autoLayout) {
            this.encodeHiddenInput(writer, JsonUtils.encode(definedColumnWidths ? columnWidths : Collections.emptyList()), sheetId + SUFFIX_WIDTHS);
            ArrayList<Boolean> encodedRendered = new ArrayList<Boolean>();
            for (AbstractUIColumnBase column : columns) {
                if (column instanceof AbstractUIRow) continue;
                encodedRendered.add(column.isRendered());
            }
            this.encodeHiddenInput(writer, JsonUtils.encode(encodedRendered.toArray(new Boolean[0])), sheetId + SUFFIX_COLUMN_RENDERED);
        }
        this.encodeHiddenInput(writer, ((AbstractUISheet)component).getState().getScrollPosition().encode(), component.getClientId(facesContext) + SUFFIX_SCROLL_POSITION);
        if (selectable != Selectable.none) {
            this.encodeHiddenInput(writer, JsonUtils.encode(selectedRows), sheetId + SUFFIX_SELECTED);
        }
        if (((AbstractUISheet)component).isLazy()) {
            this.encodeHiddenInput(writer, null, sheetId + SUFFIX_LAZY);
        }
        ArrayList<Integer> expandedValue = ((AbstractUIData)component).isTreeModel() ? new ArrayList<Integer>() : null;
        this.encodeTableBody(facesContext, (AbstractUISheet)component, writer, sheetId, selectable, columnWidths, selectedRows, columns, autoLayout, (List<Integer>)expandedValue);
        if (((AbstractUISheet)component).isPagingVisible()) {
            ShowPosition showPositionPageRange;
            ShowPosition showPositionDirectLinks;
            writer.startElement(HtmlElements.FOOTER);
            ShowPosition showPositionRowRange = ((AbstractUISheet)component).getShowRowRange();
            if (showPositionRowRange != ShowPosition.none) {
                AbstractUILink command = this.ensurePagingCommand(facesContext, (AbstractUISheet)component, Facets.pagerRow.name(), SheetAction.toRow.name(), false);
                String pagerCommandId = command.getClientId(facesContext);
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute(this.cssForLeftCenterRight(showPositionRowRange), BootstrapClass.PAGINATION);
                writer.startElement(HtmlElements.LI);
                writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
                writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.setRow"), true);
                writer.startElement(HtmlElements.SPAN);
                writer.writeClassAttribute(TobagoClass.PAGING, BootstrapClass.PAGE_LINK);
                if (component.getRowCount() != 0) {
                    boolean unknown;
                    Locale locale = facesContext.getViewRoot().getLocale();
                    int first = component.getFirst() + 1;
                    int last1 = ((AbstractUISheet)component).hasRowCount() ? ((AbstractUISheet)component).getLastRowIndexOfCurrentPage() : -1;
                    boolean bl = unknown = !((AbstractUISheet)component).hasRowCount();
                    String key = unknown ? (first == last1 ? "sheet.rowX" : "sheet.rowXtoY") : (first == last1 ? "sheet.rowXofZ" : "sheet.rowXtoYofZ");
                    String inputMarker = "{#}";
                    Object[] args = new Object[]{"{#}", last1 == -1 ? "?" : Integer.valueOf(last1), unknown ? "" : Integer.valueOf(component.getRowCount())};
                    MessageFormat detail = new MessageFormat(ResourceUtils.getString(facesContext, key), locale);
                    String formatted = detail.format(args);
                    int pos = formatted.indexOf("{#}");
                    if (pos >= 0) {
                        writer.writeText(formatted.substring(0, pos));
                        writer.startElement(HtmlElements.SPAN);
                        writer.writeText(Integer.toString(first));
                        writer.endElement(HtmlElements.SPAN);
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeIdAttribute(pagerCommandId);
                        writer.writeNameAttribute(pagerCommandId);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                        int maxLength = Integer.toString(component.getRowCount()).length();
                        if (!unknown) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
                        }
                        writer.writeAttribute(HtmlAttributes.PATTERN, StringUtils.positiveNumberRegexp(maxLength), true);
                        writer.endElement(HtmlElements.INPUT);
                        writer.writeText(formatted.substring(pos + "{#}".length()));
                    } else {
                        writer.writeText(formatted);
                    }
                }
                ComponentUtils.removeFacet(component, Facets.pagerRow);
                writer.endElement(HtmlElements.SPAN);
                writer.endElement(HtmlElements.LI);
                writer.endElement(HtmlElements.UL);
            }
            if ((showPositionDirectLinks = ((AbstractUISheet)component).getShowDirectLinks()) != ShowPosition.none) {
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute(this.cssForLeftCenterRight(showPositionDirectLinks), BootstrapClass.PAGINATION);
                if (((AbstractUISheet)component).isShowDirectLinksArrows()) {
                    boolean disabled = ((AbstractUISheet)component).isAtBeginning();
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled, SheetAction.first, null, Icons.SKIP_START, null);
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled, SheetAction.prev, null, Icons.CARET_LEFT, null);
                }
                this.encodeDirectPagingLinks(facesContext, application, (AbstractUISheet)component);
                if (((AbstractUISheet)component).isShowDirectLinksArrows()) {
                    boolean disabled = ((AbstractUISheet)component).isAtEnd();
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled, SheetAction.next, null, Icons.CARET_RIGHT, null);
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled || !((AbstractUISheet)component).hasRowCount(), SheetAction.last, null, Icons.SKIP_END, null);
                }
                writer.endElement(HtmlElements.UL);
            }
            if ((showPositionPageRange = ((AbstractUISheet)component).getShowPageRange()) != ShowPosition.none) {
                AbstractUILink command = this.ensurePagingCommand(facesContext, (AbstractUISheet)component, Facets.pagerPage.name(), SheetAction.toPage.name(), false);
                String pagerCommandId = command.getClientId(facesContext);
                writer.startElement(HtmlElements.UL);
                writer.writeClassAttribute(this.cssForLeftCenterRight(showPositionPageRange), BootstrapClass.PAGINATION);
                if (((AbstractUISheet)component).isShowPageRangeArrows()) {
                    boolean disabled = ((AbstractUISheet)component).isAtBeginning();
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled, SheetAction.first, null, Icons.SKIP_START, null);
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled, SheetAction.prev, null, Icons.CARET_LEFT, null);
                }
                writer.startElement(HtmlElements.LI);
                writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
                writer.startElement(HtmlElements.SPAN);
                writer.writeClassAttribute(TobagoClass.PAGING, BootstrapClass.PAGE_LINK);
                writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.setPage"), true);
                if (component.getRowCount() != 0) {
                    int pages;
                    Locale locale = facesContext.getViewRoot().getLocale();
                    int first = ((AbstractUISheet)component).getCurrentPage() + 1;
                    boolean unknown = !((AbstractUISheet)component).hasRowCount();
                    int n = pages = unknown ? -1 : ((AbstractUISheet)component).getPages();
                    String key = unknown ? (first == pages ? "sheet.pageX" : "sheet.pageXtoY") : (first == pages ? "sheet.pageXofZ" : "sheet.pageXtoYofZ");
                    String inputMarker = "{#}";
                    Object[] args = new Object[]{"{#}", pages == -1 ? "?" : Integer.valueOf(pages)};
                    MessageFormat detail = new MessageFormat(ResourceUtils.getString(facesContext, key), locale);
                    String formatted = detail.format(args);
                    int pos = formatted.indexOf("{#}");
                    if (pos >= 0) {
                        writer.writeText(formatted.substring(0, pos));
                        writer.startElement(HtmlElements.SPAN);
                        writer.writeText(Integer.toString(first));
                        writer.endElement(HtmlElements.SPAN);
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeIdAttribute(pagerCommandId);
                        writer.writeNameAttribute(pagerCommandId);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                        if (!unknown) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, Integer.toString(pages).length());
                        }
                        writer.endElement(HtmlElements.INPUT);
                        writer.writeText(formatted.substring(pos + "{#}".length()));
                    } else {
                        writer.writeText(formatted);
                    }
                }
                ComponentUtils.removeFacet(component, Facets.pagerPage);
                writer.endElement(HtmlElements.SPAN);
                writer.endElement(HtmlElements.LI);
                if (((AbstractUISheet)component).isShowPageRangeArrows()) {
                    boolean disabled = ((AbstractUISheet)component).isAtEnd();
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled, SheetAction.next, null, Icons.CARET_RIGHT, null);
                    this.encodeLink(facesContext, (AbstractUISheet)component, application, disabled || !((AbstractUISheet)component).hasRowCount(), SheetAction.last, null, Icons.SKIP_END, null);
                }
                writer.endElement(HtmlElements.UL);
            }
            writer.endElement(HtmlElements.FOOTER);
        }
        if (((AbstractUIData)component).isTreeModel()) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            String expandedId = sheetId + "::" + "expanded";
            writer.writeNameAttribute(expandedId);
            writer.writeIdAttribute(expandedId);
            writer.writeClassAttribute(TobagoClass.EXPANDED);
            writer.writeAttribute(HtmlAttributes.VALUE, JsonUtils.encode(expandedValue), false);
            writer.endElement(HtmlElements.INPUT);
        }
        writer.endElement(HtmlElements.TOBAGO_SHEET);
        UIComponent header = component.getHeader();
        if (header.isTransient()) {
            component.getFacets().remove("header");
        }
        this.insideEnd(facesContext, HtmlElements.TOBAGO_SHEET);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeTableBody(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, String sheetId, Selectable selectable, List<Integer> columnWidths, List<Integer> selectedRows, List<AbstractUIColumnBase> columns, boolean autoLayout, List<Integer> expandedValue) throws IOException {
        ExpandedState expandedState;
        boolean showHeader = sheet.isShowHeader();
        Markup sheetMarkup = sheet.getMarkup() != null ? sheet.getMarkup() : Markup.NULL;
        ExpandedState expandedState2 = expandedState = sheet.isTreeModel() ? sheet.getExpandedState() : null;
        if (showHeader && !autoLayout) {
            writer.startElement(HtmlElements.HEADER);
            writer.startElement(HtmlElements.TABLE);
            writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
            writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
            writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
            writer.writeClassAttribute(BootstrapClass.TABLE, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, TobagoClass.TABLE_LAYOUT__FIXED);
            this.writeColgroup(writer, columnWidths, columns, true);
            writer.startElement(HtmlElements.THEAD);
            this.encodeHeaderRows(facesContext, sheet, writer, columns);
            writer.endElement(HtmlElements.THEAD);
            writer.endElement(HtmlElements.TABLE);
            writer.endElement(HtmlElements.HEADER);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.BODY);
        writer.startElement(HtmlElements.TABLE);
        writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
        writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
        writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
        writer.writeClassAttribute(BootstrapClass.TABLE, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.STRIPED) ? BootstrapClass.TABLE_STRIPED : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.HOVER) ? BootstrapClass.TABLE_HOVER : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, !autoLayout ? TobagoClass.TABLE_LAYOUT__FIXED : null);
        if (showHeader && autoLayout) {
            writer.startElement(HtmlElements.THEAD);
            this.encodeHeaderRows(facesContext, sheet, writer, columns);
            writer.endElement(HtmlElements.THEAD);
        }
        if (!autoLayout) {
            this.writeColgroup(writer, columnWidths, columns, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("first = " + sheet.getFirst() + "   rows = " + sheet.getRows());
        }
        writer.startElement(HtmlElements.TBODY);
        String var = sheet.getVar();
        boolean emptySheet = true;
        int last = sheet.isRowsUnlimited() ? Integer.MAX_VALUE : sheet.getFirst() + sheet.getRows();
        for (int rowIndex = sheet.getFirst(); rowIndex < last; ++rowIndex) {
            void var23_26;
            sheet.setRowIndex(rowIndex);
            if (!sheet.isRowAvailable()) break;
            Object rowRendered = sheet.getAttributes().get("rowRendered");
            if (rowRendered instanceof Boolean && !((Boolean)rowRendered).booleanValue()) continue;
            emptySheet = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("var       " + var);
                LOG.debug("list      " + sheet.getValue());
            }
            if (sheet.isTreeModel()) {
                TreePath treePath = sheet.getPath();
                if (sheet.isFolder() && expandedState.isExpanded(treePath)) {
                    expandedValue.add(rowIndex);
                }
            }
            writer.startElement(HtmlElements.TR);
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.ROW_INDEX, rowIndex);
            boolean bl = selectedRows.contains(rowIndex);
            String parentId = sheet.getRowParentClientId();
            if (parentId != null) {
                writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
            }
            AbstractUIRow row = null;
            for (UIColumn uIColumn : columns) {
                if (!uIColumn.isRendered() || !(uIColumn instanceof AbstractUIRow)) continue;
                row = (AbstractUIRow)uIColumn;
            }
            writer.writeIdAttribute(row != null ? row.getClientId(facesContext) : sheet.getRowClientId());
            writer.writeClassAttribute(bl ? TobagoClass.SELECTED : null, bl ? BootstrapClass.TABLE_INFO : null, row != null ? row.getCustomClass() : null, sheet.isRowVisible() ? null : BootstrapClass.D_NONE);
            int colSpan = 0;
            Object var23_29 = null;
            for (AbstractUIColumnBase column : columns) {
                if (!column.isRendered()) continue;
                if (column instanceof AbstractUIColumn || column instanceof AbstractUIColumnSelector || column instanceof AbstractUIColumnNode) {
                    ++colSpan;
                    writer.startElement(HtmlElements.TD);
                    Markup markup = column.getMarkup();
                    if (markup == null) {
                        markup = Markup.NULL;
                    }
                    writer.writeClassAttribute(BootstrapClass.textAlign(column instanceof AbstractUIColumn ? ((AbstractUIColumn)column).getAlign() : null), BootstrapClass.verticalAlign(column instanceof AbstractUIColumn ? ((AbstractUIColumn)column).getVerticalAlign() : null), column.getCustomClass());
                    if (column instanceof AbstractUIColumnSelector) {
                        AbstractUIColumnSelector selector = (AbstractUIColumnSelector)column;
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeNameAttribute(sheetId + "_data_row_selector_" + rowIndex);
                        if (selectable.isSingle()) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                        } else {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                        }
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, bl);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, selector.isDisabled());
                        writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INLINE, TobagoClass.SELECTED);
                        writer.endElement(HtmlElements.INPUT);
                    } else {
                        column.encodeAll(facesContext);
                    }
                    writer.endElement(HtmlElements.TD);
                    continue;
                }
                if (!(column instanceof AbstractUIColumnPanel)) continue;
                AbstractUIColumnPanel abstractUIColumnPanel = (AbstractUIColumnPanel)column;
            }
            ++colSpan;
            writer.startElement(HtmlElements.TD);
            writer.startElement(HtmlElements.DIV);
            writer.endElement(HtmlElements.DIV);
            this.encodeBehavior(writer, facesContext, row);
            writer.endElement(HtmlElements.TD);
            writer.endElement(HtmlElements.TR);
            if (var23_26 == null) continue;
            writer.startElement(HtmlElements.TR);
            writer.writeClassAttribute(var23_26.getCustomClass());
            writer.startElement(HtmlElements.TD);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, colSpan);
            var23_26.encodeAll(facesContext);
            writer.endElement(HtmlElements.TD);
            writer.endElement(HtmlElements.TR);
        }
        sheet.setRowIndex(-1);
        if (emptySheet && showHeader) {
            writer.startElement(HtmlElements.TR);
            int countColumns = 0;
            for (UIColumn uIColumn : columns) {
                if (uIColumn instanceof AbstractUIRow) continue;
                ++countColumns;
            }
            writer.startElement(HtmlElements.TD);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, countColumns);
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.TEXT_CENTER);
            writer.writeText(ResourceUtils.getString(facesContext, "sheet.empty"));
            writer.endElement(HtmlElements.DIV);
            writer.endElement(HtmlElements.TD);
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
        }
        writer.endElement(HtmlElements.TBODY);
        writer.endElement(HtmlElements.TABLE);
        writer.endElement(HtmlElements.DIV);
    }

    private void encodeHiddenInput(TobagoResponseWriter writer, String value, String idWithSuffix) throws IOException {
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(idWithSuffix);
        writer.writeNameAttribute(idWithSuffix);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, value, false);
        writer.endElement(HtmlElements.INPUT);
    }

    private void ensureColumnWidthsSize(List<Integer> columnWidths, List<AbstractUIColumnBase> columns, List<Integer> samples) {
        int i = 0;
        int j = 0;
        for (AbstractUIColumnBase column : columns) {
            Integer newValue;
            if (column instanceof AbstractUIRow) continue;
            if (j < samples.size()) {
                newValue = samples.get(j);
                ++j;
            } else {
                newValue = null;
            }
            if (columnWidths.size() > i) {
                if (newValue != null) {
                    columnWidths.set(i, newValue);
                }
            } else {
                columnWidths.add(newValue != null ? newValue : -1);
            }
            ++i;
        }
    }

    private void encodeHeaderRows(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, List<AbstractUIColumnBase> columns) throws IOException {
        Selectable selectable = sheet.getSelectable();
        Grid grid = sheet.getHeaderGrid();
        boolean autoLayout = sheet.isAutoLayout();
        boolean multiHeader = grid.getRowCount() > 1;
        int offset = 0;
        for (int i = 0; i < grid.getRowCount(); ++i) {
            writer.startElement(HtmlElements.TR);
            AbstractUIRow row = ComponentUtils.findChild((UIComponent)sheet, AbstractUIRow.class);
            if (row != null) {
                writer.writeClassAttribute(row.getCustomClass());
            }
            for (int j = 0; j < columns.size(); ++j) {
                AbstractUIColumnBase column = columns.get(j);
                if (!column.isRendered() || column instanceof AbstractUIRow) {
                    ++offset;
                    continue;
                }
                Cell cell = grid.getCell(j - offset, i);
                if (!(cell instanceof OriginCell)) continue;
                writer.startElement(HtmlElements.TH);
                if (cell.getColumnSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, cell.getColumnSpan());
                }
                if (cell.getRowSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWSPAN, cell.getRowSpan());
                }
                UIComponent cellComponent = cell.getComponent();
                TextAlign align = multiHeader && cell.getColumnSpan() > 1 ? TextAlign.center : (column instanceof AbstractUIColumn ? ((AbstractUIColumn)column).getAlign() : null);
                writer.writeClassAttribute(BootstrapClass.textAlign(align), column.getCustomClass());
                writer.startElement(HtmlElements.SPAN);
                boolean sortable = false;
                boolean ascending = false;
                boolean descending = false;
                TobagoClass sortPosition = null;
                String tip = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.tip);
                CommandMap behaviorCommands = null;
                if (cell.getColumnSpan() == 1 && cellComponent instanceof AbstractUIOut && (sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable))) {
                    AbstractUILink sortCommand = (AbstractUILink)ComponentUtils.getFacet((UIComponent)column, Facets.sorter);
                    if (sortCommand == null) {
                        column.getClientId(facesContext);
                        String sorterId = column.getId() + "_" + "sorter";
                        sortCommand = (AbstractUILink)ComponentUtils.createComponent(facesContext, Tags.link.componentType(), RendererTypes.Link, sorterId);
                        sortCommand.setTransient(true);
                        AjaxBehavior reloadBehavior = this.createReloadBehavior(sheet);
                        sortCommand.addClientBehavior("click", (ClientBehavior)reloadBehavior);
                        ComponentUtils.setFacet((UIComponent)column, Facets.sorter, (UIComponent)sortCommand);
                    }
                    writer.writeIdAttribute(sortCommand.getClientId(facesContext));
                    behaviorCommands = this.getBehaviorCommands(facesContext, sortCommand);
                    ComponentUtils.removeFacet((UIComponent)column, Facets.sorter);
                    tip = tip == null ? "" : tip + " - ";
                    tip = tip + ResourceUtils.getString(facesContext, "sheet.sorting");
                    SheetState sheetState = sheet.getSheetState(facesContext);
                    SortedColumnList sortedColumnList = sheetState.getSortedColumnList();
                    int index = sortedColumnList.indexOf(column.getId());
                    if (index >= 0) {
                        if (sortedColumnList.isShowNumbers()) {
                            switch (index) {
                                case 0: {
                                    sortPosition = TobagoClass.CIRCLE__1;
                                    break;
                                }
                                case 1: {
                                    sortPosition = TobagoClass.CIRCLE__2;
                                    break;
                                }
                                case 2: {
                                    sortPosition = TobagoClass.CIRCLE__3;
                                    break;
                                }
                                case 3: {
                                    sortPosition = TobagoClass.CIRCLE__4;
                                    break;
                                }
                                case 4: {
                                    sortPosition = TobagoClass.CIRCLE__5;
                                    break;
                                }
                                case 5: {
                                    sortPosition = TobagoClass.CIRCLE__6;
                                    break;
                                }
                                case 6: {
                                    sortPosition = TobagoClass.CIRCLE__7;
                                    break;
                                }
                                case 7: {
                                    sortPosition = TobagoClass.CIRCLE__8;
                                    break;
                                }
                                case 8: {
                                    sortPosition = TobagoClass.CIRCLE__9;
                                    break;
                                }
                                default: {
                                    LOG.warn("Index {} not supported!", (Object)index);
                                }
                            }
                        }
                        SortedColumn sortedColumn = sortedColumnList.get(index);
                        if (Objects.equals(column.getId(), sortedColumn.getId())) {
                            String sortTitle;
                            if (sortedColumn.isAscending()) {
                                sortTitle = ResourceUtils.getString(facesContext, "sheet.ascending");
                                ascending = true;
                            } else {
                                sortTitle = ResourceUtils.getString(facesContext, "sheet.descending");
                                descending = true;
                            }
                            tip = tip + " - " + sortTitle;
                        }
                    }
                }
                writer.writeClassAttribute(sortable ? TobagoClass.SORTABLE : null, ascending ? TobagoClass.ASCENDING : null, descending ? TobagoClass.DESCENDING : null, sortPosition);
                writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
                this.encodeBehavior(writer, behaviorCommands);
                if (column instanceof AbstractUIColumnSelector && selectable.isMulti()) {
                    writer.startElement(HtmlElements.INPUT);
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                    writer.writeClassAttribute(TobagoClass.SELECTED);
                    writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.selectAll"), true);
                    writer.endElement(HtmlElements.INPUT);
                } else {
                    cellComponent.encodeAll(facesContext);
                }
                UIComponent bar = ComponentUtils.getFacet((UIComponent)column, Facets.bar);
                if (bar != null) {
                    this.insideBegin(facesContext, Facets.bar);
                    bar.encodeAll(facesContext);
                    this.insideEnd(facesContext, Facets.bar);
                }
                writer.endElement(HtmlElements.SPAN);
                if (!autoLayout && column.isResizable()) {
                    this.encodeResizing(writer, sheet, j - offset + cell.getColumnSpan() - 1);
                }
                writer.endElement(HtmlElements.TH);
            }
            if (!autoLayout) {
                this.encodeHeaderFiller(writer, sheet);
                this.encodeHeaderFiller(writer, sheet);
            }
            writer.endElement(HtmlElements.TR);
        }
    }

    private void encodeHeaderFiller(TobagoResponseWriter writer, AbstractUISheet sheet) throws IOException {
        writer.startElement(HtmlElements.TH);
        writer.startElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.TH);
    }

    private void writeColgroup(TobagoResponseWriter writer, List<Integer> columnWidths, List<AbstractUIColumnBase> columns, boolean isHeader) throws IOException {
        writer.startElement(HtmlElements.COLGROUP);
        int i = 0;
        for (AbstractUIColumnBase column : columns) {
            if (column instanceof AbstractUIRow) continue;
            if (column.isRendered()) {
                Integer width = columnWidths.get(i);
                this.writeCol(writer, width >= 0 ? width : null);
            }
            ++i;
        }
        this.writeCol(writer, null);
        if (isHeader) {
            this.writeCol(writer, null);
        }
        writer.endElement(HtmlElements.COLGROUP);
    }

    private void writeCol(TobagoResponseWriter writer, Integer columnWidth) throws IOException {
        writer.startElement(HtmlElements.COL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.WIDTH, columnWidth);
        writer.endElement(HtmlElements.COL);
    }

    private CssItem cssForLeftCenterRight(ShowPosition position) {
        switch (position) {
            case left: {
                return BootstrapClass.ME_AUTO;
            }
            case center: {
                return BootstrapClass.MX_AUTO;
            }
            case right: {
                return BootstrapClass.MS_AUTO;
            }
        }
        return null;
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(AbstractUISheet data, SheetState state) {
        List<Integer> selected = (List<Integer>)ComponentUtils.getAttribute((UIComponent)data, Attributes.selectedListString);
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private void encodeLink(FacesContext facesContext, AbstractUISheet data, Application application, boolean disabled, SheetAction action, Integer target, Icons icon, CssItem liClass) throws IOException {
        String facet = action == SheetAction.toPage || action == SheetAction.toRow ? action.name() + "-" + target : action.name();
        AbstractUILink command = this.ensurePagingCommand(facesContext, data, facet, facet, disabled);
        if (target != null) {
            ComponentUtils.setAttribute((UIComponent)command, Attributes.pagingTarget, target);
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        String message = ResourceUtils.getString(facesContext, action.getBundleKey());
        String tip = new MessageFormat(message, locale).format(new Integer[]{target});
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.LI);
        writer.writeClassAttribute(liClass, disabled ? BootstrapClass.DISABLED : null, BootstrapClass.PAGE_ITEM);
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.PAGE_LINK);
        writer.writeIdAttribute(command.getClientId(facesContext));
        writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        if (icon != null) {
            writer.startElement(HtmlElements.I);
            writer.writeClassAttribute(icon);
            writer.endElement(HtmlElements.I);
        } else {
            writer.writeText(String.valueOf(target));
        }
        if (!disabled) {
            this.encodeBehavior(writer, facesContext, command);
        }
        data.getFacets().remove(facet);
        writer.endElement(HtmlElements.BUTTON);
        writer.endElement(HtmlElements.LI);
    }

    private void encodeResizing(TobagoResponseWriter writer, AbstractUISheet sheet, int columnIndex) throws IOException {
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.RESIZE);
        writer.writeAttribute(DataAttributes.COLUMN_INDEX, Integer.toString(columnIndex), false);
        writer.write("&nbsp;&nbsp;");
        writer.endElement(HtmlElements.SPAN);
    }

    private void encodeDirectPagingLinks(FacesContext facesContext, Application application, AbstractUISheet sheet) throws IOException {
        int skip;
        int linkCount = ComponentUtils.getIntAttribute((UIComponent)sheet, Attributes.directLinkCount);
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = sheet.getCurrentPage() + 1;
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, page);
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = sheet.getCurrentPage() + 1;
        int pages = sheet.hasRowCount() || sheet.isRowsUnlimited() ? sheet.getPages() : Integer.MAX_VALUE;
        for (int i = 0; i < linkCount && page < pages; ++i) {
            if (++page <= 1) continue;
            nexts.add(page);
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (!sheet.isShowDirectLinksArrows() && skip > 1) {
            skip -= linkCount - linkCount / 2;
            if (--skip < 1) {
                skip = 1;
            }
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, skip, Icons.THREE_DOTS, null);
        }
        for (Integer prev : prevs) {
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, prev, null, null);
        }
        this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, sheet.getCurrentPage() + 1, null, BootstrapClass.ACTIVE);
        for (Integer next : nexts) {
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, next, null, null);
        }
        int n2 = skip = nexts.size() > 0 ? (Integer)nexts.get(nexts.size() - 1) : pages;
        if (!sheet.isShowDirectLinksArrows() && skip < pages) {
            skip += linkCount / 2;
            if (++skip > pages) {
                skip = pages;
            }
            this.encodeLink(facesContext, sheet, application, false, SheetAction.toPage, skip, Icons.THREE_DOTS, null);
        }
    }

    private AbstractUILink ensurePagingCommand(FacesContext facesContext, AbstractUISheet sheet, String facet, String id, boolean disabled) {
        Map facets = sheet.getFacets();
        AbstractUILink command = (AbstractUILink)facets.get(facet);
        if (command == null) {
            command = (AbstractUILink)ComponentUtils.createComponent(facesContext, Tags.link.componentType(), RendererTypes.Link, SUFFIX_PAGE_ACTION + id);
            command.setRendered(true);
            command.setDisabled(disabled);
            command.setTransient(true);
            facets.put(facet, command);
            AjaxBehavior behavior = this.createReloadBehavior(sheet);
            command.addClientBehavior("click", (ClientBehavior)behavior);
        }
        return command;
    }

    private AjaxBehavior createReloadBehavior(AbstractUISheet sheet) {
        AjaxBehavior reloadBehavior = this.findReloadBehavior(sheet);
        ArrayList<String> renderIds = new ArrayList<String>();
        renderIds.add(sheet.getId());
        if (reloadBehavior != null) {
            renderIds.addAll(reloadBehavior.getRender());
        }
        ArrayList<String> executeIds = new ArrayList<String>();
        executeIds.add(sheet.getId());
        if (reloadBehavior != null) {
            executeIds.addAll(reloadBehavior.getExecute());
        }
        AjaxBehavior behavior = new AjaxBehavior();
        behavior.setExecute(executeIds);
        behavior.setRender(renderIds);
        behavior.setTransient(true);
        return behavior;
    }

    private AjaxBehavior findReloadBehavior(ClientBehaviorHolder holder) {
        List reload = (List)holder.getClientBehaviors().get("reload");
        if (reload != null && !reload.isEmpty() && reload.get(0) instanceof AjaxBehavior) {
            return (AjaxBehavior)reload.get(0);
        }
        return null;
    }
}

