/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugResponseWriterWrapper
extends TobagoResponseWriter {
    private Stack<Object> stack = new Stack();
    private Set<MarkupLanguageAttributes> usedAttributes = new HashSet<MarkupLanguageAttributes>();
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TobagoResponseWriter responseWriter;

    public DebugResponseWriterWrapper(TobagoResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @Override
    public void write(String string) throws IOException {
        this.responseWriter.write(string);
    }

    @Override
    public void writeComment(Object comment) throws IOException {
        String commentStr = comment.toString();
        if (commentStr.indexOf("--") > 0) {
            LOG.error("Comment must not contain the sequence '--', comment = '" + comment + "'.", (Throwable)new IllegalArgumentException());
            commentStr = commentStr.replaceAll("--", "++");
        }
        this.responseWriter.writeComment(commentStr);
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        return new DebugResponseWriterWrapper((TobagoResponseWriter)this.responseWriter.cloneWithWriter(writer));
    }

    @Override
    @Deprecated
    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.responseWriter.writeAttribute(name, value, property);
    }

    @Override
    @Deprecated
    public void writeText(Object text, String property) throws IOException {
        this.responseWriter.writeText(text, property);
    }

    @Override
    public void flush() throws IOException {
        this.responseWriter.flush();
    }

    @Override
    public void writeAttribute(MarkupLanguageAttributes name, String value, boolean escape) throws IOException {
        this.responseWriter.writeAttribute(name, value, escape);
        if (this.usedAttributes.contains(name)) {
            LOG.error("Duplicate attribute '" + name + "' in element <" + this.stack.peek() + "> with value '" + value + "'!", (Throwable)new IllegalStateException());
        } else {
            this.usedAttributes.add(name);
        }
    }

    @Override
    public void writeAttribute(MarkupLanguageAttributes name, HtmlTypes types) throws IOException {
        this.responseWriter.writeAttribute(name, types);
        if (this.usedAttributes.contains(name)) {
            LOG.error("Duplicate attribute '" + name + "' in element <" + this.stack.peek() + "> with value '" + types + "'!", (Throwable)new IllegalStateException());
            this.usedAttributes.add(name);
        }
    }

    @Override
    public void writeURIAttribute(MarkupLanguageAttributes name, String string) throws IOException {
        this.responseWriter.writeURIAttribute(name, string);
        if (this.usedAttributes.contains(name)) {
            LOG.error("Duplicate attribute '" + name + "' in element <" + this.stack.peek() + "> with value '" + string + "'!", (Throwable)new IllegalStateException());
        } else {
            this.usedAttributes.add(name);
        }
    }

    public String getContentType() {
        return this.responseWriter.getContentType();
    }

    public String getCharacterEncoding() {
        return this.responseWriter.getCharacterEncoding();
    }

    public void startDocument() throws IOException {
        this.responseWriter.startDocument();
    }

    public void endDocument() throws IOException {
        this.responseWriter.endDocument();
    }

    @Override
    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.responseWriter.writeURIAttribute(name, value, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.responseWriter.writeText(text, off, len);
    }

    public void write(char[] chars, int i, int i1) throws IOException {
        this.responseWriter.write(chars, i, i1);
    }

    public void close() throws IOException {
        this.responseWriter.close();
    }

    @Override
    public void startElement(String name, UIComponent currentComponent) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("start element: '" + name + "'");
        }
        this.stack.push(name);
        this.responseWriter.startElement(name, currentComponent);
        this.usedAttributes.clear();
    }

    @Override
    public void startElement(HtmlElements name) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("start element: '" + (Object)((Object)name) + "'");
        }
        this.stack.push((Object)name);
        this.responseWriter.startElement(name);
        this.usedAttributes.clear();
    }

    @Override
    public void endElement(String name) throws IOException {
        Object top;
        if (LOG.isDebugEnabled()) {
            LOG.debug("end element: '" + name + "'");
        }
        try {
            top = this.stack.pop();
        }
        catch (EmptyStackException e) {
            LOG.error("Failed to close element \"" + name + "\"!", (Throwable)e);
            top = "*** failure ***";
        }
        if (!top.equals(name)) {
            LOG.error("Element end with name='" + name + "' doesn't match with top element on the stack='" + top + "'.", (Throwable)new IllegalArgumentException());
        }
        this.responseWriter.endElement(name);
    }

    @Override
    public void endElement(HtmlElements name) throws IOException {
        Object top;
        if (LOG.isDebugEnabled()) {
            LOG.debug("end element: '" + (Object)((Object)name) + "'");
        }
        try {
            top = this.stack.pop();
        }
        catch (EmptyStackException e) {
            LOG.error("Failed to close element \"" + (Object)((Object)name) + "\"!", (Throwable)e);
            top = "*** failure ***";
        }
        if (!top.equals((Object)name)) {
            String uri;
            try {
                uri = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getRequestURI();
            }
            catch (Exception e) {
                uri = null;
            }
            LOG.error("Element end with name='" + (Object)((Object)name) + "' doesn't match with top element on the stack='" + top + "'.  Stack='" + this.stack + "' URI='" + uri + "'", (Throwable)new IllegalArgumentException());
        }
        this.responseWriter.endElement(name);
    }
}

