/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.AbstractScheduleModel;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;

public class SimpleScheduleModel
extends AbstractScheduleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeSet entries;
    private final HashMap holidays;
    private final DateFormat holidayFormat = new SimpleDateFormat("yyyyMMdd");

    public SimpleScheduleModel() {
        this.entries = new TreeSet(new ScheduleEntryComparator());
        this.holidays = new HashMap();
    }

    public void setHoliday(Date date, String holidayName) {
        if (date == null) {
            return;
        }
        String key = this.holidayFormat.format(date);
        this.holidays.put(key, holidayName);
    }

    public void addEntry(ScheduleEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(ScheduleEntry entry) {
        this.entries.remove(entry);
    }

    public void removeSelectedEntry() {
        if (!this.isEntrySelected()) {
            return;
        }
        this.removeEntry(this.getSelectedEntry());
        this.setSelectedEntry(null);
        this.refresh();
    }

    protected Collection loadEntries(Date startDate, Date endDate) {
        ArrayList<ScheduleEntry> selection = new ArrayList<ScheduleEntry>();
        Iterator entryIterator = this.entries.iterator();
        while (entryIterator.hasNext()) {
            ScheduleEntry entry = (ScheduleEntry)entryIterator.next();
            if (entry.getEndTime().before(startDate) || entry.getStartTime().after(endDate)) continue;
            selection.add(entry);
        }
        return selection;
    }

    protected void loadDayAttributes(Day day) {
        if (day == null) {
            return;
        }
        String key = this.holidayFormat.format(day.getDate());
        String holiday = (String)this.holidays.get(key);
        if (holiday != null) {
            day.setSpecialDayName(holiday);
            day.setWorkingDay(false);
        } else {
            day.setSpecialDayName(null);
            day.setWorkingDay(true);
        }
    }
}

