/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.view;

import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.shared_tomahawk.application.InvalidViewIdException;

public abstract class ViewDeclarationLanguageBase
extends ViewDeclarationLanguage {
    public UIViewRoot createView(FacesContext context, String viewId) {
        this.checkNull(context, "context");
        try {
            viewId = this.calculateViewId(context, viewId);
            Application application = context.getApplication();
            UIViewRoot newViewRoot = (UIViewRoot)application.createComponent("javax.faces.ViewRoot");
            UIViewRoot oldViewRoot = context.getViewRoot();
            if (oldViewRoot == null) {
                ViewHandler handler = application.getViewHandler();
                newViewRoot.setLocale(handler.calculateLocale(context));
                newViewRoot.setRenderKitId(handler.calculateRenderKitId(context));
            } else {
                newViewRoot.setLocale(oldViewRoot.getLocale());
                newViewRoot.setRenderKitId(oldViewRoot.getRenderKitId());
            }
            newViewRoot.setViewId(viewId);
            return newViewRoot;
        }
        catch (InvalidViewIdException e) {
            this.sendSourceNotFound(context, e.getMessage());
            return null;
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.checkNull(context, "context");
        Application application = context.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(context);
        UIViewRoot viewRoot = application.getStateManager().restoreView(context, viewId, renderKitId);
        return viewRoot;
    }

    protected abstract String calculateViewId(FacesContext var1, String var2);

    protected abstract void sendSourceNotFound(FacesContext var1, String var2);

    protected void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }
}

