/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.CapabilityKey;
import org.apache.myfaces.trinidadinternal.agent.CapabilityValue;
import org.apache.myfaces.trinidadinternal.agent.parse.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.share.xml.TreeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CapabilityDataDocumentParser
extends BaseNodeParser
implements XMLConstants {
    private List<Object> _capList = new ArrayList<Object>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CapabilityDataDocumentParser.class);

    private CapabilityDataDocumentParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] parse(URL srcUrl) {
        if (srcUrl == null) {
            return new Object[0];
        }
        CapabilityDataDocumentParser parser = new CapabilityDataDocumentParser();
        InputStream stream = null;
        try {
            URLConnection connection = srcUrl.openConnection();
            stream = connection.getInputStream();
            InputSource source = new InputSource(stream);
            source.setSystemId(srcUrl.toExternalForm());
            ParseContextImpl pc = new ParseContextImpl();
            TreeBuilder builder = new TreeBuilder();
            Object[] objectArray = (Object[])builder.parse(null, source, pc, parser);
            return objectArray;
        }
        catch (SAXException saxe) {
            _LOG.severe("FAIL_PARSE_CAPABILITIES_DATA_DOCUMENT", (Throwable)saxe);
        }
        catch (IOException ioe) {
            _LOG.severe("FAIL_PARSE_CAPABILITIES_DATA_DOCUMENT", (Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return new Object[0];
    }

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!"http://myfaces.apache.org/trinidad/agent/capabilities".equals(namespaceURI)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_NAMESPACE", (Object)namespaceURI), context.getLocator());
        }
    }

    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if ("capability".equals(localName)) {
            String name = attrs.getValue("name");
            String value = attrs.getValue("value");
            if (name != null) {
                name = name.trim();
            }
            if (value != null) {
                value = value.trim();
            }
            if (name == null || name.length() <= 0 || value == null || value.length() <= 0) {
                _LOG.warning("ELEMENT_MISSING_ATTRIBUTES", (Object)"capabilities");
            }
            CapabilityKey key = CapabilityKey.getCapabilityKey(name, true);
            Object valueObject = CapabilityValue.getCapabilityValue(key, value);
            this._capList.add(key);
            this._capList.add(valueObject);
            return this;
        }
        return null;
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if ("capabilityData".equals(localName)) {
            return this._capList.toArray(new Object[this._capList.size()]);
        }
        return null;
    }
}

