/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.awt.Color;
import java.util.Map;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.cache.CacheKey;
import org.apache.myfaces.trinidadinternal.image.cache.CacheUtils;

public abstract class BaseColorizedIconKey
implements ImageProviderRequest,
CacheKey,
ImageConstants {
    private String _source;
    private int _direction;
    private Color _color;
    private Color _surroundingColor;
    private Class<?> _lookAndFeel;
    private static final int _MAP_SIZE = 5;
    private static final Color _NULL_COLOR = new Color(0, 0, 0);

    protected BaseColorizedIconKey(ImageContext context, Map<Object, Object> properties) {
        String source = (String)properties.get(SOURCE_KEY);
        Class lookAndFeel = (Class)properties.get(LAF_KEY);
        int direction = CacheUtils.getReadingDirection(context, properties);
        Color color = (Color)properties.get(this.getColorKey());
        Color surroundingColor = (Color)properties.get(SURROUNDING_COLOR_KEY);
        this._init(source, lookAndFeel, direction, color, surroundingColor);
    }

    protected BaseColorizedIconKey(ImageContext context, String source, Class<?> lookAndFeel, int direction, Color color, Color surroundingColor) {
        this._init(source, lookAndFeel, direction, color, surroundingColor);
    }

    @Deprecated
    protected BaseColorizedIconKey(ImageContext context, String source, int direction, Color color, Color surroundingColor) {
        this._init(source, null, direction, color, surroundingColor);
    }

    public abstract Object getColorKey();

    @Override
    public String getNamespaceURI() {
        return "http://myfaces.apache.org/uix/image";
    }

    @Override
    public String getLocalName() {
        return "colorizedIcon";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseColorizedIconKey)) {
            return false;
        }
        BaseColorizedIconKey key = (BaseColorizedIconKey)o;
        return this._source.equals(key._source) && this._direction == key._direction && this._color.equals(key._color) && this._surroundingColor.equals(key._surroundingColor) && this._lookAndFeel.equals(key._lookAndFeel);
    }

    public int hashCode() {
        return this._source.hashCode() | this._direction | this._color.hashCode() | this._surroundingColor.hashCode() | this._lookAndFeel.hashCode();
    }

    @Override
    public Map<Object, Object> getRenderProperties(ImageContext context) {
        ArrayMap properties = new ArrayMap(5);
        properties.put(ImageConstants.SOURCE_KEY, this.getSource());
        properties.put(this.getColorKey(), this.getColor());
        properties.put(SURROUNDING_COLOR_KEY, this._surroundingColor);
        properties.put(ImageConstants.DIRECTION_KEY, this._direction);
        properties.put(LAF_KEY, this._lookAndFeel);
        return properties;
    }

    protected String getSource() {
        return this._source;
    }

    protected Class<?> getLookAndFeel() {
        return this._lookAndFeel;
    }

    public final int getDirection() {
        return this._direction;
    }

    protected final Color getColor() {
        return this._color;
    }

    protected void setSource(String source) {
        this._source = source;
    }

    protected void setLookAndFeel(Class<?> lookAndFeel) {
        this._lookAndFeel = lookAndFeel;
    }

    protected void setDirection(int direction) {
        this._direction = direction;
    }

    protected void setColor(Color color) {
        this._color = color;
    }

    private void _init(String source, Class<?> lookAndFeel, int direction, Color color, Color surroundingColor) {
        this._lookAndFeel = lookAndFeel;
        this._source = source;
        this._direction = direction == 0 ? 1 : direction;
        this._color = color == null ? _NULL_COLOR : color;
        this._surroundingColor = surroundingColor == null || surroundingColor.getAlpha() == 0 ? CacheUtils.TRANSPARENT_COLOR : surroundingColor;
    }
}

