/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.util.ModeUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public class NameUtils {
    private static final String _DIRECTION_RTL = "rtl";
    private static final String _DIRECTION_LTR = "ltr";
    private static final String _PLATFORM_WINDOWS = "windows";
    private static final String _PLATFORM_MACOS = "macos";
    private static final String _PLATFORM_IPHONE = "iphone";
    private static final String _PLATFORM_LINUX = "linux";
    private static final String _PLATFORM_SOLARIS = "solaris";
    private static final String _PLATFORM_UNIX = "unix";
    private static final String _PLATFORM_PPC = "ppc";
    private static final String _PLATFORM_BLACKBERRY = "blackberry";
    private static final String _PLATFORM_NOKIA_S60 = "nokia_s60";
    private static final String _PLATFORM_GENERICPDA = "genericpda";
    private static final String _PLATFORM_ANDROID = "android";
    private static final String _ACC_HIGH_CONTRAST = "hc";
    private static final String _ACC_LARGE_FONTS = "lf";
    private static final String _UNKNOWN_NAME = "0";
    private static final char _VARIANT_SEPARATOR = '-';
    private static final int _LOCALE_MATCH_NONE = 0;
    private static final int _LOCALE_MATCH_LANGUAGE = 1;
    private static final int _LOCALE_MATCH_FULL = 2;

    private NameUtils() {
    }

    public static TrinidadAgent.Application getAgentApplication(String agentName) {
        if (agentName == null) {
            return TrinidadAgent.Application.UNKNOWN;
        }
        TrinidadAgent.Application application = TrinidadAgent.Application.fromAgentName(agentName);
        if (application == null) {
            assert (false) : "Invalid browser name: " + agentName;
            application = TrinidadAgent.Application.UNKNOWN;
        }
        return application;
    }

    public static int getDirection(String directionName) {
        int direction = 0;
        if (_DIRECTION_LTR.equals(directionName)) {
            direction = 1;
        } else if (_DIRECTION_RTL.equals(directionName)) {
            direction = 2;
        } else if (directionName != null) assert (false) : "Invalid direction name: " + directionName;
        return direction;
    }

    public static int getMode(String modeName) {
        int mode = 0;
        if ("standards".equals(modeName)) {
            mode = 1;
        } else if ("quirks".equals(modeName)) {
            mode = 2;
        } else if (modeName != null) assert (false) : "Invalid mode name" + modeName;
        return mode;
    }

    public static String getDirectionName(int direction) {
        String name = null;
        if (direction == 1) {
            name = _DIRECTION_LTR;
        } else if (direction == 2) {
            name = _DIRECTION_RTL;
        } else if (direction != 0) assert (false) : "Invalid direction id: " + direction;
        return name;
    }

    public static String getModeName(int mode) {
        String modeName = null;
        if (mode == 1) {
            modeName = "standards";
        } else if (mode == 2) {
            modeName = "quirks";
        } else if (mode != 0) assert (false) : "invalid mode id" + mode;
        return modeName;
    }

    public static int getPlatform(String platformName) {
        if (platformName == null) {
            return 0;
        }
        int platform = 0;
        if (_PLATFORM_WINDOWS.equals(platformName)) {
            platform = 1;
        } else if (_PLATFORM_MACOS.equals(platformName)) {
            platform = 2;
        } else if (_PLATFORM_IPHONE.equals(platformName)) {
            platform = 8;
        } else if (_PLATFORM_LINUX.equals(platformName)) {
            platform = 3;
        } else if (_PLATFORM_SOLARIS.equals(platformName)) {
            platform = 4;
        } else if (_PLATFORM_PPC.equals(platformName)) {
            platform = 6;
        } else if (_PLATFORM_BLACKBERRY.equals(platformName)) {
            platform = 7;
        } else if (_PLATFORM_NOKIA_S60.equals(platformName)) {
            platform = 9;
        } else if (_PLATFORM_GENERICPDA.equals(platformName)) {
            platform = 10;
        } else if (_PLATFORM_ANDROID.equals(platformName)) {
            platform = 11;
        } else if (!_PLATFORM_UNIX.equals(platformName)) assert (false) : "Invalid platform name: " + platformName;
        return platform;
    }

    public static String getPlatformName(int platform) {
        String name = null;
        switch (platform) {
            case 1: {
                name = _PLATFORM_WINDOWS;
                break;
            }
            case 2: {
                name = _PLATFORM_MACOS;
                break;
            }
            case 8: {
                name = _PLATFORM_IPHONE;
                break;
            }
            case 3: {
                name = _PLATFORM_LINUX;
                break;
            }
            case 4: {
                name = _PLATFORM_SOLARIS;
                break;
            }
            case 6: {
                name = _PLATFORM_PPC;
                break;
            }
            case 7: {
                name = _PLATFORM_BLACKBERRY;
                break;
            }
            case 9: {
                name = _PLATFORM_NOKIA_S60;
                break;
            }
            case 10: {
                name = _PLATFORM_GENERICPDA;
                break;
            }
            case 11: {
                name = _PLATFORM_ANDROID;
                break;
            }
            case 0: {
                break;
            }
            default: {
                assert (false) : "Invalid platform id: " + platform;
                break;
            }
        }
        return name;
    }

    public static String getContextName(StyleContext context) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NameUtils._getLocaleString(context));
        buffer.append('-');
        buffer.append(NameUtils._getDirectionString(context));
        buffer.append('-');
        buffer.append(NameUtils._getBrowserString(context));
        buffer.append('-');
        buffer.append(NameUtils._getVersionString(context));
        buffer.append('-');
        buffer.append(NameUtils._getPlatformString(context));
        buffer.append(NameUtils._getModeString(context));
        buffer.append('-');
        return buffer.toString();
    }

    public static String getContextName(StyleContext context, StyleSheetDocument document) {
        Iterator<StyleSheetNode> e = document.getStyleSheets(context);
        Vector<StyleSheetNode> v = new Vector<StyleSheetNode>();
        while (e.hasNext()) {
            v.addElement(e.next());
        }
        Object[] styleSheets = new StyleSheetNode[v.size()];
        v.copyInto(styleSheets);
        int localeMatch = NameUtils._isLocaleMatch(context, (StyleSheetNode[])styleSheets);
        boolean directionMatch = NameUtils._isDirectionMatch((StyleSheetNode[])styleSheets);
        boolean modeMatch = NameUtils._isModeMatch((StyleSheetNode[])styleSheets);
        boolean[] browserAndVersionMatch = NameUtils._isBrowserAndVersionMatch(context, (StyleSheetNode[])styleSheets);
        boolean browserMatch = browserAndVersionMatch[0];
        boolean versionMatch = browserAndVersionMatch[1];
        boolean platformMatch = NameUtils._isPlatformMatch(context, (StyleSheetNode[])styleSheets);
        boolean highContrastMatch = NameUtils._isHighContrastMatch(context, (StyleSheetNode[])styleSheets);
        boolean largeFontsMatch = NameUtils._isLargeFontsMatch(context, (StyleSheetNode[])styleSheets);
        boolean needSeparator = false;
        StringBuffer buffer = new StringBuffer();
        String documentId = NameUtils._getDocumentId(context, document);
        if (documentId != null) {
            buffer.append(documentId);
            needSeparator = true;
        }
        if (localeMatch != 0) {
            if (needSeparator) {
                buffer.append('-');
            }
            if (localeMatch == 1) {
                buffer.append(NameUtils._getLanguageString(context));
            } else {
                buffer.append(NameUtils._getLocaleString(context));
            }
            needSeparator = true;
        }
        if (directionMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getDirectionString(context));
            needSeparator = true;
        }
        if (browserMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getBrowserString(context));
            needSeparator = true;
        }
        if (versionMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getVersionString(context));
            needSeparator = true;
        }
        if (platformMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getPlatformString(context));
            needSeparator = true;
        }
        if (modeMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getModeString(context));
            needSeparator = true;
        }
        if (highContrastMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getHighContrastString(context));
            needSeparator = true;
        }
        if (largeFontsMatch) {
            if (needSeparator) {
                buffer.append('-');
            }
            buffer.append(NameUtils._getLargeFontsString(context));
            needSeparator = true;
        }
        return buffer.toString();
    }

    public static boolean isAccessibilityPropertyName(String name) {
        return "high-contrast".equals(name) || "large-fonts".equals(name);
    }

    private static String _getLocaleString(StyleContext context) {
        Locale locale = context.getLocaleContext().getTranslationLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale.toString();
    }

    private static String _getLanguageString(StyleContext context) {
        Locale locale = context.getLocaleContext().getTranslationLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale.getLanguage();
    }

    private static String _getDirectionString(StyleContext context) {
        int direction = LocaleUtils.getReadingDirection(context.getLocaleContext());
        String name = NameUtils.getDirectionName(direction);
        if (name == null) {
            return _UNKNOWN_NAME;
        }
        return name;
    }

    private static String _getModeString(StyleContext context) {
        String longModeString = ModeUtils.getCurrentMode(context);
        if (longModeString.equals("quirks")) {
            return "q";
        }
        return "s";
    }

    private static String _getBrowserString(StyleContext context) {
        TrinidadAgent.Application application = context.getAgent().getAgentApplication();
        return application.getApplicationName();
    }

    private static String _getDocumentId(StyleContext context, StyleSheetDocument document) {
        return document.getDocumentId(context);
    }

    private static String _getVersionString(StyleContext context) {
        TrinidadAgent agent = context.getAgent();
        String version = agent.getAgentVersion();
        if (version == null) {
            return _UNKNOWN_NAME;
        }
        return version;
    }

    private static String _getPlatformString(StyleContext context) {
        int platform = context.getAgent().getAgentOS();
        String name = NameUtils.getPlatformName(platform);
        if (name == null) {
            return _UNKNOWN_NAME;
        }
        return name;
    }

    private static String _getHighContrastString(StyleContext context) {
        if (context.getAccessibilityProfile().isHighContrast()) {
            return _ACC_HIGH_CONTRAST;
        }
        return _UNKNOWN_NAME;
    }

    private static String _getLargeFontsString(StyleContext context) {
        if (context.getAccessibilityProfile().isLargeFonts()) {
            return _ACC_LARGE_FONTS;
        }
        return _UNKNOWN_NAME;
    }

    private static int _isLocaleMatch(StyleContext context, StyleSheetNode[] styleSheets) {
        Locale locale = context.getLocaleContext().getTranslationLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (country.length() == 0) {
            country = null;
        }
        boolean languageMatch = false;
        for (int i = 0; i < styleSheets.length; ++i) {
            Collection<Locale> localeList = styleSheets[i].getLocales();
            for (Locale tmpLocale : localeList) {
                if (!language.equals(tmpLocale.getLanguage())) continue;
                languageMatch = true;
                if (country == null) {
                    return 1;
                }
                if (!country.equals(tmpLocale.getCountry())) continue;
                return 2;
            }
        }
        if (languageMatch) {
            return 1;
        }
        return 0;
    }

    private static boolean _isDirectionMatch(StyleSheetNode[] styleSheets) {
        for (int i = 0; i < styleSheets.length; ++i) {
            StyleSheetNode styleSheet = styleSheets[i];
            if (styleSheet.getReadingDirection() == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean _isModeMatch(StyleSheetNode[] styleSheets) {
        for (int i = 0; i < styleSheets.length; ++i) {
            StyleSheetNode styleSheet = styleSheets[i];
            if (styleSheet.getMode() == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean[] _isBrowserAndVersionMatch(StyleContext context, StyleSheetNode[] styleSheets) {
        TrinidadAgent agent = context.getAgent();
        TrinidadAgent.Application browser = agent.getAgentApplication();
        if (browser == TrinidadAgent.Application.UNKNOWN) {
            return new boolean[]{false, false};
        }
        boolean browserMatched = false;
        for (int i = 0; i < styleSheets.length; ++i) {
            AgentAtRuleMatcher agentMatcher = styleSheets[i].getAgentMatcher();
            if (agentMatcher != null) {
                Set<AgentAtRuleMatcher.Match> matches = agentMatcher.match(agent);
                if (!matches.contains((Object)AgentAtRuleMatcher.Match.APPLICATION)) continue;
                browserMatched = true;
                if (!matches.contains((Object)AgentAtRuleMatcher.Match.VERSION)) continue;
                return new boolean[]{true, true};
            }
            browserMatched = true;
        }
        return new boolean[]{browserMatched, false};
    }

    private static boolean _isPlatformMatch(StyleContext context, StyleSheetNode[] styleSheets) {
        int platform = context.getAgent().getAgentOS();
        if (platform == 0) {
            return false;
        }
        for (int i = 0; i < styleSheets.length; ++i) {
            if (styleSheets[i].getPlatforms().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean _isHighContrastMatch(StyleContext context, StyleSheetNode[] styleSheets) {
        if (!context.getAccessibilityProfile().isHighContrast()) {
            return false;
        }
        for (int i = 0; i < styleSheets.length; ++i) {
            if (!styleSheets[i].getAccessibilityProperties().contains("high-contrast")) continue;
            return true;
        }
        return false;
    }

    private static boolean _isLargeFontsMatch(StyleContext context, StyleSheetNode[] styleSheets) {
        if (!context.getAccessibilityProfile().isLargeFonts()) {
            return false;
        }
        for (int i = 0; i < styleSheets.length; ++i) {
            if (!styleSheets[i].getAccessibilityProperties().contains("large-fonts")) continue;
            return true;
        }
        return false;
    }
}

