/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.trinidad.component.UIXComponentRef;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.metadata.RegionMetadata;
import org.apache.myfaces.trinidadinternal.share.expl.Coercions;
import org.apache.myfaces.trinidadinternal.taglib.UIXComponentRefTag;

public class ComponentRefTag
extends UIXComponentRefTag {
    private static final String _REGION_TYPE_ATTRIBUTE = "org.apache.myfaces.trinidadinternal.taglib.RegionTag.regionType.old";
    private static final String _RELOCATED_FACETS_ATTRIBUTE = "org.apache.myfaces.trinidadinternal.taglib.RegionTag.facets.relocated";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ComponentRefTag.class);

    public String getComponentType() {
        return "org.apache.myfaces.trinidad.ComponentRef";
    }

    public String getRendererType() {
        return null;
    }

    public static void addRelocatedFacet(UIComponent region, String facet, UIComponent component) {
        HashMap<String, RelocatedFacet> map = (HashMap<String, RelocatedFacet>)region.getAttributes().get(_RELOCATED_FACETS_ATTRIBUTE);
        if (map == null) {
            map = new HashMap<String, RelocatedFacet>(3);
            region.getAttributes().put(_RELOCATED_FACETS_ATTRIBUTE, map);
        }
        StringBuffer findId = new StringBuffer(component.getId());
        for (UIComponent c = component.getParent(); c != region; c = c.getParent()) {
            if (!(c instanceof NamingContainer)) continue;
            findId.insert(0, ':');
            findId.insert(0, c.getId());
        }
        map.put(facet, new RelocatedFacet(component, findId.toString()));
    }

    public int doStartTag() throws JspException {
        int returnVal = super.doStartTag();
        UIComponent region = this.getComponentInstance();
        Map map = (Map)region.getAttributes().get(_RELOCATED_FACETS_ATTRIBUTE);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                String facet = (String)e.getKey();
                RelocatedFacet rf = (RelocatedFacet)e.getValue();
                rf.restoreFacet(region, facet);
            }
            map.clear();
        }
        return returnVal;
    }

    public int doEndTag() throws JspException {
        UIXComponentRef region = (UIXComponentRef)this.getComponentInstance();
        String regionType = region.getComponentType();
        if (regionType == null) {
            _LOG.severe("REQUIRE_COMPONENTTYPE_ATTRIBUTE");
        } else {
            _LOG.finest("componentType is:{0}", (Object)regionType);
            RegionMetadata rmd = RegionMetadata.getRegionMetadata(this.getFacesContext());
            RegionMetadata.ComponentMetaData cmd = (RegionMetadata.ComponentMetaData)rmd.getRegionConfig(regionType);
            if (cmd == null) {
                _LOG.severe("CANNOT_FIND_COMPONENTTYPE_METADATA_IN_REGION_METADATA", (Object)regionType);
            } else {
                boolean hasErrors = this._typeConvertAndDefaultAttrs(regionType, cmd);
                if (!hasErrors) {
                    String page = cmd.getJspUIDef();
                    _LOG.finest("Including page:{0}", (Object)page);
                    try {
                        if (page != null) {
                            String oldRegion = region.getAttributes().put(_REGION_TYPE_ATTRIBUTE, regionType);
                            if (!regionType.equals(oldRegion)) {
                                region.getChildren().clear();
                            }
                            this.pageContext.getRequest().getRequestDispatcher(page).include(this.pageContext.getRequest(), this.pageContext.getResponse());
                        } else {
                            _LOG.severe("NO_COMPONENTTYPE_JSPURI", (Object)regionType);
                        }
                    }
                    catch (IOException e) {
                        _LOG.severe((Throwable)e);
                        throw new JspException((Throwable)e);
                    }
                    catch (ServletException e) {
                        _LOG.severe(ComponentRefTag._unwrap(e));
                        throw new JspException((Throwable)e);
                    }
                }
            }
        }
        return super.doEndTag();
    }

    private boolean _typeConvertAndDefaultAttrs(String regionType, RegionMetadata.ComponentMetaData cmd) {
        boolean hasErrors = false;
        UIComponent region = this.getComponentInstance();
        Map compAttrs = region.getAttributes();
        List<RegionMetadata.AttributeMetaData> attrs = cmd.getAttributes();
        int sz = attrs.size();
        for (int i = 0; i < sz; ++i) {
            RegionMetadata.AttributeMetaData attr = attrs.get(i);
            String name = attr.getAttrName();
            Class<?> klass = attr.getAttrClass();
            if (region.getValueExpression(name) != null) continue;
            Object compValue = compAttrs.get(name);
            if (compValue == null) {
                String defaultValue = attr.getDefaultValue();
                if (defaultValue != null) {
                    hasErrors |= this._typeConvert(compAttrs, name, defaultValue, klass);
                    continue;
                }
                if (!attr.isRequired()) continue;
                _LOG.severe("COMPONENTTYPE_MISSING_ATTRIBUTE", new Object[]{name, regionType});
                hasErrors = true;
                continue;
            }
            if (!(compValue instanceof String)) continue;
            hasErrors |= this._typeConvert(compAttrs, name, (String)compValue, klass);
        }
        return hasErrors;
    }

    private boolean _typeConvert(Map<String, Object> compAttrs, String name, String value, Class<?> klass) {
        try {
            Object converted = Coercions.coerce(value, klass);
            compAttrs.put(name, converted);
            return false;
        }
        catch (IllegalArgumentException e) {
            _LOG.severe((Throwable)e);
            return true;
        }
    }

    private static Throwable _unwrap(Throwable t) {
        while (true) {
            Throwable causedBy = null;
            if (t instanceof JspException) {
                causedBy = ((JspException)t).getCause();
            } else if (t instanceof ServletException) {
                causedBy = ((ServletException)t).getCause();
            }
            if (causedBy == null || causedBy == t) {
                return t;
            }
            t = causedBy;
        }
    }

    private static final class RelocatedFacet
    implements Serializable {
        private final transient UIComponent _facet;
        private final String _findId;
        private static final long serialVersionUID = 1L;

        public RelocatedFacet(UIComponent facet, String findComponentId) {
            this._facet = facet;
            this._findId = findComponentId;
            assert (findComponentId != null);
        }

        public void restoreFacet(UIComponent region, String facet) {
            UIComponent relocatedFacet = this._facet;
            if (relocatedFacet == null) {
                relocatedFacet = region.findComponent(this._findId);
            }
            region.getFacets().put(facet, relocatedFacet);
        }
    }
}

