/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.core.output.CoreMessages;
import org.apache.myfaces.trinidadinternal.ui.BaseMutableUINode;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.beans.MarlinBean;
import org.apache.myfaces.trinidadinternal.ui.data.bind.ContextPropertyBoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.MessageBoxUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.MessageWrapper;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

@Deprecated
public class MessageBoxRenderer
extends HtmlLafRenderer {
    private static final Object _TEXT_PROPERTY = new Object();
    private static final Object _MESSAGE_TYPE_PROPERTY = new Object();
    private static MarlinBean _sHeader;
    private boolean _allMessages = true;
    private static final String _MESSAGE_BOX_LIST_FORMAT_KEY = "af_messages.LIST_FORMAT_private";
    private static final Map<String, String> _RESOURCE_KEY_MAP;

    @Override
    public void render(UIXRenderingContext context, UINode node) throws IOException {
        Object globalOnlyAttr = MessageBoxRenderer.getAttributeValue(context, node, GLOBAL_ONLY_ATTR, null);
        boolean bl = this._allMessages = !Boolean.TRUE.equals(globalOnlyAttr);
        if (MessageBoxUtils.sIsRendered(context, node, this._allMessages)) {
            super.render(context, node);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", node.getUIComponent());
            this.renderID(context, node);
            writer.endElement("span");
        }
    }

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        return "div";
    }

    @Override
    protected Object getStyleClass(UIXRenderingContext context, UINode node) {
        return "af|messages";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String messageType = MessageBoxUtils.sGetMaxType(context);
        Object text = MessageBoxRenderer.getAttributeValue(context, node, TEXT_ATTR, null);
        context.setProperty("http://myfaces.apache.org/uix/ui", _TEXT_PROPERTY, text);
        context.setProperty("http://myfaces.apache.org/uix/ui", _MESSAGE_TYPE_PROPERTY, messageType);
        Map<String, String> originalResourceKeyMap = context.getSkinResourceKeyMap();
        try {
            context.setSkinResourceKeyMap(_RESOURCE_KEY_MAP);
            _sHeader.render(context);
        }
        finally {
            context.setSkinResourceKeyMap(originalResourceKeyMap);
        }
        context.setProperty("http://myfaces.apache.org/uix/ui", _TEXT_PROPERTY, null);
        context.setProperty("http://myfaces.apache.org/uix/ui", _MESSAGE_TYPE_PROPERTY, null);
        Object message = MessageBoxUtils.sGetMessage(context, node);
        boolean useList = MessageBoxUtils.sMultipleMessages(context, this._allMessages);
        writer.startElement("div", null);
        MessageBoxRenderer.renderStyleClassAttribute(context, "af|messages::message-text");
        if (message != null) {
            writer.writeText(message, CoreMessages.MESSAGE_KEY.getName());
        }
        writer.endElement("div");
        if (useList) {
            writer.startElement("ol", null);
        } else {
            writer.startElement("div", null);
        }
        MessageBoxRenderer.renderStyleClassAttribute(context, "af|messages::list");
        this._renderMessages(context, writer, true, useList);
        if (this._allMessages) {
            this._renderMessages(context, writer, false, useList);
        }
        if (useList) {
            writer.endElement("ol");
        } else {
            writer.endElement("div");
        }
    }

    private void _renderMessages(UIXRenderingContext context, ResponseWriter writer, boolean isGlobal, boolean useList) throws IOException {
        Iterator<MessageWrapper> itr;
        BaseMutableUINode currentChild = null;
        Iterator<MessageWrapper> iterator = itr = isGlobal ? MessageBoxUtils.sGetGlobalsIterator(context) : MessageBoxUtils.sGetClientsIterator(context);
        while (itr.hasNext()) {
            MessageWrapper msg = itr.next();
            if (useList) {
                writer.startElement("li", null);
            }
            String summary = msg.getSummary();
            String detail = msg.getDetail();
            if (isGlobal) {
                this._writeGlobalMsg(context, writer, summary, detail);
            } else {
                currentChild = this._writeClientMsg(context, writer, summary, msg, currentChild);
            }
            if (!useList) continue;
            writer.endElement("li");
        }
    }

    private void _writeGlobalMsg(UIXRenderingContext context, ResponseWriter writer, String summary, String detail) throws IOException {
        String text = MessageUtils.getGlobalMessage(context, summary, detail);
        if (this.isTextFormatted(text)) {
            this.renderFormattedText(context, text);
        } else if (text != null) {
            writer.writeText((Object)text, null);
        }
    }

    private BaseMutableUINode _writeClientMsg(UIXRenderingContext context, ResponseWriter writer, String summary, MessageWrapper msg, BaseMutableUINode currentChild) throws IOException {
        String description;
        if (summary != null) {
            String[] parameters = new String[]{summary};
            String pattern = MessageBoxRenderer.getTranslatedString(context, _MESSAGE_BOX_LIST_FORMAT_KEY);
            description = this.formatString(context, pattern, parameters);
        } else {
            description = "";
        }
        currentChild = this._generateChild(msg, currentChild);
        currentChild.render(context);
        if (this.isTextFormatted(summary)) {
            this.renderFormattedText(context, description);
        } else if (description != null) {
            writer.writeText((Object)description, null);
        }
        return currentChild;
    }

    private BaseMutableUINode _generateChild(MessageWrapper msg, BaseMutableUINode cachedChild) {
        if (cachedChild == null) {
            cachedChild = new BaseMutableUINode("http://myfaces.apache.org/uix/ui", "link");
        }
        String label = msg.getLabel();
        cachedChild.setAttributeValue(TEXT_ATTR, label);
        String anchor = null;
        String summary = null;
        if (label != null) {
            anchor = MessageUtils.getAnchor(msg.getId().toString());
            if (anchor != null) {
                anchor = "#" + anchor;
            }
            summary = msg.getSummary();
        }
        cachedChild.setAttributeValue(DESTINATION_ATTR, anchor);
        cachedChild.setAttributeValue(LONG_DESC_ATTR, summary);
        return cachedChild;
    }

    static {
        MarlinBean header = new MarlinBean("header");
        header.setAttributeValue(TEXT_ATTR, new ContextPropertyBoundValue("http://myfaces.apache.org/uix/ui", _TEXT_PROPERTY));
        header.setAttributeValue(MESSAGE_TYPE_ATTR, new ContextPropertyBoundValue("http://myfaces.apache.org/uix/ui", _MESSAGE_TYPE_PROPERTY));
        _sHeader = header;
        _RESOURCE_KEY_MAP = new HashMap<String, String>();
        _RESOURCE_KEY_MAP.put("af_panelHeader.INFORMATION", "af_messages.INFORMATION");
        _RESOURCE_KEY_MAP.put("af_panelHeader.WARNING", "af_messages.WARNING");
        _RESOURCE_KEY_MAP.put("af_panelHeader.ERROR", "af_messages.ERROR");
        _RESOURCE_KEY_MAP.put("af_panelHeader.CONFIRMATION", "af_messages.CONFIRMATION");
        _RESOURCE_KEY_MAP.put("af|panelHeader::error-icon", "af|messages::error-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::warning-icon", "af|messages::warning-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::info-icon", "af|messages::info-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::confirmation-icon", "af|messages::confirmation-icon");
        _RESOURCE_KEY_MAP.put("af|panelHeader::error", "af|messages::error");
        _RESOURCE_KEY_MAP.put("af|panelHeader", "af|messages::header");
    }
}

