/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Config, IValueHolder, Optional, DomQuery, DQ } from "mona-dish";
/**
 * Extension which adds implementation specific
 * meta-data to our dom query
 *
 * Usage
 * el = new ExtDQ(oldReference)
 * nonce = el.nonce
 * windowId = el.getWindowId
 */
export declare class ExtDomQuery extends DQ {
    static get windowId(): string;
    static get nonce(): string;
    get windowId(): string | null;
    get nonce(): string | null;
    static searchJsfJsFor(item: RegExp): Optional<String>;
    /**
     * searches the embedded faces.js for items like separator char etc.
     * expects a match as variable under position 1 in the result match
     * @param regExp
     */
    searchJsfJsFor(regExp: RegExp): Optional<string>;
    globalEval(code: string, nonce?: string): DQ;
    globalEvalSticky(code: string, nonce?: string): DQ;
    /**
     * decorated run scripts which takes our jsf extensions into consideration
     * (standard DomQuery will let you pass anything)
     * @param sticky if set to true the internally generated element for the script is left in the dom
     * @param whiteListed
     */
    runScripts(sticky?: boolean, whiteListed?: (src: string) => boolean): DomQuery;
    /**
     * adds the elements in this ExtDomQuery to the head
     *
     * @param suppressDoubleIncludes checks for existing elements in the head before running the insert
     */
    runHeadInserts(suppressDoubleIncludes?: boolean): void;
    /**
     * byId producer
     *
     * @param selector id
     * @param deep whether the search should go into embedded shadow dom elements
     * @return a DomQuery containing the found elements
     */
    static byId(selector: string | DomQuery | Element, deep?: boolean): ExtDomQuery;
    private extractNonce;
    filter(func: (item: DomQuery) => boolean): ExtDomQuery;
}
export declare const ExtDQ: typeof ExtDomQuery;
/**
 * in order to reduce the number of interception points for the fallbacks we add
 * the namespace remapping straight to our config accessors
 */
export declare class ExtConfig extends Config {
    $nspEnabled: boolean;
    constructor(root: any);
    assignIf(condition: boolean, ...accessPath: any[]): IValueHolder<any>;
    assign(...accessPath: any[]): IValueHolder<any>;
    append(...accessPath: any[]): IValueHolder<any>;
    appendIf(condition: boolean, ...accessPath: any[]): IValueHolder<any>;
    getIf(...accessPath: any[]): Config;
    get(defaultVal: any): Config;
    delete(key: string): Config;
    /**
     * creates a config from an initial value or null
     * @param value
     */
    static fromNullable<T>(value?: T | null): Config;
    protected getClass(): any;
    /**
     * shallow copy getter, copies only the first level, references the deeper nodes
     * in a shared manner
     */
    protected shallowCopy$(): Config;
    /**
     * deep copy, copies all config nodes
     */
    get deepCopy(): Config;
    /**
     * helper to remap the namespaces of an array of access paths
     * @param accessPath the access paths to be remapped
     * @private returns an array of access paths with version remapped namespaces
     */
    private remap;
}
