/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.File;
import java.lang.reflect.Method;
import org.zeroturnaround.zip.ZTFilePermissions;
import org.zeroturnaround.zip.ZTFilePermissionsStrategy;
import org.zeroturnaround.zip.ZTZipReflectionUtil;
import org.zeroturnaround.zip.ZipException;

class Java6FileApiPermissionsStrategy
implements ZTFilePermissionsStrategy {
    private final Method canExecuteMethod = ZTZipReflectionUtil.getDeclaredMethod(File.class, "canExecute", new Class[0]);
    private final Method setExecutableMethod = ZTZipReflectionUtil.getDeclaredMethod(File.class, "setExecutable", Boolean.TYPE, Boolean.TYPE);
    private final Method setWritableMethod;
    private final Method setReadableMethod = ZTZipReflectionUtil.getDeclaredMethod(File.class, "setReadable", Boolean.TYPE, Boolean.TYPE);

    public Java6FileApiPermissionsStrategy() throws ZipException {
        this.setWritableMethod = ZTZipReflectionUtil.getDeclaredMethod(File.class, "setWritable", Boolean.TYPE, Boolean.TYPE);
    }

    @Override
    public ZTFilePermissions getPermissions(File file) {
        ZTFilePermissions permissions = new ZTFilePermissions();
        permissions.setDirectory(file.isDirectory());
        if (this.canExecute(file)) {
            permissions.setOwnerCanExecute(true);
        }
        if (file.canWrite()) {
            permissions.setOwnerCanWrite(true);
            if (file.isDirectory()) {
                permissions.setGroupCanWrite(true);
                permissions.setOthersCanWrite(true);
            }
        }
        if (file.canRead()) {
            permissions.setOwnerCanRead(true);
            permissions.setGroupCanRead(true);
            permissions.setOthersCanRead(true);
        }
        return permissions;
    }

    @Override
    public void setPermissions(File file, ZTFilePermissions permissions) {
        this.setExecutable(file, permissions.isOwnerCanExecute(), !permissions.isGroupCanExecute() && !permissions.isOthersCanExecute());
        this.setWritable(file, permissions.isOwnerCanWrite(), !permissions.isGroupCanWrite() && !permissions.isOthersCanWrite());
        this.setReadable(file, permissions.isOwnerCanRead(), !permissions.isGroupCanRead() && !permissions.isOthersCanRead());
    }

    private boolean setExecutable(File file, boolean executable, boolean ownerOnly) {
        return (Boolean)ZTZipReflectionUtil.invoke(this.setExecutableMethod, file, executable, ownerOnly);
    }

    private boolean setWritable(File file, boolean executable, boolean ownerOnly) {
        return (Boolean)ZTZipReflectionUtil.invoke(this.setWritableMethod, file, executable, ownerOnly);
    }

    private boolean setReadable(File file, boolean executable, boolean ownerOnly) {
        return (Boolean)ZTZipReflectionUtil.invoke(this.setReadableMethod, file, executable, ownerOnly);
    }

    private boolean canExecute(File file) {
        return (Boolean)ZTZipReflectionUtil.invoke(this.canExecuteMethod, file, new Object[0]);
    }
}

