/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Truncate to the specified precision")
@ScalarFunction(value="date_trunc")
public final class DateTrunc {
    private DateTrunc() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(packedEpochMillis);
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        epochMillis = DateTimeFunctions.getTimestampField(chronology, unit).roundFloor(epochMillis);
        return DateTimeEncoding.updateMillisUtc((long)epochMillis, (long)packedEpochMillis);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()));
        long epochMillis = timestamp.getEpochMillis();
        epochMillis = DateTimeFunctions.getTimestampField(chronology, unit).roundFloor(epochMillis);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)0, (short)timestamp.getTimeZoneKey());
    }
}

