/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.mimecontentconverter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.message.mimecontentconverter.IdentityConverter;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeContentConverterRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeContentConverterRegistry.class);
    private static final String SEQUENCED_MAP = "java.util.SequencedMap";
    private static final Map<String, MimeContentToObjectConverter> _mimeContentToObjectConverters;
    private static final Map<Class, List<ObjectToMimeContentConverter>> _classToMimeContentConverters;

    private MimeContentConverterRegistry() {
    }

    private static Map<Class, List<ObjectToMimeContentConverter>> buildClassToMimeConverters() {
        HashMap<Class<Void>, List<IdentityConverter>> classToMineConverters = new HashMap<Class<Void>, List<IdentityConverter>>();
        Iterable<ObjectToMimeContentConverter> objectToMimeContentConverters = new QpidServiceLoader().instancesOf(ObjectToMimeContentConverter.class);
        for (ObjectToMimeContentConverter converter : objectToMimeContentConverters) {
            Class objectClass = converter.getObjectClass();
            classToMineConverters.computeIfAbsent(objectClass, key -> new ArrayList()).add(converter);
            for (ObjectToMimeContentConverter existing : (List)classToMineConverters.get(objectClass)) {
                if (existing.getRank() != converter.getRank()) continue;
                LOGGER.warn("MIME converter for object class {} has two or more implementations with the same rank {}. It is undefined which one will be used. Implementations are: {} {} ", new Object[]{existing.getObjectClass().getName(), existing.getRank(), existing.getClass().getName(), converter.getClass().getName()});
            }
        }
        classToMineConverters.put(Void.class, List.of(new IdentityConverter()));
        return Map.copyOf(classToMineConverters);
    }

    private static Map<String, MimeContentToObjectConverter> buildMimeContentToObjectMap() {
        HashMap<String, MimeContentToObjectConverter> mimeContentToObjectConverters = new HashMap<String, MimeContentToObjectConverter>();
        for (MimeContentToObjectConverter converter : new QpidServiceLoader().instancesOf(MimeContentToObjectConverter.class)) {
            String mimeType = converter.getMimeType();
            MimeContentToObjectConverter existing = mimeContentToObjectConverters.put(mimeType, converter);
            if (existing == null) continue;
            LOGGER.warn("MIME converter {} for mime type '{}' replaced by {}.", new Object[]{existing.getClass().getName(), existing.getMimeType(), converter.getClass().getName()});
        }
        return Collections.unmodifiableMap(mimeContentToObjectConverters);
    }

    public static MimeContentToObjectConverter getMimeContentToObjectConverter(String mimeType) {
        return _mimeContentToObjectConverters.get(mimeType);
    }

    public static ObjectToMimeContentConverter getBestFitObjectToMimeContentConverter(Object object) {
        if (object == null) {
            return null;
        }
        List classes = Stream.of(object.getClass().getInterfaces()).flatMap(anInterface -> SEQUENCED_MAP.equals(anInterface.getName()) ? Stream.of(anInterface.getInterfaces()) : Stream.of(anInterface)).collect(Collectors.toList());
        classes.add(object.getClass());
        return MimeContentConverterRegistry.findBestConverter(object, classes.stream().flatMap(type -> _classToMimeContentConverters.getOrDefault(type, List.of()).stream()));
    }

    public static ObjectToMimeContentConverter getBestFitObjectToMimeContentConverter(Object object, Class<?> typeHint) {
        if (typeHint == null) {
            return null;
        }
        return MimeContentConverterRegistry.findBestConverter(object, _classToMimeContentConverters.getOrDefault(typeHint, List.of()).stream());
    }

    private static ObjectToMimeContentConverter findBestConverter(Object object, Stream<ObjectToMimeContentConverter> converters) {
        return converters.filter(candidate -> candidate.isAcceptable(object)).max(Comparator.comparing(ObjectToMimeContentConverter::getRank)).orElse(null);
    }

    static {
        _classToMimeContentConverters = MimeContentConverterRegistry.buildClassToMimeConverters();
        _mimeContentToObjectConverters = MimeContentConverterRegistry.buildMimeContentToObjectMap();
    }
}

