/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.model.Named;

class LegacyConfiguredObjectToMapConverter {
    private static final String STATISTICS_MAP_KEY = "statistics";
    private static final String NAME = "name";
    private static final String CONTEXT = "context";
    private final LegacyManagementController _managementMetadata;

    LegacyConfiguredObjectToMapConverter(LegacyManagementController managementMetadata) {
        this._managementMetadata = managementMetadata;
    }

    Map<String, Object> convertManageableToMap(LegacyConfiguredObject legacyConfiguredObjectObject, int depth, boolean actuals, int oversizeThreshold, boolean excludeInheritedContext) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        this.incorporateAttributesIntoMap(legacyConfiguredObjectObject, object, actuals, excludeInheritedContext, oversizeThreshold);
        this.incorporateStatisticsIntoMap(legacyConfiguredObjectObject, object);
        if (depth > 0) {
            this.incorporateChildrenIntoMap(legacyConfiguredObjectObject, object, depth, actuals, oversizeThreshold, excludeInheritedContext);
        }
        return object;
    }

    private void incorporateAttributesIntoMap(LegacyConfiguredObject confObject, Map<String, Object> object, boolean useActualValues, boolean excludeInheritedContext, int oversizeThreshold) {
        for (String name : confObject.getAttributeNames()) {
            Object value;
            Object object2 = value = useActualValues ? confObject.getActualAttribute(name) : confObject.getAttribute(name);
            if (value instanceof LegacyConfiguredObject) {
                object.put(name, ((LegacyConfiguredObject)value).getAttribute(NAME));
                continue;
            }
            if (CONTEXT.equals(name)) {
                Map<String, Object> contextValues = this.collectContext(confObject, excludeInheritedContext, useActualValues);
                if (contextValues.isEmpty()) continue;
                object.put(CONTEXT, contextValues);
                continue;
            }
            if (value instanceof Collection) {
                ArrayList<Object> converted = new ArrayList<Object>();
                for (Object member : (Collection)value) {
                    if (member instanceof LegacyConfiguredObject) {
                        converted.add(((LegacyConfiguredObject)member).getAttribute(NAME));
                        continue;
                    }
                    converted.add(member);
                }
                object.put(name, converted);
                continue;
            }
            if (value instanceof Named) {
                object.put(name, ((Named)value).getName());
                continue;
            }
            if (value == null) continue;
            if (confObject.isSecureAttribute(name)) {
                value = confObject.getAttribute(name);
            }
            if (confObject.isOversizedAttribute(name) && !useActualValues) {
                String valueString = String.valueOf(value);
                if (valueString.length() > oversizeThreshold) {
                    object.put(name, String.valueOf(value).substring(0, oversizeThreshold - 4) + "...");
                    continue;
                }
                object.put(name, value);
                continue;
            }
            object.put(name, value);
        }
    }

    private Map<String, Object> collectContext(LegacyConfiguredObject configuredObject, boolean excludeInheritedContext, boolean useActualValues) {
        HashMap<String, Object> actualContext = new HashMap<String, Object>();
        if (excludeInheritedContext) {
            Object value = configuredObject.getActualAttribute(CONTEXT);
            if (value instanceof Map) {
                actualContext.putAll((Map)value);
            }
        } else {
            actualContext.putAll(System.getenv());
            actualContext.putAll(System.getProperties());
            this.collectInheritedActualContext(configuredObject, actualContext);
        }
        if (useActualValues) {
            return actualContext;
        }
        HashMap<String, Object> effectiveContext = new HashMap<String, Object>();
        for (String contextKey : actualContext.keySet()) {
            effectiveContext.put(contextKey, configuredObject.getContextValue(contextKey));
        }
        return effectiveContext;
    }

    private void collectInheritedActualContext(LegacyConfiguredObject confObject, Map<String, Object> contextValues) {
        Object value;
        LegacyConfiguredObject parent;
        Collection<String> parents = this._managementMetadata.getParentTypes(confObject.getCategory());
        if (parents != null && !parents.isEmpty() && (parent = confObject.getParent(parents.iterator().next())) != null) {
            this.collectInheritedActualContext(parent, contextValues);
        }
        if ((value = confObject.getActualAttribute(CONTEXT)) instanceof Map) {
            contextValues.putAll((Map)value);
        }
    }

    private void incorporateStatisticsIntoMap(LegacyConfiguredObject confObject, Map<String, Object> object) {
        TreeMap<String, Object> statMap = new TreeMap<String, Object>(confObject.getStatistics());
        if (!statMap.isEmpty()) {
            object.put(STATISTICS_MAP_KEY, statMap);
        }
    }

    private void incorporateChildrenIntoMap(LegacyConfiguredObject confObject, Map<String, Object> object, int depth, boolean actuals, int oversizeThreshold, boolean excludeInheritedContext) {
        Collection<String> childTypes = this._managementMetadata.getChildrenCategories(confObject.getCategory());
        if (childTypes != null && !childTypes.isEmpty()) {
            ArrayList<String> types = new ArrayList<String>(childTypes);
            Collections.sort(types);
            for (String childType : types) {
                Collection<LegacyConfiguredObject> children = confObject.getChildren(childType);
                if (children == null || children.isEmpty()) continue;
                ArrayList<LegacyConfiguredObject> sortedChildren = new ArrayList<LegacyConfiguredObject>(children);
                sortedChildren.sort(Comparator.comparing(o -> (String)o.getAttribute(NAME)));
                List childObjects = sortedChildren.stream().sorted(Comparator.comparing(o -> (String)o.getAttribute(NAME))).map(child -> this.convertManageableToMap((LegacyConfiguredObject)child, depth - 1, actuals, oversizeThreshold, excludeInheritedContext)).collect(Collectors.toList());
                String childTypeSingular = childType.toLowerCase();
                object.put(childTypeSingular + (childTypeSingular.endsWith("s") ? "es" : "s"), childObjects);
            }
        }
    }
}

